/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public abstract class APTStringManager {
    private static final Map<String, APTStringManager> instances = Collections.synchronizedMap(new HashMap());
    private static final int STRING_MANAGER_DEFAULT_CAPACITY;
    private static final int STRING_MANAGER_DEFAULT_SLICED_NUMBER;
    static final String TEXT_MANAGER = "Manager of sharable texts";
    static final int TEXT_MANAGER_INITIAL_CAPACITY;
    static final String FILE_PATH_MANAGER = "Manager of sharable file paths";
    static final int FILE_PATH_MANAGER_INITIAL_CAPACITY;

    public abstract CharSequence getString(CharSequence var1);

    public abstract void dispose();

    public static APTStringManager instance(String string, CacheKind cacheKind) {
        switch (cacheKind) {
            case Single: {
                return APTStringManager.instance(string, STRING_MANAGER_DEFAULT_CAPACITY);
            }
            case Sliced: {
                return APTStringManager.instance(string, STRING_MANAGER_DEFAULT_SLICED_NUMBER, STRING_MANAGER_DEFAULT_CAPACITY);
            }
        }
        throw new IllegalArgumentException();
    }

    private static APTStringManager instance(String string, int n) {
        APTStringManager aPTStringManager = instances.get(string);
        if (aPTStringManager == null) {
            aPTStringManager = new APTSingleStringManager(string, n);
            instances.put(string, aPTStringManager);
        }
        return aPTStringManager;
    }

    private static APTStringManager instance(String string, int n, int n2) {
        APTStringManager aPTStringManager = instances.get(string);
        if (aPTStringManager == null) {
            aPTStringManager = new APTCompoundStringManager(string, n, n2);
            instances.put(string, aPTStringManager);
        }
        return aPTStringManager;
    }

    static {
        int n = CndUtils.getConcurrencyLevel();
        if (n <= 4) {
            STRING_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            STRING_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            STRING_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            STRING_MANAGER_DEFAULT_CAPACITY = 128;
        }
        TEXT_MANAGER_INITIAL_CAPACITY = STRING_MANAGER_DEFAULT_CAPACITY;
        FILE_PATH_MANAGER_INITIAL_CAPACITY = STRING_MANAGER_DEFAULT_CAPACITY;
    }

    static final class APTCompoundStringManager
    extends APTStringManager {
        private final APTStringManager[] instances;
        private final int segmentMask;
        private final String name;

        APTCompoundStringManager(String string, int n) {
            this(string, n, TEXT_MANAGER_INITIAL_CAPACITY);
        }

        APTCompoundStringManager(String string, int n, int n2) {
            int n3;
            for (n3 = 1; n3 < n; n3 <<= 1) {
            }
            this.segmentMask = n3 - 1;
            this.instances = new APTStringManager[n3];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleStringManager(string, n2);
            }
            this.name = string;
        }

        private APTStringManager getDelegate(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            int n = charSequence.hashCode() & this.segmentMask;
            return this.instances[n];
        }

        public final CharSequence getString(CharSequence charSequence) {
            return this.getDelegate(charSequence).getString(charSequence);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    static final class APTSingleStringManager
    extends APTStringManager {
        private final WeakSharedSet<CharSequence> storage;
        private final int initialCapacity;
        private final String name;
        private final Object lock = new Lock();

        private APTSingleStringManager(String string, int n) {
            this.storage = new WeakSharedSet(n);
            this.initialCapacity = n;
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final CharSequence getString(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            CharSequence charSequence2 = null;
            Object object = this.lock;
            synchronized (object) {
                charSequence2 = this.storage.addOrGet(charSequence);
            }
            assert (charSequence2 != null);
            assert (charSequence2.equals(charSequence));
            return charSequence2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dispose() {
            if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                Object[] objectArray;
                HashMap hashMap = this.lock;
                synchronized (hashMap) {
                    objectArray = this.storage.toArray();
                }
                System.out.println("Dispose cache " + this.name + " " + objectArray.length + " " + this.getClass().getName());
                hashMap = new HashMap();
                for (Object object : objectArray) {
                    if (object == null) continue;
                    Integer n = (Integer)hashMap.get(object.getClass());
                    n = n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1);
                    hashMap.put(object.getClass(), n);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                }
            }
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheKind {
        Single,
        Sliced;

    }
}

