/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbmodule;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class NbModuleProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String NBMODULE_PROJECT_NAMESPACE_2 = "http://www.netbeans.org/ns/nb-module-project/2";
    private static final String NBMODULE_PROJECT_NAMESPACE_3 = "http://www.netbeans.org/ns/nb-module-project/3";
    private static final String NBMODULE_SUITE_PROJECT_NAMESPACE = "http://www.netbeans.org/ns/nb-module-suite-project/1";
    private static final String PROJECT_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_ProjectCategory");
    private static final String LISTENERS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_ListenersCategory");
    private static final String PAINTERS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_PaintersCategory");
    private static final String IO_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_IoCategory");
    private static final String FILES_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_FilesCategory");
    private static final String SOCKETS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_SocketsCategory");
    private static final String TEST_TYPE_UNIT = "unit";
    private static final String TEST_TYPE_QA_FUNCTIONAL = "qa-functional";

    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        return SourceUtils.isTest((FileObject)fileObject);
    }

    public String getProfilerTargetName(Project project, FileObject fileObject, int n, FileObject fileObject2) {
        switch (n) {
            case 1: {
                return "profile";
            }
            case 4: {
                return "profile-test-single-nb";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_PROJECT_NAMESPACE_2, true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_PROJECT_NAMESPACE_3, true);
        }
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_SUITE_PROJECT_NAMESPACE, true);
        }
        return element != null;
    }

    public FileObject getProjectBuildScript(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        FileObject fileObject = project.getProjectDirectory();
        if (auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_SUITE_PROJECT_NAMESPACE, true) != null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("NB Suite " + fileObject.getPath()));
            }
            if (subprojectProvider == null) {
                return null;
            }
            Set set = subprojectProvider.getSubprojects();
            if (set.isEmpty()) {
                return null;
            }
            return this.getProjectJavaPlatform((Project)set.iterator().next());
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        List list = classPath.entries();
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("Boot CP " + classPath));
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("File " + fileObject.getPath()));
        }
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            JavaPlatform javaPlatform = javaPlatformArray[i];
            if (!((Object)list).equals(javaPlatform.getBootstrapLibraries().entries())) continue;
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("Platform " + javaPlatform.getDisplayName()));
            }
            return javaPlatform;
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)"Platform null");
        }
        return null;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject fileObject) {
        return true;
    }

    public boolean checkProjectIsModifiedForProfiler(Project project) {
        return true;
    }

    private static String getTestType(FileObject fileObject) {
        String string = fileObject.getPath();
        if (string.contains(TEST_TYPE_QA_FUNCTIONAL)) {
            return TEST_TYPE_QA_FUNCTIONAL;
        }
        return TEST_TYPE_UNIT;
    }

    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
        String string;
        if (fileObject != null) {
            string = SourceUtils.getToplevelClassName((FileObject)fileObject);
            properties.setProperty("profile.class", string);
            properties.setProperty("test.type", NbModuleProjectTypeProfiler.getTestType(fileObject));
        }
        if ((string = properties.getProperty("profiler.info.jvmargs.agent")).indexOf(32) != -1) {
            if (Utilities.isUnix()) {
                String string2 = Profiler.getDefault().getLibsDir();
                properties.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.fixLibsDirPath((String)string2, (String)string));
            } else if (Utilities.isWindows() && this.isNbSourceModule(project)) {
                string = "\"" + string + "\"";
                properties.setProperty("profiler.info.jvmargs.agent", string);
            }
        }
    }

    private boolean isNbSourceModule(Project project) {
        String string;
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", string = NBMODULE_PROJECT_NAMESPACE_3, true);
        if (element == null && (element = auxiliaryConfiguration.getConfigurationFragment("data", string = NBMODULE_PROJECT_NAMESPACE_2, true)) == null) {
            return false;
        }
        if (NbModuleProjectTypeProfiler.findElement(element, "suite-component", string) != null) {
            return false;
        }
        return NbModuleProjectTypeProfiler.findElement(element, "standalone", string) == null;
    }

    private static Element findElement(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            if ((string2 != null || !string.equals(element2.getTagName())) && (string2 == null || !string.equals(element2.getLocalName()) || !string2.equals(element2.getNamespaceURI()))) continue;
            return element2;
        }
        return null;
    }
}

