/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.MultiBundleStructure;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.Util;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    static final Logger LOG = Logger.getLogger(PropertiesDataObject.class.getName());
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;
    private Lookup lookup;

    public PropertiesDataObject(FileObject fileObject, PropertiesDataLoader propertiesDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)propertiesDataLoader);
        this.initialize();
    }

    PropertiesEncoding getEncoding() {
        return ((PropertiesDataLoader)this.getLoader()).getEncoding();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private void initialize() {
        this.bundleStructure = null;
        Class[] classArray = new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class};
        this.getCookieSet().add(classArray, (CookieSet.Factory)this);
        this.getCookieSet().assign(PropertiesEncoding.class, (Object[])new PropertiesEncoding[]{this.getEncoding()});
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)this.getOpenSupport());
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String string) throws IOException {
        boolean bl = false;
        MultiBundleStructure multiBundleStructure = (MultiBundleStructure)this.bundleStructure;
        FileObject fileObject = this.getPrimaryFile();
        PropertiesOpen propertiesOpen = (PropertiesOpen)this.getCookie(OpenCookie.class);
        if (propertiesOpen != null) {
            propertiesOpen.removeModifiedListener(this);
            propertiesOpen.close();
        }
        if (this.bundleStructure != null && this.bundleStructure.getEntryCount() > 1 && !Util.getBaseName(string).equals(Util.getBaseName(this.getName()))) {
            bl = true;
            this.bundleStructure = null;
            this.openSupport = null;
        }
        try {
            FileObject fileObject2 = super.handleRename(string);
            return fileObject2;
        }
        finally {
            if (bl && multiBundleStructure != null && ((BundleStructure)multiBundleStructure).getEntryCount() > 1) {
                ((BundleStructure)multiBundleStructure).updateEntries();
                multiBundleStructure.notifyOneFileChanged(fileObject);
            }
            this.bundleStructure = null;
            this.openSupport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleCopy(" + FileUtil.getFileDisplayName((FileObject)dataFolder.getPrimaryFile()) + ')');
        }
        try {
            DataObject dataObject = super.handleCopy(dataFolder);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
            this.bundleStructure = null;
        }
    }

    protected void handleDelete() throws IOException {
        PropertiesOpen propertiesOpen;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleDelete()");
        }
        if ((propertiesOpen = (PropertiesOpen)this.getCookie(OpenCookie.class)) != null) {
            propertiesOpen.removeModifiedListener(this);
            this.bundleStructure = null;
            this.openSupport = null;
        }
        super.handleDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        PropertiesOpen propertiesOpen;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleMove(" + FileUtil.getFileDisplayName((FileObject)dataFolder.getPrimaryFile()) + ')');
        }
        MultiBundleStructure multiBundleStructure = (MultiBundleStructure)this.bundleStructure;
        FileObject fileObject = this.getPrimaryFile();
        SaveCookie saveCookie = (SaveCookie)this.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            saveCookie.save();
        }
        if ((propertiesOpen = (PropertiesOpen)this.getCookie(OpenCookie.class)) != null) {
            propertiesOpen.removeModifiedListener(this);
            propertiesOpen.close();
            this.bundleStructure = null;
            this.openSupport = null;
        }
        try {
            FileObject fileObject2 = super.handleMove(dataFolder);
            return fileObject2;
        }
        finally {
            if (multiBundleStructure != null && ((BundleStructure)multiBundleStructure).getEntryCount() > 1) {
                ((BundleStructure)multiBundleStructure).updateEntries();
                multiBundleStructure.notifyOneFileChanged(fileObject);
            }
            this.pasteSuffix = null;
            this.bundleStructure = null;
            this.openSupport = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry entry) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("removeSecondaryEntry2(Entry " + FileUtil.getFileDisplayName((FileObject)entry.getFile()) + ')');
        }
        this.removeSecondaryEntry(entry);
    }

    private String createPasteSuffix(DataFolder dataFolder) {
        String string = this.getPrimaryFile().getName();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (true) {
            String string2 = n == 0 ? string : string + n;
            boolean bl = false;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!(dataObjectArray[i] instanceof PropertiesDataObject) || !string2.equals(dataObjectArray[i].getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (n == 0) {
                    return "";
                }
                return "" + n;
            }
            ++n;
        }
    }

    public PropertiesOpen getOpenSupport() {
        if (this.openSupport == null) {
            this.openSupport = ((MultiBundleStructure)this.getBundleStructure()).getOpenSupport();
            if (this.isValid()) {
                this.openSupport.addDataObject(this);
            }
        }
        return this.openSupport;
    }

    void updateModificationStatus() {
        LOG.finer("updateModificationStatus()");
        boolean bl = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            bl = true;
        } else {
            Iterator iterator = this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                if (!((PresentableFileEntry)((Object)iterator.next())).isModified()) continue;
                bl = true;
                break;
            }
        }
        super.setModified(bl);
    }

    protected Node createNodeDelegate() {
        return new PropertiesDataNode(this);
    }

    Children getChildren() {
        return new PropertiesChildren();
    }

    boolean isMultiLocale() {
        return this.secondaryEntries().size() > 0;
    }

    protected synchronized BundleStructure findBundleStructure() {
        PropertiesDataObject propertiesDataObject = null;
        try {
            propertiesDataObject = Util.findPrimaryDataObject(this);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        if (this == propertiesDataObject) {
            MultiBundleStructure multiBundleStructure = new MultiBundleStructure(this);
            return multiBundleStructure;
        }
        return propertiesDataObject.getBundleStructure();
    }

    protected BundleStructure getBundleStructureOrNull() {
        return this.bundleStructure;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            try {
                this.bundleStructure = Util.findBundleStructure(this.getPrimaryFile(), this.getPrimaryFile().getParent(), Util.getBaseName(this.getName()));
                if (this.bundleStructure == null) {
                    this.bundleStructure = new MultiBundleStructure(this);
                }
                this.bundleStructure.updateEntries();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return null;
            }
        }
        return this.bundleStructure;
    }

    protected void setBundleStructure(BundleStructure bundleStructure) {
        if (this.bundleStructure != bundleStructure) {
            this.bundleStructure = bundleStructure;
        }
    }

    public static Comparator<String> getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        LOG.finer("fireNameChange()");
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesChildren
    extends Children.Keys<String> {
        private PropertyChangeListener propertyListener = null;
        private PropertyChangeListener weakPropListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string == string2) {
                        return 0;
                    }
                    if (string == null) {
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                    return string.compareTo(string2);
                }
            });
            treeSet.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            for (MultiDataObject.Entry entry : PropertiesDataObject.this.secondaryEntries()) {
                treeSet.add(entry.getFile().getName());
            }
            this.setKeys(treeSet);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("files".equals(propertyChangeEvent.getPropertyName())) {
                            if (PropertiesDataObject.this.isMultiLocale()) {
                                PropertiesChildren.this.mySetKeys();
                            } else if (PropertiesChildren.this.propertyListener != null) {
                                PropertiesDataObject.this.removePropertyChangeListener(PropertiesChildren.this.weakPropListener);
                                PropertiesChildren.this.propertyListener = null;
                            }
                        }
                    }
                };
                this.weakPropListener = WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this));
                PropertiesDataObject.this.addPropertyChangeListener(this.weakPropListener);
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String string) {
            if (string == null) {
                return null;
            }
            PropertiesFileEntry propertiesFileEntry2 = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (string.equals(propertiesFileEntry2.getFile().getName())) {
                return new Node[]{propertiesFileEntry2.getNodeDelegate()};
            }
            for (PropertiesFileEntry propertiesFileEntry2 : PropertiesDataObject.this.secondaryEntries()) {
                if (!string.equals(propertiesFileEntry2.getFile().getName())) continue;
                return new Node[]{propertiesFileEntry2.getNodeDelegate()};
            }
            return null;
        }
    }
}

