/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class MultiBundleStructure
extends BundleStructure
implements Serializable {
    private transient FileObject[] files;
    private transient FileObject parent;
    private transient PropertiesFileEntry primaryEntry;
    private String baseName;
    private String extension;
    static final long serialVersionUID = 7501232754255253334L;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();

    protected MultiBundleStructure() {
    }

    public MultiBundleStructure(PropertiesDataObject propertiesDataObject) {
        this.obj = propertiesDataObject;
        this.baseName = Util.getBaseName(propertiesDataObject.getName());
        this.extension = "properties";
    }

    private synchronized void findEntries() {
        Object object;
        if (this.obj != null) {
            if (!this.obj.isValid()) {
                this.primaryEntry = null;
                if (this.files != null && this.files.length == 1) {
                    this.obj = null;
                    this.files = null;
                    return;
                }
            } else {
                this.primaryEntry = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            }
        }
        if (this.primaryEntry != null) {
            object = this.primaryEntry.getFile();
            if (!object.hasExt(this.extension) && object.getMIMEType().equalsIgnoreCase("text/x-properties")) {
                this.extension = object.getExt();
            }
            this.parent = object.getParent();
        } else if (this.parent == null) {
            return;
        }
        object = new ArrayList();
        for (FileObject fileObject : this.parent.getChildren()) {
            int n;
            if (!fileObject.hasExt(this.extension) || !fileObject.getMIMEType().equalsIgnoreCase("text/x-properties")) continue;
            String string = fileObject.getName();
            if (string.equals(this.baseName) && fileObject.isValid()) {
                object.add(0, fileObject);
            }
            if (string.indexOf(this.baseName) == -1 || (n = string.indexOf(95)) != this.baseName.length()) continue;
            FileObject fileObject2 = null;
            while (n != -1) {
                FileObject fileObject3 = fileObject;
                if (fileObject3 != null && MultiBundleStructure.isValidLocaleSuffix(string.substring(n)) && fileObject2 == null && fileObject.isValid()) {
                    object.add(fileObject3);
                    fileObject2 = fileObject3;
                }
                n = string.indexOf(95, n + 1);
            }
        }
        if (object.isEmpty()) {
            this.files = null;
            return;
        }
        this.files = object.toArray(new FileObject[object.size()]);
        if (this.primaryEntry != this.getNthEntry(0)) {
            this.primaryEntry = this.getNthEntry(0);
            if (this.primaryEntry != null) {
                this.notifyOneFileChanged(this.primaryEntry.getFile());
                if (!this.primaryEntry.getFile().hasExt(this.extension) && this.primaryEntry.getFile().getMIMEType().equalsIgnoreCase("text/x-properties")) {
                    this.extension = this.primaryEntry.getFile().getExt();
                }
                this.parent = this.primaryEntry.getFile().getParent();
                this.obj = (PropertiesDataObject)this.primaryEntry.getDataObject();
                this.baseName = Util.getBaseName(this.obj.getName());
            }
        }
    }

    void updateEntries() {
        this.findEntries();
        if (this.files != null) {
            this.buildKeySet();
        }
    }

    void moveEntry(int n, int n2) {
        if (n >= 0 && n < this.getEntryCount() && n2 >= 0 && n2 < this.getEntryCount()) {
            int n3;
            int n4 = this.getSortIndex();
            if (n + 1 == n4) {
                n4 = n2 + 1;
            }
            FileObject fileObject = null;
            if (n < n2) {
                fileObject = this.files[n];
                for (n3 = n; n3 < n2; ++n3) {
                    this.files[n3] = this.files[n3 + 1];
                    if (n3 != n4 - 1) continue;
                    --n4;
                }
                this.files[n2] = fileObject;
            } else if (n > n2) {
                fileObject = this.files[n];
                for (n3 = n; n3 > n2; --n3) {
                    this.files[n3] = this.files[n3 - 1];
                    if (n3 != n4 - 1) continue;
                    ++n4;
                }
                this.files[n2] = fileObject;
            }
            if (this.getSortIndex() == n2 + 1) {
                n4 = n + 1;
            }
            if (n4 != this.getSortIndex()) {
                n3 = this.getSortOrder() ? 1 : 0;
                this.sort(n4);
                if (n3 == 0) {
                    this.sort(n4);
                }
            }
        }
    }

    public PropertiesFileEntry getNthEntry(int n) {
        if (this.files == null) {
            return null;
        }
        if (n >= 0 && n < this.files.length) {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.files[n]);
                if (dataObject instanceof PropertiesDataObject) {
                    return (PropertiesFileEntry)((PropertiesDataObject)dataObject).getPrimaryEntry();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getEntryIndexByFileName(String string) {
        if (this.files == null) {
            return -1;
        }
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.files[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String string) {
        int n = this.getEntryIndexByFileName(string);
        try {
            return n == -1 ? null : (PropertiesFileEntry)((PropertiesDataObject)DataObject.find((FileObject)this.files[n])).getPrimaryEntry();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public int getEntryCount() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    private void notifyEntriesNotInitialized() {
        throw new IllegalStateException("Resource Bundles: Entries not initialized");
    }

    private static boolean isValidLocaleSuffix(String string) {
        HashSet<String> hashSet;
        String string2;
        int n = string.length();
        if (n != 3 && (n <= 3 || string.charAt(3) != '_')) {
            return false;
        }
        String string3 = string.substring(1, 3).toLowerCase();
        if (n == 3) {
            string2 = null;
        } else if (n == 6 || n > 6 && string.charAt(6) == '_') {
            string2 = string.substring(4, 6).toUpperCase();
        } else {
            return false;
        }
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        if (!hashSet2.contains(string3)) {
            return false;
        }
        return string2 == null || (hashSet = new HashSet<String>(Arrays.asList(Locale.getISOCountries()))).contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    public int getKeyCount() {
        try {
            return super.getKeyCount();
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }
}

