/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionDocProvider;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionViewProvider;
import org.openide.util.Lookup;

public final class CsmMacroExpansion {
    public static final String MACRO_EXPANSION_VIEW_DOCUMENT = "macro-expansion-view-document";
    public static final String MACRO_EXPANSION_SYNC_CARET = "macro-expansion-sync-caret";
    public static final String MACRO_EXPANSION_SYNC_CONTEXT = "macro-expansion-sync-context";
    private static final CsmMacroExpansionDocProvider EMPTY_MACRO_EXPANSION_DOC_PROVIDER = new EmptyMacroExpansionDoc();
    private static final CsmMacroExpansionViewProvider EMPTY_MACRO_EXPANSION_VIEW_PROVIDER = new EmptyMacroExpansionView();
    private static CsmMacroExpansionDocProvider defaultMacroExpansionDocProvider;
    private static CsmMacroExpansionViewProvider defaultMacroExpansionViewProvider;

    private CsmMacroExpansion() {
    }

    private static synchronized CsmMacroExpansionDocProvider getMacroExpansionDocProvider() {
        if (defaultMacroExpansionDocProvider != null) {
            return defaultMacroExpansionDocProvider;
        }
        defaultMacroExpansionDocProvider = (CsmMacroExpansionDocProvider)Lookup.getDefault().lookup(CsmMacroExpansionDocProvider.class);
        return defaultMacroExpansionDocProvider == null ? EMPTY_MACRO_EXPANSION_DOC_PROVIDER : defaultMacroExpansionDocProvider;
    }

    private static synchronized CsmMacroExpansionViewProvider getMacroExpansionViewProvider() {
        if (defaultMacroExpansionViewProvider != null) {
            return defaultMacroExpansionViewProvider;
        }
        defaultMacroExpansionViewProvider = (CsmMacroExpansionViewProvider)Lookup.getDefault().lookup(CsmMacroExpansionViewProvider.class);
        return defaultMacroExpansionViewProvider == null ? EMPTY_MACRO_EXPANSION_VIEW_PROVIDER : defaultMacroExpansionViewProvider;
    }

    public static int expand(Document document, int n, int n2, Document document2) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(document, n, n2, document2);
    }

    public static String expand(Document document, int n, int n2) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(document, n, n2);
    }

    public static String expand(Document document, CsmFile csmFile, int n, int n2) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(document, csmFile, n, n2);
    }

    public static String expand(Document document, int n, String string) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().expand(document, n, string);
    }

    public static int[] getMacroExpansionSpan(Document document, int n, boolean bl) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getMacroExpansionSpan(document, n, bl);
    }

    public static int getOffsetInExpandedText(Document document, int n) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getOffsetInExpandedText(document, n);
    }

    public static int getOffsetInOriginalText(Document document, int n) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getOffsetInOriginalText(document, n);
    }

    public static int getNextMacroExpansionStartOffset(Document document, int n) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getNextMacroExpansionStartOffset(document, n);
    }

    public static int getPrevMacroExpansionStartOffset(Document document, int n) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getPrevMacroExpansionStartOffset(document, n);
    }

    public static int[][] getUsages(Document document, int n) {
        return CsmMacroExpansion.getMacroExpansionDocProvider().getUsages(document, n);
    }

    public static void showMacroExpansionView(Document document, int n) {
        CsmMacroExpansion.getMacroExpansionViewProvider().showMacroExpansionView(document, n);
    }

    private static final class EmptyMacroExpansionView
    implements CsmMacroExpansionViewProvider {
        EmptyMacroExpansionView() {
        }

        public void showMacroExpansionView(Document document, int n) {
        }
    }

    private static final class EmptyMacroExpansionDoc
    implements CsmMacroExpansionDocProvider {
        EmptyMacroExpansionDoc() {
        }

        public int expand(Document document, int n, int n2, Document document2) {
            return 0;
        }

        public String expand(Document document, int n, int n2) {
            return null;
        }

        public String expand(Document document, CsmFile csmFile, int n, int n2) {
            return null;
        }

        public String expand(Document document, int n, String string) {
            return null;
        }

        public int[] getMacroExpansionSpan(Document document, int n, boolean bl) {
            return new int[]{n, n};
        }

        public int getOffsetInExpandedText(Document document, int n) {
            return n;
        }

        public int getOffsetInOriginalText(Document document, int n) {
            return n;
        }

        public int getNextMacroExpansionStartOffset(Document document, int n) {
            return n;
        }

        public int getPrevMacroExpansionStartOffset(Document document, int n) {
            return n;
        }

        public int[][] getUsages(Document document, int n) {
            return null;
        }
    }
}

