/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SpecialSearchGroup
extends DataObjectSearchGroup {
    final BasicSearchCriteria basicCriteria;
    final boolean hasExtraSearchTypes;
    private final SearchScope searchScope;
    private SearchTask listeningSearchTask;
    private LinkedList searchItems;

    SpecialSearchGroup(BasicSearchCriteria basicSearchCriteria, Collection<SearchType> collection, SearchScope searchScope) {
        this.basicCriteria = basicSearchCriteria;
        this.hasExtraSearchTypes = !collection.isEmpty();
        this.searchScope = searchScope;
        if (basicSearchCriteria == null && !this.hasExtraSearchTypes) {
            assert (false);
            throw new IllegalArgumentException();
        }
        if (this.hasExtraSearchTypes) {
            for (SearchType searchType : collection) {
                this.add(searchType);
            }
        }
    }

    protected void prepareSearch() {
        this.searchItems = new LinkedList();
        SearchInfo searchInfo = this.searchScope.getSearchInfo();
        if (searchInfo instanceof SearchInfo.Files) {
            Iterator iterator = ((SearchInfo.Files)searchInfo).filesToSearch();
            while (iterator.hasNext()) {
                if (this.stopped) {
                    return;
                }
                this.searchItems.add(iterator.next());
            }
        } else {
            Iterator iterator = searchInfo.objectsToSearch();
            while (iterator.hasNext()) {
                if (this.stopped) {
                    return;
                }
                this.searchItems.add(iterator.next());
            }
        }
    }

    public void doSearch() {
        this.notifyStarted(this.searchItems.size());
        int n = 0;
        while (!this.searchItems.isEmpty()) {
            if (this.stopped) {
                return;
            }
            this.processSearchObject(this.searchItems.poll());
            this.notifyProgress(n++);
        }
    }

    protected void processSearchObject(Object object) {
        if (!this.hasExtraSearchTypes) {
            FileObject fileObject;
            assert (this.basicCriteria != null);
            if (object instanceof DataObject) {
                DataObject dataObject = (DataObject)object;
                if (this.basicCriteria.matches(dataObject)) {
                    this.notifyMatchingObjectFound(dataObject);
                }
            } else if (object instanceof FileObject && this.basicCriteria.matches(fileObject = (FileObject)object)) {
                try {
                    this.notifyMatchingObjectFound(DataObject.find((FileObject)fileObject));
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            return;
        }
        if (this.basicCriteria == null || this.basicCriteria.matches((DataObject)object)) {
            super.processSearchObject(object);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.notifyMatchingObjectFound((DataObject)object2);
    }

    private void notifyMatchingObjectFound(DataObject dataObject) {
        if (this.listeningSearchTask != null) {
            Charset charset = this.basicCriteria != null ? this.basicCriteria.getLastUsedCharset() : null;
            this.listeningSearchTask.matchingObjectFound(dataObject, charset);
        }
    }

    private void notifyStarted(int n) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.searchStarted(n);
        }
    }

    private void notifyProgress(int n) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.progress(n);
        }
    }

    void setListeningSearchTask(SearchTask searchTask) {
        this.listeningSearchTask = searchTask;
    }

    SearchScope getSearchScope() {
        return this.searchScope;
    }
}

