/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

final class XMLResultParser
extends DefaultHandler {
    private static final int STATE_OUT_OF_SCOPE = 1;
    private static final int STATE_TESTSUITE = 2;
    private static final int STATE_PROPERTIES = 3;
    private static final int STATE_PROPERTY = 4;
    private static final int STATE_TESTCASE = 8;
    private static final int STATE_FAILURE = 12;
    private static final int STATE_ERROR = 13;
    private static final int STATE_OUTPUT_STD = 16;
    private static final int STATE_OUTPUT_ERR = 17;
    private int state = 1;
    int unknownElemNestLevel = 0;
    private final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
    private String lastErrClassName = null;
    private List lastErrMethodNames = null;
    private String className;
    private String methodName;
    private List result = null;

    static List parseResultsFile(Reader reader) throws IOException, SAXException {
        XMLResultParser parser = new XMLResultParser();
        parser.xmlReader.parse(new InputSource(reader));
        return parser.result != null ? parser.result : Collections.EMPTY_LIST;
    }

    private XMLResultParser() throws SAXException {
        this.xmlReader.setContentHandler(this);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        switch (this.state) {
            case 3: {
                if (qName.equals("property")) {
                    this.state = 4;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 2: {
                if (qName.equals("testcase")) {
                    this.className = attrs.getValue("classname");
                    this.methodName = attrs.getValue("name");
                    this.state = 8;
                    break;
                }
                if (qName.equals("system-out")) {
                    this.state = 16;
                    break;
                }
                if (qName.equals("system-err")) {
                    this.state = 17;
                    break;
                }
                if (qName.equals("properties")) {
                    this.state = 3;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 8: {
                if (qName.equals("failure")) {
                    this.state = 12;
                } else if (qName.equals("error")) {
                    this.state = 13;
                } else {
                    this.startUnknownElem();
                }
                if (this.state < 0 || this.className == null || this.methodName == null) break;
                if (this.className.equals(this.lastErrClassName)) {
                    this.lastErrMethodNames.add(this.methodName);
                } else {
                    this.maybeSaveLastErrJUnitTest();
                }
                this.lastErrClassName = this.className;
                if (this.lastErrMethodNames == null) {
                    this.lastErrMethodNames = new ArrayList(5);
                }
                this.lastErrMethodNames.add(this.methodName);
                break;
            }
            case 1: {
                if (qName.equals("testsuite")) {
                    this.state = 2;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.startUnknownElem();
                break;
            }
            default: {
                ++this.unknownElemNestLevel;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 3: {
                this.state = 2;
                break;
            }
            case 2: {
                this.maybeSaveLastErrJUnitTest();
                this.state = 1;
                break;
            }
            case 8: {
                this.state = 2;
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.state = 3;
                break;
            }
            case 12: 
            case 13: {
                this.state = 8;
                break;
            }
            case 16: 
            case 17: {
                this.state = 2;
                break;
            }
            default: {
                if (--this.unknownElemNestLevel != 0) break;
                this.state = -this.state;
            }
        }
    }

    private void startUnknownElem() {
        this.state = -this.state;
        ++this.unknownElemNestLevel;
    }

    private void maybeSaveLastErrJUnitTest() {
        if (this.lastErrClassName == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(this.lastErrClassName).append(':');
        buf.append(this.lastErrMethodNames.get(0));
        int methodsCount = this.lastErrMethodNames.size();
        if (methodsCount > 1) {
            for (int i = 1; i < methodsCount; ++i) {
                buf.append(',').append(this.lastErrMethodNames.get(i));
            }
        }
        if (this.result == null) {
            this.result = new ArrayList(10);
        }
        this.result.add(buf.toString());
        this.lastErrClassName = null;
        this.lastErrMethodNames.clear();
    }
}

