/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.HashSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class BinaryForSourceQuery {
    private BinaryForSourceQuery() {
    }

    public static Result findBinaryRoots(URL uRL) {
        assert (uRL != null);
        for (BinaryForSourceQueryImplementation binaryForSourceQueryImplementation : Lookup.getDefault().lookupAll(BinaryForSourceQueryImplementation.class)) {
            Result result = binaryForSourceQueryImplementation.findBinaryRoots(uRL);
            if (result == null) continue;
            return result;
        }
        return new DefaultResult(uRL);
    }

    private static class DefaultResult
    implements Result {
        private final URL sourceRoot;

        DefaultResult(URL uRL) {
            this.sourceRoot = uRL;
        }

        public URL[] getRoots() {
            FileObject fileObject = URLMapper.findFileObject((URL)this.sourceRoot);
            if (fileObject == null) {
                return new URL[0];
            }
            ClassPath classPath = ClassPath.getClassPath(fileObject, "classpath/execute");
            if (classPath == null) {
                return new URL[0];
            }
            HashSet<URL> hashSet = new HashSet<URL>();
            for (ClassPath.Entry entry : classPath.entries()) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject2 : fileObjectArray = SourceForBinaryQuery.findSourceRoots(entry.getURL()).getRoots()) {
                    try {
                        if (!this.sourceRoot.equals(fileObject2.getURL())) continue;
                        hashSet.add(entry.getURL());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    }
                }
            }
            return hashSet.toArray(new URL[hashSet.size()]);
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Result {
        public URL[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

