/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateDefaultConstructor;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class HasNoArgConstructor
extends JPAClassRule {
    public HasNoArgConstructor() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.IDCLASS));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        boolean bl = true;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            bl = false;
            if (executableElement.getParameters().size() != 0 || !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) && !executableElement.getModifiers().contains((Object)Modifier.PROTECTED)) continue;
            return null;
        }
        if (bl) {
            return null;
        }
        CreateDefaultConstructor createDefaultConstructor = new CreateDefaultConstructor(problemContext.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)problemContext.getJavaClass()));
        return new ErrorDescription[]{HasNoArgConstructor.createProblem((Element)typeElement, problemContext, NbBundle.getMessage(HasNoArgConstructor.class, (String)"MSG_HasNoNoArgConstructor"), createDefaultConstructor)};
    }
}

