/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class ValidVersionType
extends JPAEntityAttributeCheck {
    private static Collection<String> validVersionTypes = new TreeSet<String>(Arrays.asList("java.lang.Short", "java.lang.Integer", "java.lang.Long", "short", "int", "long", "java.sql.Timestamp"));

    public ErrorDescription[] check(JPAProblemContext jPAProblemContext, AttributeWrapper attributeWrapper) {
        if (attributeWrapper.getModelElement() instanceof Version) {
            TreeUtilities treeUtilities = jPAProblemContext.getCompilationInfo().getTreeUtilities();
            Types types = jPAProblemContext.getCompilationInfo().getTypes();
            TypeMirror typeMirror = attributeWrapper.getType();
            for (String string : validVersionTypes) {
                TypeMirror typeMirror2 = treeUtilities.parseType(string, jPAProblemContext.getJavaClass());
                if (typeMirror2 == null || !types.isSameType(typeMirror, typeMirror2)) continue;
                return null;
            }
            return new ErrorDescription[]{Rule.createProblem(attributeWrapper.getJavaElement(), jPAProblemContext, NbBundle.getMessage(ValidVersionType.class, (String)"MSG_InvalidVersionType"))};
        }
        return null;
    }
}

