/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.Vector;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;

public class Monitors
implements CommonConstants {
    private static final boolean DEBUG = false;
    protected static Runtime runtime;
    protected static SurvGenAndThreadsMonitor stMonitor;
    protected static long[] generalMNums;
    protected static long[] gcRelTime;
    protected static long[] gcStartTimes;
    protected static long[] gcFinishTimes;
    protected static long time;

    public static MonitoredNumbersResponse getMonitoredNumbers() {
        int n;
        int n2;
        int n3 = Threads.getTotalNumberOfThreads();
        --n3;
        int n4 = ProfilerInterface.getNPrerecordedSystemThreads();
        if (n4 != -1) {
            n2 = n3 - n4;
            n4 -= 2;
            if (ProfilerServer.isTargetAppMainThreadComplete()) {
                --n2;
            }
        } else {
            n2 = n3 - 3;
        }
        if ((n = ProfilerInterface.getCurrentInstrType()) == 3 || n == 5) {
            --n2;
        }
        GC.getGCRelativeTimeMetrics(gcRelTime);
        Monitors.generalMNums[0] = runtime.freeMemory();
        Monitors.generalMNums[1] = runtime.totalMemory();
        Monitors.generalMNums[2] = n2;
        Monitors.generalMNums[3] = n4;
        Monitors.generalMNums[4] = stMonitor.getNSurvGen();
        Monitors.generalMNums[5] = gcRelTime[0];
        Monitors.generalMNums[6] = gcRelTime[1];
        Monitors.generalMNums[7] = Classes.getLoadedClassCount();
        Monitors.generalMNums[8] = System.currentTimeMillis();
        MonitoredNumbersResponse monitoredNumbersResponse = new MonitoredNumbersResponse(generalMNums);
        stMonitor.getThreadsData(monitoredNumbersResponse);
        Monitors.stMonitor.getGCStartFinishData(monitoredNumbersResponse);
        return monitoredNumbersResponse;
    }

    public static void initialize() {
        runtime = Runtime.getRuntime();
        gcRelTime = new long[2];
        gcStartTimes = new long[10];
        gcFinishTimes = new long[10];
        generalMNums = new long[9];
        GC.activateGCEpochCounter(true);
        stMonitor = new SurvGenAndThreadsMonitor();
        ThreadInfo.addProfilerServerThread(stMonitor);
        stMonitor.start();
    }

    public static boolean monitorThreadsStarted() {
        return Monitors.stMonitor.started;
    }

    public static void shutdown() {
        Monitors.stMonitor.terminated = true;
    }

    private static void showTime() {
        long l = Timers.getNoOfCountsInSecond();
        time = (Timers.getCurrentTimeInCounts() - time) * 1000000L / l;
        long l2 = stMonitor.getTime() * 1000000L / l;
        System.out.println("!!! time = " + time + ", time1 = " + l2 + ", sum = " + (time + l2));
    }

    static class ThreadDataTable {
        private static final int INITIAL_SIZE = 23;
        private static final int INITIAL_NSTATES = 20;
        private static Object dummyObj = new Object();
        private String[] newThreadClassNames = new String[23];
        private int[] newThreadIds = new int[23];
        private String[] newThreadNames = new String[23];
        private long[] packedStateTimestamps = new long[20];
        private int[] packedThreadIds = new int[23];
        private byte[] packedThreadStates = new byte[460];
        private long[] stateSampleTimestamps;
        private int[] threadIds;
        private boolean[] threadNew;
        private byte[][] threadStates;
        private Object[] threads;
        private boolean jvmSupportsThreadSleepingState;
        private int curStateIdx = 0;
        private int curThreadId = 1;
        private int nFilledSlots = 0;
        private int nNewThreads;
        private int nStates = 20;
        private int nThreads = 0;
        private int size = 23;
        private int threshold = this.size * 3 / 4;

        ThreadDataTable() {
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][this.nStates];
            this.stateSampleTimestamps = new long[this.nStates];
            this.threadNew = new boolean[this.size];
            this.jvmSupportsThreadSleepingState = Platform.thisVMSupportsThreadSleepingStateMonitoring();
        }

        public void getThreadsData(MonitoredNumbersResponse monitoredNumbersResponse) {
            int n;
            int n2;
            if (this.nThreads > this.packedThreadIds.length) {
                this.packedThreadIds = new int[this.nThreads];
            }
            if (this.curStateIdx > this.packedStateTimestamps.length) {
                this.packedStateTimestamps = new long[this.curStateIdx];
            }
            if ((n2 = this.nThreads * this.curStateIdx) > this.packedThreadStates.length) {
                this.packedThreadStates = new byte[n2];
            }
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < this.size; ++n) {
                if (this.threads[n] == null || this.threads[n] == dummyObj) continue;
                this.packedThreadIds[n3++] = this.threadIds[n];
                System.arraycopy(this.threadStates[n], 0, this.packedThreadStates, n4, this.curStateIdx);
                n4 += this.curStateIdx;
            }
            System.arraycopy(this.stateSampleTimestamps, 0, this.packedStateTimestamps, 0, this.curStateIdx);
            monitoredNumbersResponse.setDataOnThreads(this.nThreads, this.curStateIdx, this.packedThreadIds, this.packedStateTimestamps, this.packedThreadStates);
            if (this.nNewThreads > 0) {
                if (this.nNewThreads > this.newThreadIds.length) {
                    this.newThreadIds = new int[this.nNewThreads];
                    this.newThreadNames = new String[this.nNewThreads];
                    this.newThreadClassNames = new String[this.nNewThreads];
                }
                n = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (!this.threadNew[i]) continue;
                    this.newThreadIds[n] = this.threadIds[i];
                    this.newThreadNames[n] = ((Thread)this.threads[i]).getName();
                    this.newThreadClassNames[n] = ((Thread)this.threads[i]).getClass().getName();
                    ++n;
                }
                monitoredNumbersResponse.setDataOnNewThreads(this.nNewThreads, this.newThreadIds, this.newThreadNames, this.newThreadClassNames);
            }
        }

        public void incStatusIdx() {
            ++this.curStateIdx;
            if (this.curStateIdx == this.nStates) {
                this.growStatesArrays();
            }
        }

        public void prePut() {
            for (int i = 0; i < this.size; ++i) {
                this.threadStates[i][this.curStateIdx] = 0;
            }
            this.stateSampleTimestamps[this.curStateIdx] = System.currentTimeMillis();
        }

        public void printCurrentStatus() {
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                System.err.print(((Thread)this.threads[i]).getName() + "  ");
                byte[] byArray = this.threadStates[i];
                for (int j = 0; j < this.curStateIdx; ++j) {
                    System.err.print(byArray[j]);
                }
                System.err.println();
            }
            System.err.println();
        }

        public void put(Thread thread, int n) {
            int n2 = (thread.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.threads[n2] != thread && this.threads[n2] != null) {
                n2 = (n2 + 1) % this.size;
            }
            if (this.threads[n2] == null) {
                this.threadNew[n2] = true;
                this.threads[n2] = thread;
                ++this.curThreadId;
                ++this.nThreads;
                ++this.nNewThreads;
                ++this.nFilledSlots;
            }
            this.threadStates[n2][this.curStateIdx] = (byte)n;
            if (this.nFilledSlots > this.threshold) {
                this.growTable();
            }
        }

        public void resetStates() {
            this.nNewThreads = 0;
            if (this.curStateIdx == 0) {
                return;
            }
            int n = this.curStateIdx - 1;
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                this.threadNew[i] = false;
                if (this.threadStates[i][n] != 0) continue;
                this.threads[i] = dummyObj;
                --this.nThreads;
            }
            this.curStateIdx = 0;
        }

        private void growStatesArrays() {
            int n = this.nStates;
            this.nStates *= 2;
            for (int i = 0; i < this.size; ++i) {
                byte[] byArray = this.threadStates[i];
                this.threadStates[i] = new byte[this.nStates];
                System.arraycopy(byArray, 0, this.threadStates[i], 0, n);
            }
            long[] lArray = this.stateSampleTimestamps;
            this.stateSampleTimestamps = new long[this.nStates];
            System.arraycopy(lArray, 0, this.stateSampleTimestamps, 0, n);
        }

        private void growTable() {
            int n;
            int n2 = this.size;
            this.size = this.nThreads * 4 / 3 * 2 + 1;
            if (this.size < n2) {
                this.size = n2;
            }
            this.threshold = this.size * 3 / 4;
            Object[] objectArray = this.threads;
            int[] nArray = this.threadIds;
            byte[][] byArray = this.threadStates;
            boolean[] blArray = this.threadNew;
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][];
            this.threadNew = new boolean[this.size];
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] == null || objectArray[n] == dummyObj) continue;
                Object object = objectArray[n];
                int n3 = (object.hashCode() & Integer.MAX_VALUE) % this.size;
                while (this.threads[n3] != null) {
                    n3 = (n3 + 1) % this.size;
                }
                this.threadNew[n3] = blArray[n];
                this.threads[n3] = object;
                this.threadIds[n3] = nArray[n];
                this.threadStates[n3] = byArray[n];
            }
            for (n = 0; n < this.size; ++n) {
                if (this.threadStates[n] != null) continue;
                this.threadStates[n] = new byte[this.nStates];
            }
            this.nFilledSlots = this.nThreads;
        }
    }

    static class SurvGenAndThreadsMonitor
    extends Thread {
        public volatile boolean started;
        public volatile boolean terminated;
        private LongList gcFinishs;
        private LongList gcStarts;
        private ThreadDataTable threadTable;
        private Vector markerObjects;
        private int[] allThreadStatusRough;
        private Thread[] allThreadsRough;
        private int savedGCEpoch = GC.getCurrentGCEpoch();
        private long lastGCFinish;
        private long lastGCStart;
        private long time;
        private long time0;

        SurvGenAndThreadsMonitor() {
            super("*** JFluid Monitor thread ***");
            this.markerObjects = new Vector();
            this.allThreadsRough = new Thread[20];
            this.allThreadStatusRough = new int[20];
            this.threadTable = new ThreadDataTable();
            this.gcStarts = new LongList(16);
            this.gcFinishs = new LongList(16);
            this.setPriority(10);
            this.setDaemon(true);
        }

        public int getNSurvGen() {
            return this.markerObjects.size();
        }

        public synchronized void getThreadsData(MonitoredNumbersResponse monitoredNumbersResponse) {
            this.threadTable.getThreadsData(monitoredNumbersResponse);
            this.threadTable.resetStates();
        }

        public long getTime() {
            long l = this.time;
            this.time = 0L;
            return l;
        }

        public void run() {
            this.started = true;
            int n = 3;
            while (!this.terminated) {
                this.updateSurvGenData();
                this.updateThreadsData();
                this.updateGCStartFinishData();
                if (--n == 0) {
                    ClassLoaderManager.checkForUnloadedClasses();
                    n = 3;
                }
                ThreadInfo.releaseDeadThreads();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }

        synchronized void updateGCStartFinishData() {
            long l = this.lastGCStart;
            long l2 = this.lastGCFinish;
            GC.getGCStartFinishTimes(gcStartTimes, gcFinishTimes);
            for (int i = 0; i < 10; ++i) {
                long l3 = gcStartTimes[i];
                long l4 = gcFinishTimes[i];
                if (l3 > this.lastGCStart) {
                    this.gcStarts.add(l3 & 0xFFFFFFFFFFFFFFL);
                    l = l3;
                }
                if (l4 <= this.lastGCFinish) continue;
                this.gcFinishs.add(l4 & 0xFFFFFFFFFFFFFFL);
                l2 = l4;
            }
            this.lastGCStart = l;
            this.lastGCFinish = l2;
        }

        private synchronized void getGCStartFinishData(MonitoredNumbersResponse monitoredNumbersResponse) {
            long[] lArray = this.gcStarts.getArray();
            long[] lArray2 = this.gcFinishs.getArray();
            this.gcStarts.clear();
            this.gcFinishs.clear();
            monitoredNumbersResponse.setGCstartFinishData(lArray, lArray2);
        }

        private void updateSurvGenData() {
            int n = GC.getCurrentGCEpoch();
            if (n != this.savedGCEpoch) {
                this.markerObjects.add(new Object());
                this.savedGCEpoch = n;
                int n2 = this.markerObjects.size() - 1;
                int n3 = n2 + 1;
                for (int i = 0; i < n2; ++i) {
                    if (!GC.objectsAdjacent(this.markerObjects.get(i), this.markerObjects.get(i + 1))) continue;
                    this.markerObjects.remove(i);
                    --i;
                    --n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateThreadsData() {
            Thread thread = ProfilerServer.isTargetAppMainThreadComplete() ? ProfilerServer.getMainThread() : null;
            this.allThreadsRough = Threads.getAllThreads(this.allThreadsRough);
            if (this.allThreadStatusRough.length < this.allThreadsRough.length) {
                this.allThreadStatusRough = new int[this.allThreadsRough.length];
            }
            Threads.getThreadsStatus(this.allThreadsRough, this.allThreadStatusRough);
            SurvGenAndThreadsMonitor survGenAndThreadsMonitor = this;
            synchronized (survGenAndThreadsMonitor) {
                Thread thread2;
                this.threadTable.prePut();
                for (int i = 0; i < this.allThreadsRough.length && (thread2 = this.allThreadsRough[i]) != null; ++i) {
                    if (thread2 == this || thread2 == thread || ThreadInfo.isProfilerServerThread(thread2)) continue;
                    this.threadTable.put(thread2, this.allThreadStatusRough[i]);
                }
                this.threadTable.incStatusIdx();
            }
        }
    }

    static class LongList {
        long[] data;
        int size;

        LongList(int n) {
            this.data = new long[n];
        }

        long[] getArray() {
            long[] lArray = new long[this.size];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            return lArray;
        }

        void add(long l) {
            this.ensureSize();
            this.data[this.size++] = l;
        }

        void clear() {
            this.size = 0;
        }

        void ensureSize() {
            if (this.size >= this.data.length) {
                int n = this.size * 3 / 2 + 1;
                long[] lArray = new long[n];
                System.arraycopy(this.data, 0, lArray, 0, this.size);
                this.data = lArray;
            }
        }
    }
}

