/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.modules.editor.lib2.actions.MacroRecording;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditorAction
extends TextAction {
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions.editor");
    private static final long serialVersionUID = 1L;
    private final Map<String, ?> attrs;

    protected AbstractEditorAction(Map<String, ?> map) {
        super(null);
        this.attrs = map;
        if (map != null) {
            String string = (String)map.get("Name");
            if (string == null) {
                throw new IllegalArgumentException("Null Action.NAME attribute for action " + this.getClass());
            }
            this.putValue("Name", string);
        }
    }

    protected AbstractEditorAction() {
        this((Map<String, ?>)null);
    }

    public abstract void actionPerformed(ActionEvent var1, JTextComponent var2);

    protected void actionNameUpdate(String string) {
    }

    protected boolean asynchronous() {
        return false;
    }

    protected final String actionName() {
        return (String)this.getValue("Name");
    }

    protected final void resetCaretMagicPosition(JTextComponent jTextComponent) {
        Caret caret;
        if (jTextComponent != null && (caret = jTextComponent.getCaret()) != null) {
            caret.setMagicCaretPosition(null);
        }
    }

    @Override
    public final void actionPerformed(final ActionEvent actionEvent) {
        String string;
        final JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        MacroRecording.get().recordAction(this, actionEvent);
        if (UILOG.isLoggable(Level.FINE) && (string = this.actionName()) != null && !"default-typed".equals(string) && -1 == string.indexOf("caret") && -1 == string.indexOf("delete") && -1 == string.indexOf("selection") && -1 == string.indexOf("build-tool-tip") && -1 == string.indexOf("build-popup-menu") && -1 == string.indexOf("page-up") && -1 == string.indexOf("page-down") && -1 == string.indexOf("-kit-install")) {
            LogRecord logRecord = new LogRecord(Level.FINE, "UI_ACTION_EDITOR");
            logRecord.setResourceBundle(NbBundle.getBundle(AbstractEditorAction.class));
            if (actionEvent != null) {
                logRecord.setParameters(new Object[]{actionEvent, actionEvent.toString(), this, this.toString(), this.getValue("Name")});
            } else {
                logRecord.setParameters(new Object[]{"no-ActionEvent", "no-ActionEvent", this, this.toString(), this.getValue("Name")});
            }
            logRecord.setLoggerName(UILOG.getName());
            UILOG.log(logRecord);
        }
        if (this.asynchronous()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    AbstractEditorAction.this.actionPerformed(actionEvent, jTextComponent);
                }
            });
        } else {
            this.actionPerformed(actionEvent, jTextComponent);
        }
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && this.attrs != null && !"instanceCreate".equals(string)) {
            object = this.attrs.get(string);
        }
        return object;
    }

    @Override
    public void putValue(String string, Object object) {
        super.putValue(string, object);
        if ("Name".equals(string) && object instanceof String) {
            this.actionNameUpdate((String)object);
        }
    }
}

