/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;

public final class MacroRecording {
    public static final String NO_MACRO_RECORDING_PROPERTY = "NoMacroRecording";
    private static final MacroRecording INSTANCE = new MacroRecording();
    private StringBuilder macroBuffer;
    private StringBuilder textBuffer;

    public static MacroRecording get() {
        return INSTANCE;
    }

    private MacroRecording() {
    }

    public synchronized boolean startRecording() {
        if (this.isRecording()) {
            return false;
        }
        this.macroBuffer = new StringBuilder(100);
        this.textBuffer = new StringBuilder(20);
        return true;
    }

    public synchronized String stopRecording() {
        if (!this.isRecording()) {
            return null;
        }
        if (this.textBuffer.length() > 0) {
            if (this.macroBuffer.length() > 0) {
                this.macroBuffer.append(' ');
            }
            MacroRecording.appendEncodedText(this.macroBuffer, this.textBuffer);
        }
        String string = this.macroBuffer.toString();
        this.textBuffer = null;
        this.macroBuffer = null;
        return string;
    }

    public synchronized void recordAction(Action action, ActionEvent actionEvent) {
        if (this.isRecording() && !Boolean.TRUE.equals(action.getValue(NO_MACRO_RECORDING_PROPERTY))) {
            String string = MacroRecording.actionName(action);
            if ("default-typed".equals(string)) {
                this.textBuffer.append(MacroRecording.getFilteredActionCommand(actionEvent.getActionCommand()));
            } else {
                if (this.textBuffer.length() > 0) {
                    if (this.macroBuffer.length() > 0) {
                        this.macroBuffer.append(' ');
                    }
                    MacroRecording.appendEncodedText(this.macroBuffer, this.textBuffer);
                    this.textBuffer.setLength(0);
                }
                if (this.macroBuffer.length() > 0) {
                    this.macroBuffer.append(' ');
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (Character.isWhitespace(c) || c == '\\') {
                        this.macroBuffer.append('\\');
                    }
                    this.macroBuffer.append(c);
                }
            }
        }
    }

    private boolean isRecording() {
        return this.macroBuffer != null;
    }

    private static String actionName(Action action) {
        return (String)action.getValue("Name");
    }

    private static String getFilteredActionCommand(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = string.charAt(0);
        if (c >= ' ' && c != '\u007f') {
            return string;
        }
        return "";
    }

    private static void appendEncodedText(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        stringBuilder.append('\"');
        for (int i = 0; i < stringBuilder2.length(); ++i) {
            char c = stringBuilder2.charAt(i);
            if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
    }
}

