/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigDecimal;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class SolarisProcfsSupport {
    public static Prusage parsePrusage(String string, Prusage prusage) {
        Prusage prusage2 = prusage == null ? new Prusage() : prusage;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            String string2 = stringTokenizer.nextToken();
            if ("0000000".equals(string2)) {
                prusage2.lwpid = SolarisProcfsSupport.parseHex(stringTokenizer.nextToken());
                prusage2.count = (int)SolarisProcfsSupport.parseHex(stringTokenizer.nextToken());
                prusage2.tstamp = SolarisProcfsSupport.parseTimespec(stringTokenizer);
            } else if ("0000040".equals(string2)) {
                prusage2.rtime = SolarisProcfsSupport.parseTimespec(stringTokenizer);
                prusage2.utime = SolarisProcfsSupport.parseTimespec(stringTokenizer);
            } else if ("0000060".equals(string2)) {
                prusage2.stime = SolarisProcfsSupport.parseTimespec(stringTokenizer);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Too few elements in line", noSuchElementException);
        }
        return prusage2;
    }

    private static Timespec parseTimespec(StringTokenizer stringTokenizer) {
        return new Timespec(SolarisProcfsSupport.parseHex(stringTokenizer.nextToken()), SolarisProcfsSupport.parseHex(stringTokenizer.nextToken()));
    }

    private static long parseHex(String string) {
        return Long.parseLong(string, 16);
    }

    public static final class Prusage {
        private long lwpid;
        private int count;
        private Timespec tstamp;
        private Timespec rtime;
        private Timespec utime;
        private Timespec stime;

        private Prusage() {
        }

        public long lwpid() {
            return this.lwpid;
        }

        public int count() {
            return this.count;
        }

        public Timespec tstamp() {
            return this.tstamp;
        }

        public Timespec rtime() {
            return this.rtime;
        }

        public Timespec utime() {
            return this.utime;
        }

        public Timespec stime() {
            return this.stime;
        }
    }

    public static final class Timespec {
        private final long sec;
        private final long nsec;

        private Timespec(long l, long l2) {
            this.sec = l;
            this.nsec = l2;
        }

        public long sec() {
            return this.sec;
        }

        public long nsec() {
            return this.nsec;
        }

        public BigDecimal toBigDecimal() {
            return BigDecimal.valueOf(this.sec).add(BigDecimal.valueOf(this.nsec, 9));
        }
    }
}

