/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.extras.api.support.CollectorRunner;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.impl.LLDataCollectorConfigurationAccessor;
import org.netbeans.modules.dlight.tools.impl.NativeToolsUtil;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLDataCollector
extends IndicatorDataProvider<LLDataCollectorConfiguration>
implements DataCollector<LLDataCollectorConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private static final boolean ALLOW_ON_MACOSX = Boolean.getBoolean("cnd.tools.prof_agent.allow_on_macos");
    private final Object lock = LLDataCollector.class.getName();
    private final EnumSet<LLDataCollectorConfiguration.CollectedData> collectedData;
    private final Set<ValidationListener> validationListeners;
    private final String name;
    private DLightTarget target;
    private ValidationStatus validationStatus;
    private CollectorRunner profRunner;

    public LLDataCollector(LLDataCollectorConfiguration lLDataCollectorConfiguration) {
        this.collectedData = EnumSet.of(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(lLDataCollectorConfiguration));
        this.name = LLDataCollectorConfigurationAccessor.getDefault().getName();
        this.validationStatus = ValidationStatus.initialStatus();
        this.validationListeners = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(LLDataCollectorConfiguration lLDataCollectorConfiguration) {
        Object object = this.lock;
        synchronized (object) {
            this.collectedData.add(LLDataCollectorConfigurationAccessor.getDefault().getCollectedData(lLDataCollectorConfiguration));
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> arrayList = new ArrayList<DataTableMetadata>();
        Object object = this.lock;
        synchronized (object) {
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
                arrayList.add(LLDataCollectorConfiguration.CPU_TABLE);
            }
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
                arrayList.add(LLDataCollectorConfiguration.MEM_TABLE);
            }
            if (this.collectedData.contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
                arrayList.add(LLDataCollectorConfiguration.SYNC_TABLE);
            }
        }
        return arrayList;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<DataStorageType, DataStorage> map, DLightTarget dLightTarget) {
        Iterator<Map.Entry<String, File>> iterator;
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (!executionEnvironment.isLocal()) {
            for (Map.Entry<String, File> entry : this.locateProfAgents(executionEnvironment).entrySet()) {
                this.upload(executionEnvironment, (File)entry.getValue(), this.getRemoteDir(executionEnvironment, (File)entry.getValue(), entry.getKey()), 420);
            }
            iterator = this.locateProfMonitors(executionEnvironment).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, File> entry;
                entry = iterator.next();
                this.upload(executionEnvironment, entry.getValue(), this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()), 493);
            }
        }
        if (!NativeToolsUtil.isMacOSX(executionEnvironment)) {
            this.collectedData.remove((Object)LLDataCollectorConfiguration.CollectedData.CPU);
        }
        iterator = this.lock;
        synchronized (iterator) {
            this.target = dLightTarget;
        }
    }

    private void upload(ExecutionEnvironment executionEnvironment, File file, String string, int n) {
        try {
            CommonTasksSupport.mkDir((ExecutionEnvironment)executionEnvironment, (String)string, null).get();
            CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)executionEnvironment, (String)(string + "/" + file.getName()), (int)n, null).get();
        }
        catch (InterruptedException interruptedException) {
            DLightLogger.instance.log(Level.WARNING, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            DLightLogger.instance.log(Level.WARNING, null, executionException);
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return null;
    }

    public String[] getArgs() {
        return null;
    }

    public void setupEnvironment(DLightTarget dLightTarget, MacroMap macroMap) throws ConnectException {
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        boolean bl = NativeToolsUtil.isMacOSX(executionEnvironment);
        Map<String, File> map = this.locateProfAgents(executionEnvironment);
        if (!map.isEmpty()) {
            if (bl) {
                Map.Entry<String, File> entry = map.entrySet().iterator().next();
                macroMap.appendPathVariable("DYLD_INSERT_LIBRARIES", this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()) + '/' + entry.getValue().getName());
            } else {
                String string = null;
                for (Map.Entry<String, File> entry : map.entrySet()) {
                    if (string == null) {
                        string = entry.getValue().getName();
                    }
                    macroMap.appendPathVariable("LD_LIBRARY_PATH", this.getRemoteDir(executionEnvironment, entry.getValue(), entry.getKey()));
                }
                macroMap.appendPathVariable("LD_PRELOAD", string);
            }
        }
    }

    private String getRemoteDir(ExecutionEnvironment executionEnvironment, File file, String string) {
        String string2;
        if (executionEnvironment.isLocal()) {
            return file.getParentFile().getAbsolutePath();
        }
        try {
            string2 = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getTempDir();
        }
        catch (Throwable throwable) {
            string2 = "/var/tmp";
        }
        return string2 + "/tools/" + string;
    }

    private Map<String, File> locateProfAgents(ExecutionEnvironment executionEnvironment) {
        return NativeToolsUtil.getCompatibleBinaries(executionEnvironment, "prof_agent.${soext}");
    }

    private Map<String, File> locateProfMonitors(ExecutionEnvironment executionEnvironment) {
        return NativeToolsUtil.getCompatibleBinaries(executionEnvironment, "prof_monitor");
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.startMonitor();
                break;
            }
            case DONE: 
            case FAILED: 
            case STOPPED: 
            case TERMINATED: {
                this.stopMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitor() {
        CollectorRunner collectorRunner;
        Object object;
        ExecutionEnvironment executionEnvironment;
        AttachableTarget attachableTarget;
        Object object2 = this.lock;
        synchronized (object2) {
            attachableTarget = (AttachableTarget)this.target;
            executionEnvironment = this.target.getExecEnv();
            object = this.collectedData.clone();
        }
        object2 = null;
        Object object3 = this.locateProfMonitors(executionEnvironment).entrySet().iterator();
        if (object3.hasNext()) {
            collectorRunner = object3.next();
            object2 = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
            object2.setExecutable(this.getRemoteDir(executionEnvironment, collectorRunner.getValue(), collectorRunner.getKey()) + "/" + collectorRunner.getValue().getName());
        }
        if (object2 == null) {
            DLightLogger.instance.severe("Failed to find prof_monitor");
            return;
        }
        object3 = new StringBuilder("-");
        if (((AbstractCollection)object).contains((Object)LLDataCollectorConfiguration.CollectedData.CPU)) {
            ((StringBuilder)object3).append('c');
        }
        if (((AbstractCollection)object).contains((Object)LLDataCollectorConfiguration.CollectedData.MEM)) {
            ((StringBuilder)object3).append('m');
        }
        if (((AbstractCollection)object).contains((Object)LLDataCollectorConfiguration.CollectedData.SYNC)) {
            ((StringBuilder)object3).append('s');
        }
        object2 = object2.setArguments(new String[]{((StringBuilder)object3).toString(), String.valueOf(attachableTarget.getPID())});
        collectorRunner = new CollectorRunner((IndicatorNotificationsListener)new FakeIndicatorNotificationListener(), (NativeProcessBuilder)object2, (LineProcessor)new MonitorOutputProcessor(), "__EOF__", "prof_monitor");
        Object object4 = this.lock;
        synchronized (object4) {
            if (this.profRunner != null) {
                this.profRunner.shutdown();
            }
            this.profRunner = collectorRunner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        CollectorRunner collectorRunner;
        Object object = this.lock;
        synchronized (object) {
            collectorRunner = this.profRunner;
            this.profRunner = null;
        }
        if (collectorRunner != null) {
            collectorRunner.shutdown();
        }
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus validate(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            if (this.validationStatus.isValid()) {
                return this.validationStatus;
            }
            ValidationStatus validationStatus = this.validationStatus;
            ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
            this.notifyStatusChanged(validationStatus, validationStatus2);
            this.validationStatus = validationStatus2;
            return validationStatus2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.validationStatus = ValidationStatus.initialStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus getValidationStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.validationStatus;
        }
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
            AsynchronousAction asynchronousAction = ConnectionManager.getInstance().getConnectToAction(executionEnvironment, new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            });
            return ValidationStatus.unknownStatus((String)LLDataCollector.getMessage("ValidationStatus.HostNotConnected"), (AsynchronousAction)asynchronousAction);
        }
        HostInfo.OSFamily oSFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getOSFamily();
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (!(oSFamily == HostInfo.OSFamily.LINUX || ALLOW_ON_MACOSX && oSFamily == HostInfo.OSFamily.MACOSX)) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.ProfAgent.OSNotSupported"));
        }
        Map<String, File> map = this.locateProfAgents(executionEnvironment);
        if (map.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.AgentNotFound"));
        }
        Map<String, File> map2 = this.locateProfMonitors(executionEnvironment);
        if (map2.isEmpty()) {
            return ValidationStatus.invalidStatus((String)LLDataCollector.getMessage("ValidationStatus.MonitorNotFound"));
        }
        return ValidationStatus.validStatus();
    }

    private void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (!validationStatus.equals((Object)validationStatus2)) {
            for (ValidationListener validationListener : this.validationListeners.toArray(new ValidationListener[0])) {
                validationListener.validationStateChanged((Validateable)this, validationStatus, validationStatus2);
            }
        }
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(LLDataCollector.class, (String)string);
    }

    private class MonitorOutputProcessor
    implements LineProcessor {
        private float syncPrev = Float.NaN;

        private MonitorOutputProcessor() {
        }

        public void processLine(String string) {
            DataRow dataRow = null;
            if (string.startsWith("cpu:")) {
                String[] stringArray = string.substring(5).split("\t");
                dataRow = new DataRow(LLDataCollectorConfiguration.CPU_TABLE.getColumnNames(), Arrays.asList(Float.valueOf(stringArray[0]), Float.valueOf(stringArray[1])));
            } else if (string.startsWith("mem:")) {
                dataRow = new DataRow(LLDataCollectorConfiguration.MEM_TABLE.getColumnNames(), Arrays.asList(string.substring(5)));
            } else if (string.startsWith("sync:")) {
                String[] stringArray = string.substring(6).split("\t");
                float f = Float.parseFloat(stringArray[0]);
                if (!Float.isNaN(this.syncPrev)) {
                    int n = Integer.parseInt(stringArray[1]);
                    dataRow = new DataRow(LLDataCollectorConfiguration.SYNC_TABLE.getColumnNames(), Arrays.asList(Float.valueOf((f - this.syncPrev) * 100.0f / (float)n), n));
                }
                this.syncPrev = f;
            }
            if (dataRow != null) {
                LLDataCollector.this.notifyIndicators(Collections.singletonList(dataRow));
                LLDataCollector.this.suggestIndicatorsRepaint();
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FakeIndicatorNotificationListener
    implements IndicatorNotificationsListener {
        private FakeIndicatorNotificationListener() {
        }

        public void reset() {
            LLDataCollector.this.resetIndicators();
        }

        public void suggestRepaint() {
            LLDataCollector.this.suggestIndicatorsRepaint();
        }

        public void updated(List<DataRow> list) {
            LLDataCollector.this.notifyIndicators(list);
        }
    }
}

