/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SemanticHighlighter
extends HighlighterBase {
    private static final Logger LOG = Logger.getLogger(SemanticHighlighter.class.getName());
    private static final int MAX_LINE_NUMBER;

    public SemanticHighlighter(Document document) {
        super(document);
        this.init(document);
    }

    @Override
    protected void updateFontColors(FontColorProvider fontColorProvider) {
        for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
            semanticEntity.updateFontColors(fontColorProvider);
        }
    }

    public static PositionsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        PositionsBag positionsBag = (PositionsBag)document.getProperty(SemanticHighlighter.class);
        if (positionsBag == null) {
            positionsBag = new PositionsBag(document);
            document.putProperty(SemanticHighlighter.class, positionsBag);
        }
        return positionsBag;
    }

    public static boolean isVeryBigDocument(Document document) {
        if (!(document instanceof BaseDocument) || MAX_LINE_NUMBER < 0) {
            return false;
        }
        try {
            if (document.getLength() < MAX_LINE_NUMBER) {
                return false;
            }
            return Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)(document.getLength() - 1)) > MAX_LINE_NUMBER;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(final CsmReferenceRepository.Interrupter interrupter) {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            DocumentListener documentListener = null;
            if (interrupter instanceof InterrupterImpl) {
                documentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                };
                baseDocument.addDocumentListener(documentListener);
            }
            try {
                this.update(baseDocument, interrupter);
            }
            finally {
                if (documentListener != null) {
                    baseDocument.removeDocumentListener(documentListener);
                }
            }
        }
    }

    private void update(BaseDocument baseDocument, final CsmReferenceRepository.Interrupter interrupter) {
        boolean bl = baseDocument.getProperty((Object)"macro-expansion-view-document") != null;
        PositionsBag positionsBag = new PositionsBag((Document)baseDocument);
        positionsBag.clear();
        final CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
        long l = System.currentTimeMillis();
        if (csmFile != null && csmFile.isParsed()) {
            ReferenceCollector referenceCollector;
            SemanticEntity semanticEntity;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Semantic Highlighting update() have started for file " + csmFile.getAbsolutePath());
            }
            ArrayList<SemanticEntity> arrayList = new ArrayList<SemanticEntity>(SemanticEntitiesProvider.instance().get());
            final ArrayList<ReferenceCollector> arrayList2 = new ArrayList<ReferenceCollector>(arrayList.size());
            PositionsBag positionsBag2 = arrayList.iterator();
            while (positionsBag2.hasNext()) {
                semanticEntity = (SemanticEntity)positionsBag2.next();
                if (!(!NamedEntityOptions.instance().isEnabled((NamedEntity)semanticEntity) || bl && semanticEntity.getName().equals("macros"))) {
                    referenceCollector = semanticEntity.getCollector();
                    if (referenceCollector != null) {
                        arrayList2.add(referenceCollector);
                        continue;
                    }
                    this.addHighlightsToBag(positionsBag, semanticEntity.getBlocks(csmFile), semanticEntity);
                    positionsBag2.remove();
                    continue;
                }
                positionsBag2.remove();
            }
            positionsBag2 = SemanticHighlighter.getHighlightsBag((Document)baseDocument);
            if (positionsBag2 != null) {
                semanticEntity = new PositionsBag((Document)baseDocument);
                semanticEntity.addAllHighlights(positionsBag);
                referenceCollector = positionsBag.getHighlights(0, Integer.MAX_VALUE);
                HashSet<AttributeSet> hashSet = new HashSet<AttributeSet>();
                while (referenceCollector.moveNext()) {
                    hashSet.add(referenceCollector.getAttributes());
                }
                referenceCollector = positionsBag2.getHighlights(0, Integer.MAX_VALUE);
                while (referenceCollector.moveNext()) {
                    if (hashSet.contains(referenceCollector.getAttributes())) continue;
                    int n = SemanticHighlighter.getDocumentOffset((Document)baseDocument, referenceCollector.getStartOffset());
                    int n2 = SemanticHighlighter.getDocumentOffset((Document)baseDocument, referenceCollector.getEndOffset());
                    if (n >= baseDocument.getLength() || n2 <= 0) continue;
                    this.addHighlightsToBag((PositionsBag)semanticEntity, n, n2, referenceCollector.getAttributes(), "cached");
                }
                SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights((PositionsBag)semanticEntity);
            } else {
                SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(positionsBag);
            }
            if (!arrayList.isEmpty() && !SemanticHighlighter.isVeryBigDocument((Document)baseDocument)) {
                CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

                    public void visit(CsmReferenceContext csmReferenceContext) {
                        CsmReference csmReference = csmReferenceContext.getReference();
                        for (ReferenceCollector referenceCollector : arrayList2) {
                            if (interrupter.cancelled()) break;
                            referenceCollector.visit(csmReference, csmFile);
                        }
                    }
                }, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE_AND_PREPROCESSOR);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.addHighlightsToBag(positionsBag, ((ReferenceCollector)arrayList2.get(i)).getReferences(), (SemanticEntity)arrayList.get(i));
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Semantic Highlighting update() done in " + (System.currentTimeMillis() - l) + "ms for file " + csmFile.getAbsolutePath());
            }
        }
        if (!interrupter.cancelled()) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(positionsBag);
        }
    }

    private void addHighlightsToBag(PositionsBag positionsBag, List<? extends CsmOffsetable> list, SemanticEntity semanticEntity) {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            for (CsmOffsetable csmOffsetable : list) {
                int n = SemanticHighlighter.getDocumentOffset((Document)baseDocument, csmOffsetable.getStartOffset());
                int n2 = csmOffsetable.getEndOffset();
                n2 = SemanticHighlighter.getDocumentOffset((Document)baseDocument, n2 == Integer.MAX_VALUE ? baseDocument.getLength() + 1 : n2);
                if (n >= baseDocument.getLength() || n2 <= 0) continue;
                this.addHighlightsToBag(positionsBag, n, n2, semanticEntity.getAttributes(csmOffsetable), semanticEntity.getName());
            }
        }
    }

    private void addHighlightsToBag(PositionsBag positionsBag, int n, int n2, AttributeSet attributeSet, String string) {
        try {
            BaseDocument baseDocument = this.getDocument();
            if (baseDocument != null) {
                positionsBag.addHighlight(baseDocument.createPosition(n), baseDocument.createPosition(n2), attributeSet);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.FINE, "Can't add highlight <" + n + ", " + n2 + ", " + string + ">", badLocationException);
        }
    }

    private static int getDocumentOffset(Document document, int n) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)document, (int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        BaseDocument baseDocument;
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT || phase == CsmFileTaskFactory.PhaseRunner.Phase.PROJECT_PARSED) {
            InterrupterImpl interrupterImpl = new InterrupterImpl();
            try {
                this.addCancelListener(interrupterImpl);
                this.update(interrupterImpl);
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.removeCancelListener(interrupterImpl);
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP && (baseDocument = this.getDocument()) != null) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).clear();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isHighPriority() {
        return false;
    }

    static {
        String string = System.getProperty("cnd.semantic.line.limit");
        int n = 5000;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_LINE_NUMBER = n;
    }
}

