/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.RubyFormatter;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.hints.infrastructure.RubySelectionRule;
import org.netbeans.modules.ruby.hints.introduce.IntroduceFix;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKind;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKindFinder;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceHint
extends RubySelectionRule {
    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        ParserResult parserResult = rubyRuleContext.parserResult;
        int n = rubyRuleContext.selectionStart;
        int n2 = rubyRuleContext.selectionEnd;
        assert (n < n2);
        try {
            ClassNode classNode;
            Node node3;
            BaseDocument baseDocument = rubyRuleContext.doc;
            if (n2 > baseDocument.getLength()) {
                return;
            }
            if (n2 - n > 1000) {
                return;
            }
            if (RubyFormatter.getTokenBalance((BaseDocument)baseDocument, (int)n, (int)n2, (boolean)true, (RubyUtils.isRhtmlDocument((Document)baseDocument) || RubyUtils.isYamlDocument((Document)baseDocument) ? 1 : 0) != 0) != 0) {
                return;
            }
            Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
            if (node2 == null) {
                return;
            }
            OffsetRange offsetRange = this.adjustOffsets(parserResult, baseDocument, n, n2);
            if (offsetRange == OffsetRange.NONE) {
                return;
            }
            OffsetRange offsetRange2 = AstUtilities.getAstOffsets((Parser.Result)parserResult, (OffsetRange)offsetRange);
            if (offsetRange2 == OffsetRange.NONE) {
                return;
            }
            int n3 = offsetRange2.getStart();
            int n4 = offsetRange2.getEnd();
            HashMap<Integer, List<Node>> hashMap = new HashMap<Integer, List<Node>>();
            this.findApplicableNodes(node2, n3, n4, hashMap, 0);
            if (hashMap.keySet().size() != 1) {
                return;
            }
            List list2 = (List)hashMap.values().iterator().next();
            assert (list2.size() > 0);
            IntroduceKindFinder introduceKindFinder = new IntroduceKindFinder();
            ParseTreeWalker parseTreeWalker = new ParseTreeWalker((ParseTreeVisitor)introduceKindFinder);
            for (Node node3 : list2) {
                parseTreeWalker.walk(node3);
            }
            List<IntroduceKind> list3 = introduceKindFinder.getKinds();
            if (list3 == null || list3.size() == 0) {
                return;
            }
            node3 = new OffsetRange(n, n2);
            JTextComponent jTextComponent = GsfUtilities.getPaneFor((FileObject)RubyUtils.getFileObject((Parser.Result)parserResult));
            if (jTextComponent != null) {
                int n5 = jTextComponent.getCaret().getDot();
                if (n == n5) {
                    node3 = new OffsetRange(n, n);
                } else if (n2 == n5) {
                    node3 = new OffsetRange(n2, n2);
                }
            }
            if (RubyUtils.isRhtmlDocument((Document)baseDocument) || RubyUtils.isYamlDocument((Document)baseDocument)) {
                list3.retainAll(Collections.singleton(IntroduceKind.CREATE_VARIABLE));
            } else if (list3.contains((Object)IntroduceKind.CREATE_FIELD) && (classNode = AstUtilities.findClassAtOffset((Node)node2, (int)n)) == null) {
                list3.remove((Object)IntroduceKind.CREATE_FIELD);
                if (list3.size() == 0) {
                    return;
                }
            }
            for (IntroduceKind introduceKind : list3) {
                IntroduceFix introduceFix = new IntroduceFix(rubyRuleContext, list2, offsetRange, offsetRange2, introduceKind);
                ArrayList<IntroduceFix> arrayList = new ArrayList<IntroduceFix>(1);
                arrayList.add(introduceFix);
                String string = introduceFix.getDescription();
                Hint hint = new Hint((Rule)this, string, RubyUtils.getFileObject((Parser.Result)parserResult), (OffsetRange)node3, arrayList, 292);
                list.add(hint);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHint");
    }

    public String getId() {
        return "RubyIntroduceHint";
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private OffsetRange adjustOffsets(ParserResult parserResult, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5;
        int n6 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        n6 = n6 == -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2) : ++n6;
        if (n >= n6) {
            n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1;
            if (n5 <= baseDocument.getLength()) {
                n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n5);
                if (n4 != -1) {
                    n5 = n4;
                }
            } else {
                n5 = baseDocument.getLength();
            }
        } else {
            n5 = Math.max(n, Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n));
        }
        n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
        if (n4 == -1) {
            n3 = Math.max(0, Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) - 1);
        } else if (n2 <= n4) {
            n3 = Math.max(0, Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) - 1);
        } else {
            int n7 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2);
            n3 = Math.min(n2, n7 + 1);
        }
        n5 = Math.min(n5, baseDocument.getLength());
        n3 = Math.min(n3, baseDocument.getLength());
        if (n3 <= n5) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(n5, n3);
    }

    private void findApplicableNodes(Node node, int n, int n2, Map<Integer, List<Node>> map, int n3) {
        List list = node.childNodes();
        for (Node node2 : list) {
            if (node2.isInvisible()) continue;
            if (node2.getNodeType() == NodeType.NEWLINENODE || node2.getNodeType() == NodeType.HASHNODE) {
                this.findApplicableNodes(node2, n, n2, map, n3 + 1);
                continue;
            }
            boolean bl = false;
            SourcePosition sourcePosition = node2.getPosition();
            if (sourcePosition.getStartOffset() >= n && sourcePosition.getEndOffset() <= n2) {
                bl = true;
            } else if (sourcePosition.getStartOffset() <= n && sourcePosition.getEndOffset() >= n2) {
                if (sourcePosition.getStartOffset() == n && sourcePosition.getEndOffset() == n2) {
                    bl = true;
                } else {
                    this.findApplicableNodes(node2, n, n2, map, n3 + 1);
                }
            } else if (sourcePosition.getStartOffset() <= n && n <= sourcePosition.getEndOffset()) {
                this.findApplicableNodes(node2, n, n2, map, n3 + 1);
            } else if (sourcePosition.getStartOffset() <= n2 && n2 <= sourcePosition.getEndOffset()) {
                this.findApplicableNodes(node2, n, n2, map, n3 + 1);
            }
            if (!bl) continue;
            List<Node> list2 = map.get(n3);
            if (list2 == null) {
                list2 = new ArrayList<Node>();
                map.put(n3, list2);
            }
            list2.add(node2);
        }
    }
}

