/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertIfToUnless
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        ParserResult parserResult = rubyRuleContext.parserResult;
        IfNode ifNode = (IfNode)node;
        Node node2 = ifNode.getCondition();
        if (node2 == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().getNodeType() == NodeType.IFNODE) {
            return;
        }
        if (node2.getNodeType() == NodeType.NOTNODE || node2.getNodeType() == NodeType.NEWLINENODE && node2.childNodes().size() == 1 && ((Node)node2.childNodes().get(0)).getNodeType() == NodeType.NOTNODE) {
            try {
                TokenSequence tokenSequence;
                ConvertToUnlessFix convertToUnlessFix;
                BaseDocument baseDocument = rubyRuleContext.doc;
                int n = ConvertIfToUnless.findKeywordOffset(rubyRuleContext, ifNode);
                if (n == -1 || n > baseDocument.getLength() - 1) {
                    return;
                }
                OffsetRange offsetRange = AstUtilities.getRange((Node)node);
                if (RubyUtils.isRhtmlDocument((Document)baseDocument) || RubyUtils.isYamlDocument((Document)baseDocument)) {
                    if ((offsetRange = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)offsetRange)) == OffsetRange.NONE) {
                        return;
                    }
                    try {
                        baseDocument.readLock();
                        convertToUnlessFix = TokenHierarchy.get((Document)baseDocument);
                        tokenSequence = convertToUnlessFix.tokenSequence();
                        tokenSequence.move(offsetRange.getStart());
                        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                            return;
                        }
                        if (tokenSequence.offset() + tokenSequence.token().length() < offsetRange.getEnd()) {
                            return;
                        }
                    }
                    finally {
                        if (baseDocument != null) {
                            baseDocument.readUnlock();
                        }
                    }
                }
                if ((convertToUnlessFix = new ConvertToUnlessFix(rubyRuleContext, ifNode)).getEditList() == null) {
                    return;
                }
                tokenSequence = Collections.singletonList(convertToUnlessFix);
                String string = NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
                Hint hint = new Hint((Rule)this, string, RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange, (List)tokenSequence, 500);
                list.add(hint);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    public String getId() {
        return "ConvertIfToUnless";
    }

    public String getDescription() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    static int findKeywordOffset(RubyRuleContext rubyRuleContext, IfNode ifNode) throws BadLocationException {
        BaseDocument baseDocument = rubyRuleContext.doc;
        ParserResult parserResult = rubyRuleContext.parserResult;
        int n = ifNode.getPosition().getStartOffset();
        int n2 = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)n);
        if (n2 == -1 || n2 > baseDocument.getLength()) {
            return -1;
        }
        String string = baseDocument.getText(n2, 2);
        if (string.equals("if")) {
            if (n2 > 3 && "elsif".equals(string = baseDocument.getText(n2 - 3, 5))) {
                return -1;
            }
            return n2;
        }
        if (string.equals("un")) {
            return n2;
        }
        int n3 = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)AstUtilities.getRange((Node)ifNode.getCondition()).getStart());
        int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
        if (n4 != -1 && n4 < n3) {
            String string2 = baseDocument.getText(n4, n3 - n4).trim();
            if (string2.endsWith("elsif")) {
                return -1;
            }
            if (string2.endsWith("if")) {
                return n4 + string2.length() - 2;
            }
            if (string2.endsWith("unless")) {
                return n4 + string2.length() - 6;
            }
        }
        return -1;
    }

    private class ConvertToUnlessFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final IfNode ifNode;

        public ConvertToUnlessFix(RubyRuleContext rubyRuleContext, IfNode ifNode) {
            this.context = rubyRuleContext;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            String string;
            String string2;
            String string3 = "if";
            String string4 = "unless";
            if (this.ifNode.getThenBody() != null) {
                string2 = string3;
                string = string4;
            } else {
                string2 = string4;
                string = string3;
            }
            return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessFix", (Object)string2, (Object)string);
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() {
            BaseDocument baseDocument = this.context.doc;
            try {
                int n;
                int n2;
                Node node = this.ifNode.getCondition();
                if (node.getNodeType() != NodeType.NOTNODE) {
                    Node node2;
                    assert (node.getNodeType() == NodeType.NEWLINENODE);
                    Node node3 = node2 = node.childNodes().size() == 1 ? (Node)node.childNodes().get(0) : null;
                    if (node2 != null && node2.getNodeType() == NodeType.NOTNODE) {
                        node = node2;
                    } else {
                        assert (false) : node2;
                        return null;
                    }
                }
                int n3 = 1;
                ParserResult parserResult = this.context.parserResult;
                int n4 = AstUtilities.getRange((Node)node).getStart();
                int n5 = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)n4);
                if (n5 == -1 || n5 > baseDocument.getLength() - 1) {
                    return null;
                }
                int n6 = this.ifNode.getPosition().getStartOffset();
                int n7 = LexUtilities.getLexerOffset((Parser.Result)parserResult, (int)n6);
                if (n7 == -1 || n7 > baseDocument.getLength()) {
                    return null;
                }
                boolean bl = false;
                char c = baseDocument.getText(n5, 1).charAt(0);
                if (c != '!') {
                    n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5);
                    String string = baseDocument.getText(n5, n2 - n5);
                    n = string.indexOf("!=");
                    if (n == -1) {
                        n = string.indexOf("!~");
                        if (n != -1) {
                            n5 += n;
                        } else {
                            String string2;
                            boolean bl2 = false;
                            if (n5 < baseDocument.getLength() - 3 && "not".equals(string2 = baseDocument.getText(n5, 3))) {
                                n3 = 3;
                                if (n5 < baseDocument.getLength() - 4 && "not ".equals(string2 = baseDocument.getText(n5, 4))) {
                                    n3 = 4;
                                }
                                bl2 = true;
                            }
                            if (!bl2) {
                                assert (false) : string;
                                return null;
                            }
                        }
                    } else {
                        n5 += n;
                        bl = true;
                    }
                }
                if ((n2 = ConvertIfToUnless.findKeywordOffset(this.context, this.ifNode)) == -1 || n2 > baseDocument.getLength() - 1) {
                    return null;
                }
                assert (n2 < n5);
                char c2 = baseDocument.getText(n2, 1).charAt(0);
                n = c2 == 'i' ? 1 : 0;
                EditList editList = new EditList(baseDocument);
                if (bl) {
                    editList.replace(n5, 1, "=", false, 0);
                } else {
                    editList.replace(n5, n3, null, false, 0);
                }
                if (n != 0) {
                    editList.replace(n2, 2, "unless", false, 1);
                } else {
                    editList.replace(n2, 6, "if", false, 1);
                }
                return editList;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

