/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.parser;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.css.parser.CssParserTreeConstants;
import org.netbeans.modules.css.parser.Node;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.Token;

public class SimpleNodeUtil {
    public static String unquotedValue(String string) {
        return SimpleNodeUtil.isValueQuoted(string) ? string.substring(1, string.length() - 1) : string;
    }

    public static boolean isValueQuoted(String string) {
        if (string.length() < 2) {
            return false;
        }
        return !(string.charAt(0) != '\'' && string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\'' && string.charAt(string.length() - 1) != '\"');
    }

    public static Token getNodeToken(SimpleNode simpleNode, int n) {
        Token token = simpleNode.jjtGetFirstToken();
        if (token == null) {
            return null;
        }
        do {
            if (token.kind != n) continue;
            return token;
        } while ((token = token.next) != simpleNode.jjtGetLastToken());
        return null;
    }

    public static SimpleNode findDescendant(SimpleNode simpleNode, int n) {
        int n2 = simpleNode.startOffset();
        int n3 = simpleNode.endOffset();
        if (n < n2 || n > n3) {
            return null;
        }
        if (n >= n2 && n <= n3 && simpleNode.jjtGetNumChildren() == 0) {
            return simpleNode;
        }
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            int n4 = simpleNode2.startOffset();
            int n5 = simpleNode2.endOffset();
            if (n < n4 || n > n5) continue;
            return SimpleNodeUtil.findDescendant(simpleNode2, n);
        }
        return simpleNode;
    }

    public static SimpleNode getChildByType(SimpleNode simpleNode, int n) {
        SimpleNode[] simpleNodeArray = SimpleNodeUtil.getChildrenByType(simpleNode, n);
        return simpleNodeArray.length == 0 ? null : simpleNodeArray[0];
    }

    public static SimpleNode[] getChildrenByType(SimpleNode simpleNode, int n) {
        int n2 = simpleNode.children.length;
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>(n2 / 4);
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.children[i];
            if (simpleNode2.kind() != n) continue;
            arrayList.add(simpleNode2);
        }
        return arrayList.toArray(new SimpleNode[0]);
    }

    public static void visitChildren(SimpleNode simpleNode, NodeVisitor nodeVisitor) {
        Node[] nodeArray = simpleNode.children;
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                SimpleNode simpleNode2 = (SimpleNode)nodeArray[i];
                if (simpleNode2 == null) continue;
                nodeVisitor.visit(simpleNode2);
                simpleNode2.visitChildren(nodeVisitor);
            }
        }
    }

    public static void visitAncestors(SimpleNode simpleNode, NodeVisitor nodeVisitor) {
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.parent;
        if (simpleNode2 != null) {
            nodeVisitor.visit(simpleNode2);
            SimpleNodeUtil.visitAncestors(simpleNode2, nodeVisitor);
        }
    }

    public static SimpleNode getSibling(SimpleNode simpleNode, boolean bl) {
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
        if (simpleNode2 == null) {
            return null;
        }
        if (simpleNode2.children == null) {
            return null;
        }
        SimpleNode simpleNode3 = null;
        for (int i = 0; i < simpleNode2.children.length; ++i) {
            SimpleNode simpleNode4 = (SimpleNode)simpleNode2.children[i];
            if (simpleNode4 != simpleNode) continue;
            if (bl) {
                if (i == 0) {
                    return null;
                }
                return (SimpleNode)simpleNode2.children[i - 1];
            }
            if (i == simpleNode2.children.length - 1) {
                return null;
            }
            return (SimpleNode)simpleNode2.children[i + 1];
        }
        return simpleNode3;
    }

    public static SimpleNode query(SimpleNode simpleNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        SimpleNode simpleNode2 = simpleNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(124);
            String string3 = n >= 0 ? string2.substring(0, n) : string2;
            String string4 = n >= 0 ? string2.substring(n + 1, string2.length()) : "0";
            int n2 = Integer.parseInt(string4);
            int n3 = 0;
            SimpleNode simpleNode3 = null;
            if (simpleNode2.children != null) {
                for (Node node : simpleNode2.children) {
                    SimpleNode simpleNode4 = (SimpleNode)node;
                    if (!CssParserTreeConstants.jjtNodeName[simpleNode4.kind()].equals(string3) || n3++ != n2) continue;
                    simpleNode3 = simpleNode4;
                    break;
                }
            }
            if (simpleNode3 != null) {
                simpleNode2 = simpleNode3;
                if (stringTokenizer.hasMoreTokens()) continue;
                assert (CssParserTreeConstants.jjtNodeName[simpleNode2.kind()].equals(string3));
                return simpleNode2;
            }
            return null;
        }
        return null;
    }
}

