/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpProjectGenerator {
    public static final Monitor DEV_NULL = new Monitor(){

        public void starting() {
        }

        public void creatingIndexFile() {
        }

        public void finishing() {
        }
    };

    private PhpProjectGenerator() {
    }

    public static AntProjectHelper createProject(ProjectProperties projectProperties, Monitor monitor) throws IOException {
        if (monitor == null) {
            monitor = DEV_NULL;
        }
        monitor.starting();
        ProjectProperties projectProperties2 = new ProjectProperties(projectProperties);
        boolean bl = projectProperties2.getSourcesDirectory().exists();
        FileObject fileObject = FileUtil.createFolder((File)projectProperties2.getSourcesDirectory());
        AntProjectHelper antProjectHelper = PhpProjectGenerator.createProject0(projectProperties2);
        PhpProjectGenerator.logUsage(antProjectHelper.getProjectDirectory(), fileObject, projectProperties2.getRunAsType(), projectProperties2.isCopySources(), projectProperties2.getFrameworkExtenders());
        String string = projectProperties2.getIndexFile();
        if (!bl && string != null) {
            monitor.creatingIndexFile();
            FileObject fileObject2 = null;
            PhpProjectProperties.RunAsType runAsType = projectProperties2.getRunAsType();
            if (runAsType == null) {
                fileObject2 = Templates.getTemplate((WizardDescriptor)projectProperties2.getDescriptor());
            } else {
                switch (runAsType) {
                    case SCRIPT: {
                        fileObject2 = FileUtil.getConfigFile((String)"Templates/Scripting/EmptyPHP");
                        break;
                    }
                    default: {
                        fileObject2 = Templates.getTemplate((WizardDescriptor)projectProperties2.getDescriptor());
                    }
                }
            }
            assert (fileObject2 != null) : "Template for Index PHP file cannot be null";
            PhpProjectGenerator.createIndexFile(fileObject2, fileObject, string);
        }
        monitor.finishing();
        return antProjectHelper;
    }

    private static AntProjectHelper createProject0(final ProjectProperties projectProperties) throws IOException {
        File file = projectProperties.getProjectDirectory();
        if (file == null) {
            file = projectProperties.getSourcesDirectory();
        }
        assert (file != null);
        FileObject fileObject = FileUtil.createFolder((File)file);
        final AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.php.project");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws MutexException {
                    try {
                        Element element = antProjectHelper.getPrimaryConfigurationData(true);
                        Document document = element.getOwnerDocument();
                        Element element2 = document.createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                        element2.appendChild(document.createTextNode(projectProperties.getName()));
                        element.appendChild(element2);
                        antProjectHelper.putPrimaryConfigurationData(element, true);
                        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
                        PhpProjectGenerator.configureSources(antProjectHelper, projectProperties, editableProperties, editableProperties2);
                        PhpProjectGenerator.configureEncoding(projectProperties, editableProperties, editableProperties2);
                        PhpProjectGenerator.configureTags(projectProperties, editableProperties, editableProperties2);
                        PhpProjectGenerator.configureIncludePath(projectProperties, editableProperties, editableProperties2);
                        PhpProjectGenerator.configureUrl(projectProperties, editableProperties, editableProperties2);
                        if (projectProperties.getRunAsType() != null) {
                            PhpProjectGenerator.configureCopySources(projectProperties, editableProperties, editableProperties2);
                            PhpProjectGenerator.configureIndexFile(projectProperties, editableProperties, editableProperties2);
                            PhpProjectGenerator.configureRunConfiguration(projectProperties, editableProperties, editableProperties2);
                        }
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
                        Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        throw new MutexException((Exception)iOException);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exception exception = mutexException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            Exceptions.printStackTrace((Throwable)mutexException);
        }
        return antProjectHelper;
    }

    private static void configureSources(AntProjectHelper antProjectHelper, ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        File file = projectProperties.getSourcesDirectory();
        File file2 = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        String string = PropertyUtils.relativizeFile((File)file2, (File)file);
        if (string == null) {
            string = file.getAbsolutePath();
        }
        editableProperties.setProperty("src.dir", string);
        editableProperties.setProperty("web.root", ".");
        editableProperties.setProperty("php.version", projectProperties.getPhpVersion().name());
    }

    private static void configureEncoding(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        Charset charset = projectProperties.getCharset();
        editableProperties.setProperty("source.encoding", charset.name());
        FileEncodingQuery.setDefaultEncoding((Charset)charset);
    }

    private static void configureTags(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties.setProperty("tags.short", String.valueOf(true));
        editableProperties.setProperty("tags.asp", String.valueOf(false));
    }

    private static void configureIncludePath(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties.setProperty("include.path", "${php.global.include.path}");
    }

    private static void configureUrl(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties2.put("url", projectProperties.getUrl());
    }

    private static void configureCopySources(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        String string = "";
        File file = projectProperties.getCopySourcesTarget();
        if (file != null) {
            string = file.getAbsolutePath();
        }
        editableProperties2.put("copy.src.files", String.valueOf(projectProperties.isCopySources()));
        editableProperties2.put("copy.src.target", string);
    }

    private static void configureIndexFile(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        String string = projectProperties.getIndexFile();
        if (string != null) {
            editableProperties2.setProperty("index.file", string);
        }
    }

    private static void configureRunConfiguration(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        PhpProjectProperties.RunAsType runAsType = projectProperties.getRunAsType();
        editableProperties2.put("run.as", runAsType.name());
        switch (runAsType) {
            case SCRIPT: 
            case LOCAL: {
                break;
            }
            case REMOTE: {
                PhpProjectGenerator.configureRunAsRemoteWeb(projectProperties, editableProperties, editableProperties2);
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)runAsType);
                break;
            }
        }
    }

    private static void configureRunAsRemoteWeb(ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2) {
        RemoteConfiguration remoteConfiguration = projectProperties.getRemoteConfiguration();
        String string = projectProperties.getRemoteDirectory();
        PhpProjectProperties.UploadFiles uploadFiles = projectProperties.getUploadFiles();
        assert (remoteConfiguration != null);
        assert (uploadFiles != null);
        editableProperties2.put("remote.connection", remoteConfiguration.getName());
        editableProperties2.put("remote.directory", string);
        editableProperties2.put("remote.upload", uploadFiles.name());
    }

    private static DataObject createIndexFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        String string2 = PhpProjectGenerator.getIndexFileName(string, fileObject.getExt());
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string2);
    }

    private static String getIndexFileName(String string, String string2) {
        String string3 = "." + string2;
        if (string.endsWith(string3)) {
            return string.substring(0, string.length() - string3.length());
        }
        return string;
    }

    private static void logUsage(FileObject fileObject, FileObject fileObject2, PhpProjectProperties.RunAsType runAsType, Boolean bl, Map<PhpFrameworkProvider, PhpModuleExtender> map) {
        assert (fileObject != null);
        assert (fileObject2 != null);
        StringBuilder stringBuilder = new StringBuilder(200);
        for (PhpFrameworkProvider phpFrameworkProvider : map.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(phpFrameworkProvider.getName());
        }
        PhpProjectUtils.logUsage(PhpProjectGenerator.class, "USG_PROJECT_CREATE_PHP", Arrays.asList(FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", runAsType != null ? runAsType.name() : "", "1", bl != null && bl == Boolean.TRUE ? "COPY_FILES_YES" : "COPY_FILES_NO", stringBuilder.toString()));
    }

    public static interface Monitor {
        public void starting();

        public void creatingIndexFile();

        public void finishing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProjectProperties {
        private File projectDirectory;
        private File sourcesDirectory;
        private String name;
        private PhpProjectProperties.RunAsType runAsType;
        private PhpLanguageOptions.PhpVersion phpVersion;
        private Charset charset;
        private String url;
        private String indexFile;
        private WizardDescriptor descriptor;
        private Boolean copySources;
        private File copySourcesTarget;
        private RemoteConfiguration remoteConfiguration;
        private String remoteDirectory;
        private PhpProjectProperties.UploadFiles uploadFiles;
        private Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders;

        public ProjectProperties() {
        }

        public ProjectProperties(ProjectProperties projectProperties) {
            this.setProjectDirectory(projectProperties.projectDirectory);
            this.setSourcesDirectory(projectProperties.sourcesDirectory);
            this.setName(projectProperties.name);
            this.setRunAsType(projectProperties.runAsType);
            this.setPhpVersion(projectProperties.phpVersion);
            this.setCharset(projectProperties.charset);
            this.setUrl(projectProperties.url);
            this.setIndexFile(projectProperties.indexFile);
            this.setDescriptor(projectProperties.descriptor);
            this.setCopySources(projectProperties.copySources);
            this.setCopySourcesTarget(projectProperties.copySourcesTarget);
            this.setRemoteConfiguration(projectProperties.remoteConfiguration);
            this.setRemoteDirectory(projectProperties.remoteDirectory);
            this.setUploadFiles(projectProperties.uploadFiles);
            this.setFrameworkExtenders(projectProperties.frameworkExtenders);
        }

        public String getName() {
            return this.name;
        }

        public ProjectProperties setName(String string) {
            assert (string != null);
            this.name = string;
            return this;
        }

        public File getSourcesDirectory() {
            return this.sourcesDirectory;
        }

        public ProjectProperties setSourcesDirectory(File file) {
            assert (file != null);
            this.sourcesDirectory = FileUtil.normalizeFile((File)file);
            return this;
        }

        public File getProjectDirectory() {
            return this.projectDirectory;
        }

        public ProjectProperties setProjectDirectory(File file) {
            if (file != null) {
                file = FileUtil.normalizeFile((File)file);
            }
            this.projectDirectory = file;
            return this;
        }

        public PhpProjectProperties.RunAsType getRunAsType() {
            return this.runAsType;
        }

        public ProjectProperties setRunAsType(PhpProjectProperties.RunAsType runAsType) {
            this.runAsType = runAsType;
            return this;
        }

        public PhpLanguageOptions.PhpVersion getPhpVersion() {
            return this.phpVersion;
        }

        public ProjectProperties setPhpVersion(PhpLanguageOptions.PhpVersion phpVersion) {
            assert (phpVersion != null);
            this.phpVersion = phpVersion;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public ProjectProperties setCharset(Charset charset) {
            assert (charset != null);
            this.charset = charset;
            return this;
        }

        public String getUrl() {
            assert (this.url != null);
            return this.url;
        }

        public ProjectProperties setUrl(String string) {
            this.url = string;
            return this;
        }

        public Boolean isCopySources() {
            return this.copySources;
        }

        public ProjectProperties setCopySources(Boolean bl) {
            this.copySources = bl;
            return this;
        }

        public File getCopySourcesTarget() {
            return this.copySourcesTarget;
        }

        public ProjectProperties setCopySourcesTarget(File file) {
            if (file != null) {
                file = FileUtil.normalizeFile((File)file);
            }
            this.copySourcesTarget = file;
            return this;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public ProjectProperties setIndexFile(String string) {
            this.indexFile = string;
            return this;
        }

        public WizardDescriptor getDescriptor() {
            return this.descriptor;
        }

        public ProjectProperties setDescriptor(WizardDescriptor wizardDescriptor) {
            assert (wizardDescriptor != null);
            this.descriptor = wizardDescriptor;
            return this;
        }

        public RemoteConfiguration getRemoteConfiguration() {
            return this.remoteConfiguration;
        }

        public ProjectProperties setRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
            this.remoteConfiguration = remoteConfiguration;
            return this;
        }

        public String getRemoteDirectory() {
            return this.remoteDirectory;
        }

        public ProjectProperties setRemoteDirectory(String string) {
            this.remoteDirectory = string;
            return this;
        }

        public PhpProjectProperties.UploadFiles getUploadFiles() {
            return this.uploadFiles;
        }

        public ProjectProperties setUploadFiles(PhpProjectProperties.UploadFiles uploadFiles) {
            this.uploadFiles = uploadFiles;
            return this;
        }

        public Map<PhpFrameworkProvider, PhpModuleExtender> getFrameworkExtenders() {
            if (this.frameworkExtenders == null) {
                return Collections.emptyMap();
            }
            return this.frameworkExtenders;
        }

        public ProjectProperties setFrameworkExtenders(Map<PhpFrameworkProvider, PhpModuleExtender> map) {
            assert (map != null);
            this.frameworkExtenders = map;
            return this;
        }
    }
}

