/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.ui.TransferFilter;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConfirmationPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
CancelablePanel,
ChangeListener {
    static final String REMOTE_FILES = "remoteFiles";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final String[] steps;
    private RemoteConfirmationPanelVisual confirmationPanel = null;
    private WizardDescriptor descriptor = null;
    private volatile boolean canceled;
    private volatile RemoteClient remoteClient;

    public RemoteConfirmationPanel(String[] stringArray) {
        this.steps = stringArray;
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.confirmationPanel == null) {
            this.confirmationPanel = new RemoteConfirmationPanelVisual(this, this.descriptor);
            this.confirmationPanel.addRemoteConfirmationListener(this);
        }
        return this.confirmationPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RemoteConfirmationPanel.class);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.descriptor = wizardDescriptor;
        this.getComponent();
        this.canceled = false;
        this.fetchRemoteFiles();
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        this.descriptor = wizardDescriptor;
        this.getComponent();
        this.cancel();
        wizardDescriptor.putProperty(REMOTE_FILES, this.confirmationPanel.getRemoteFiles());
    }

    public boolean isValid() {
        switch (this.confirmationPanel.getState()) {
            case FETCHING: {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
                this.descriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"LBL_FetchingRemoteFiles"));
                return false;
            }
            case NO_FILES: {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"MSG_NoFilesAvailable"));
                return false;
            }
            case FILES: {
                if (!this.confirmationPanel.getRemoteFiles().isEmpty()) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"MSG_NoFilesSelected"));
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)this.confirmationPanel.getState()));
            }
        }
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public boolean isFinishPanel() {
        return true;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.remoteClient != null) {
            this.remoteClient.cancel();
        }
    }

    void fetchRemoteFiles() {
        this.getComponent();
        this.confirmationPanel.setFetchingFiles();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"LBL_FetchingRemoteFilesProgress"));
                try {
                    progressHandle.start();
                    Set set = null;
                    String string = "";
                    try {
                        set = RemoteConfirmationPanel.this.getRemoteFiles();
                    }
                    catch (RemoteException remoteException) {
                        Logger.getLogger(RemoteConfirmationPanel.class.getName()).log(Level.INFO, "Cannot fetch files", remoteException);
                        string = remoteException.getMessage();
                    }
                    final boolean bl = TransferFilter.hasAnyTransferableFiles(set);
                    final Set set2 = set;
                    final String string2 = string;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (RemoteConfirmationPanel.this.canceled) {
                                return;
                            }
                            if (bl) {
                                RemoteConfirmationPanel.this.confirmationPanel.setRemoteFiles(set2);
                            } else {
                                RemoteConfirmationPanel.this.confirmationPanel.setNoFiles(string2);
                            }
                            RemoteConfirmationPanel.this.changeSupport.fireChange();
                        }
                    });
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    progressHandle.finish();
                    throw throwable;
                }
                progressHandle.finish();
            }
        });
    }

    private Set<TransferFile> getRemoteFiles() throws RemoteException {
        assert (this.descriptor != null);
        File file = NewPhpProjectWizardIterator.getSources(this.descriptor);
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.descriptor.getProperty("remoteConnection");
        InputOutput inputOutput = RemoteCommand.getRemoteLog(remoteConfiguration.getDisplayName());
        String string = (String)this.descriptor.getProperty("remoteDirectory");
        this.remoteClient = new RemoteClient(remoteConfiguration, new RemoteClient.AdvancedProperties().setInputOutput(inputOutput).setAdditionalInitialSubdirectory(string).setPreservePermissions(false));
        return this.remoteClient.prepareDownload(file, file);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }
}

