/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AskForUrlPanel
extends JPanel {
    private static final long serialVersionUID = 9261149997804215L;
    private final PhpProject project;
    private final JTextField urlComboBoxEditor;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport;
    private JComboBox urlComboBox;
    private JLabel urlLabel;

    AskForUrlPanel(PhpProject phpProject, URL uRL) {
        assert (phpProject != null);
        assert (uRL != null);
        this.project = phpProject;
        this.initComponents();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(uRL.toExternalForm());
        linkedHashSet.addAll(ProjectSettings.getDebugUrls(phpProject));
        for (String string : linkedHashSet) {
            this.urlComboBox.addItem(string);
        }
        this.urlComboBoxEditor = (JTextField)this.urlComboBox.getEditor().getEditorComponent();
        this.urlComboBoxEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AskForUrlPanel.this.validateFields();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AskForUrlPanel.this.validateFields();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AskForUrlPanel.this.validateFields();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        boolean bl;
        LinkedHashSet<String> linkedHashSet;
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(AskForUrlPanel.class, (String)"LBL_SpecifyUrl"), true, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            this.validateFields();
            dialog.setVisible(true);
            linkedHashSet = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        boolean bl2 = bl = this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
        if (bl) {
            linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add((String)this.urlComboBox.getSelectedItem());
            for (int i = 1; i < this.urlComboBox.getItemCount(); ++i) {
                linkedHashSet.add((String)this.urlComboBox.getItemAt(i));
            }
            ProjectSettings.setDebugUrls(this.project, new ArrayList<String>(linkedHashSet));
        }
        return bl;
    }

    public URL getUrl() {
        try {
            return new URL((String)this.urlComboBox.getSelectedItem());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("The URL must already be valid!", malformedURLException);
        }
    }

    void validateFields() {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        String string = this.urlComboBoxEditor.getText();
        if (!Utils.isValidUrl(string)) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(AskForUrlPanel.class, (String)"MSG_InvalidUrl"));
            this.descriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.urlLabel = new JLabel();
        this.urlComboBox = new JComboBox();
        this.urlLabel.setLabelFor(this.urlComboBox);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(AskForUrlPanel.class, (String)"AskForUrlPanel.urlLabel.text"));
        this.urlComboBox.setEditable(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.urlLabel).addPreferredGap(0).add((Component)this.urlComboBox, 0, 337, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlComboBox, -2, -1, -2)).add(0, 0, Short.MAX_VALUE)));
    }
}

