/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.DebugProjectCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DebugFileCommand
extends Command
implements Displayable {
    public static final String ID = "debug.single";
    public static final String DISPLAY_NAME = DebugProjectCommand.DISPLAY_NAME;

    public DebugFileCommand(PhpProject phpProject) {
        super(phpProject);
    }

    public void invokeAction(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup);
        if (this.isSeleniumFile(fileObject)) {
            ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).debugFile(lookup);
        } else if (this.isTestFile(fileObject)) {
            ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).debugFile(lookup);
        } else {
            ConfigAction configAction = this.getConfigAction();
            if (!configAction.isValid(false)) {
                return;
            }
            configAction.debugFile(lookup);
        }
    }

    public boolean isActionEnabled(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup);
        if (this.isSeleniumFile(fileObject)) {
            return ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).isDebugFileEnabled(lookup);
        }
        if (this.isTestFile(fileObject)) {
            return ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).isDebugFileEnabled(lookup);
        }
        return this.getConfigAction().isDebugFileEnabled(lookup);
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

