/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SftpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 2815423138730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JButton identityFileBrowseButton;
    private JLabel identityFileLabel;
    private JTextField identityFileTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JButton knownHostsFileBrowseButton;
    private JLabel knownHostsFileLabel;
    private JTextField knownHostsFileTextField;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public SftpConfigurationPanel() {
        this.initComponents();
        this.registerListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean isValidConfiguration() {
        String string = RemoteValidator.validateRememberPassword(this.passwordTextField.getPassword());
        this.setWarning(string);
        string = RemoteValidator.validateHost(this.hostTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        string = RemoteValidator.validatePort(this.portTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        string = RemoteValidator.validateUser(this.userTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        if (!this.validateIdentityFile()) {
            return false;
        }
        if (!this.validateKnownHostsFile()) {
            return false;
        }
        if (!this.validateInitialDirectory()) {
            return false;
        }
        string = RemoteValidator.validateTimeout(this.timeoutTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        this.setError(null);
        return true;
    }

    public String getError() {
        return this.error;
    }

    protected void setError(String string) {
        this.error = string;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String string) {
        this.warning = string;
    }

    private void registerListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.hostTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.portTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.userTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.passwordTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.knownHostsFileTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.identityFileTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.timeoutTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private boolean validateIdentityFile() {
        return this.validateFile(this.getIdentityFile(), NbBundle.getMessage(SftpConfiguration.class, (String)"LBL_IdentityFile"));
    }

    private boolean validateKnownHostsFile() {
        return this.validateFile(this.getKnownHostsFile(), NbBundle.getMessage(SftpConfiguration.class, (String)"LBL_KnownHostsFile"));
    }

    private boolean validateFile(String string, String string2) {
        if (!StringUtils.hasText((String)string)) {
            return true;
        }
        File file = new File(string);
        if (!file.isFile()) {
            this.setError(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"MSG_FileNotFile", (Object)string2));
            return false;
        }
        if (!file.isAbsolute()) {
            this.setError(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"MSG_FileNotAbsolute", (Object)string2));
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String string = RunAsValidator.validateUploadDirectory(this.getInitialDirectory(), false);
        if (string != null) {
            this.setError(string);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.knownHostsFileLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.passwordLabelInfo = new JLabel();
        this.identityFileLabel = new JLabel();
        this.identityFileTextField = new JTextField();
        this.identityFileBrowseButton = new JButton();
        this.knownHostsFileTextField = new JTextField();
        this.knownHostsFileBrowseButton = new JButton();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.setFocusTraversalPolicy(null);
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.text"));
        this.knownHostsFileLabel.setLabelFor(this.knownHostsFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.knownHostsFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.text"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.text"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.text"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.text"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.text"));
        this.identityFileLabel.setLabelFor(this.identityFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.identityFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.identityFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.text"));
        this.identityFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SftpConfigurationPanel.this.identityFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.knownHostsFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.text"));
        this.knownHostsFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SftpConfigurationPanel.this.knownHostsFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.text"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.text"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.passwordLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.hostLabel).add((Component)this.userLabel).add((Component)this.initialDirectoryLabel).add((Component)this.timeoutLabel).add((Component)this.identityFileLabel).add((Component)this.knownHostsFileLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.passwordLabelInfo, -2, -1, -2).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.knownHostsFileTextField, -1, 170, Short.MAX_VALUE).add(1, (Component)this.identityFileTextField, -1, 170, Short.MAX_VALUE).add(1, (Component)this.userTextField, -1, 170, Short.MAX_VALUE).add(1, (Component)this.hostTextField, -1, 170, Short.MAX_VALUE).add(1, (Component)this.timeoutTextField, -1, 170, Short.MAX_VALUE).add((Component)this.passwordTextField, -1, 170, Short.MAX_VALUE).add((Component)this.initialDirectoryTextField, -1, 170, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.portLabel).addPreferredGap(0).add((Component)this.portTextField)).add((Component)this.identityFileBrowseButton)).add(2, (Component)this.knownHostsFileBrowseButton)).add(0, 0, 0)))));
        groupLayout.linkSize(new Component[]{this.identityFileBrowseButton, this.knownHostsFileBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.portLabel).add((Component)this.portTextField, -2, -1, -2).add((Component)this.hostTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.userTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.passwordLabelInfo, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.identityFileTextField, -2, -1, -2).add((Component)this.identityFileLabel).add((Component)this.identityFileBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.knownHostsFileTextField, -2, -1, -2).add((Component)this.knownHostsFileBrowseButton).add((Component)this.knownHostsFileLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.initialDirectoryLabel).add((Component)this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.timeoutTextField, -2, -1, -2).add((Component)this.timeoutLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleName"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.identityFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleName"));
        this.identityFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleDescription"));
        this.identityFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleName"));
        this.identityFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleDescription"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleName"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleName"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleDescription"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleName"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    private void identityFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseFileAction(this, LastUsedFolders.getPrivateKey(), NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectIdentityFile"));
        if (file != null) {
            this.setIdentityFile(file.getAbsolutePath());
            LastUsedFolders.setPrivateKey(file);
        }
    }

    private void knownHostsFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseFileAction(this, LastUsedFolders.getKnownHosts(), NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectKnownHostsFile"));
        if (file != null) {
            this.setKnownHostsFile(file.getAbsolutePath());
            LastUsedFolders.setKnownHosts(file);
        }
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String string) {
        this.hostTextField.setText(string);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String string) {
        this.portTextField.setText(string);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String string) {
        this.userTextField.setText(string);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String string) {
        this.passwordTextField.setText(string);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFileTextField.getText();
    }

    public void setKnownHostsFile(String string) {
        this.knownHostsFileTextField.setText(string);
    }

    public String getIdentityFile() {
        return this.identityFileTextField.getText();
    }

    public void setIdentityFile(String string) {
        this.identityFileTextField.setText(string);
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String string) {
        this.initialDirectoryTextField.setText(string);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String string) {
        this.timeoutTextField.setText(string);
    }

    public void read(ConfigManager.Configuration configuration) {
        this.setHostName(configuration.getValue("host"));
        this.setPort(configuration.getValue("port"));
        this.setUserName(configuration.getValue("user"));
        this.setPassword(configuration.getValue("password", true));
        this.setKnownHostsFile(configuration.getValue("knownHostsFile"));
        this.setIdentityFile(configuration.getValue("identityFile"));
        this.setInitialDirectory(configuration.getValue("initialDirectory"));
        this.setTimeout(configuration.getValue("timeout"));
    }

    public void store(ConfigManager.Configuration configuration) {
        configuration.putValue("host", this.getHostName());
        configuration.putValue("port", this.getPort());
        configuration.putValue("user", this.getUserName());
        configuration.putValue("password", this.getPassword(), true);
        configuration.putValue("knownHostsFile", this.getKnownHostsFile());
        configuration.putValue("identityFile", this.getIdentityFile());
        configuration.putValue("initialDirectory", RunAsValidator.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        configuration.putValue("timeout", this.getTimeout());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            SftpConfigurationPanel.this.fireChange();
        }
    }
}

