/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;

public final class FtpConfiguration
extends RemoteConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String host;
    private final int port;
    private final String userName;
    private final String password;
    private final boolean anonymousLogin;
    private final String initialDirectory;
    private final int timeout;
    private final boolean passiveMode;

    public FtpConfiguration(ConfigManager.Configuration configuration) {
        super(configuration);
        this.host = configuration.getValue("host");
        this.port = Integer.parseInt(configuration.getValue("port"));
        this.userName = configuration.getValue("user");
        this.password = configuration.getValue("password", true);
        this.anonymousLogin = Boolean.valueOf(configuration.getValue("anonymousLogin"));
        this.initialDirectory = configuration.getValue("initialDirectory");
        this.timeout = Integer.parseInt(configuration.getValue("timeout"));
        this.passiveMode = Boolean.valueOf(configuration.getValue("passiveMode"));
    }

    public boolean isAnonymousLogin() {
        return this.anonymousLogin;
    }

    public String getHost() {
        return this.host;
    }

    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public String getUserName() {
        if (this.anonymousLogin) {
            return "anonymous";
        }
        return this.userName;
    }

    public String getPassword() {
        if (this.anonymousLogin) {
            return "nobody@nowhere.net";
        }
        return this.password != null ? this.password : "";
    }

    public String getUrl(String string) {
        assert (string != null);
        String string2 = this.initialDirectory;
        if (string.trim().length() > 0) {
            string2 = string2 + string;
        }
        return "ftp://" + this.host + string2.replaceAll("/{2,}", PATH_SEPARATOR);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        FtpConfiguration ftpConfiguration = (FtpConfiguration)object;
        if (!(this.host == ftpConfiguration.host || this.host != null && this.host.equals(ftpConfiguration.host))) {
            return false;
        }
        if (this.port != ftpConfiguration.port) {
            return false;
        }
        if (!(this.userName == ftpConfiguration.userName || this.userName != null && this.userName.equals(ftpConfiguration.userName))) {
            return false;
        }
        return this.password == ftpConfiguration.password || this.password != null && this.password.equals(ftpConfiguration.password);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 97 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 97 * n + this.port;
        n = 97 * n + (this.userName != null ? this.userName.hashCode() : 0);
        n = 97 * n + (this.password != null ? this.password.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [displayName: ");
        stringBuilder.append(this.getDisplayName());
        stringBuilder.append(", name: ");
        stringBuilder.append(this.getName());
        stringBuilder.append(", host: ");
        stringBuilder.append(this.host);
        stringBuilder.append(", port: ");
        stringBuilder.append(this.port);
        stringBuilder.append(", userName: ");
        stringBuilder.append(this.getUserName());
        stringBuilder.append(", password: *****");
        stringBuilder.append(", anonymousLogin: ");
        stringBuilder.append(this.anonymousLogin);
        stringBuilder.append(", initialDirectory: ");
        stringBuilder.append(this.initialDirectory);
        stringBuilder.append(", timeout: ");
        stringBuilder.append(this.timeout);
        stringBuilder.append(", passiveMode: ");
        stringBuilder.append(this.passiveMode);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

