/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpConfigurationProvider
implements ProjectConfigurationProvider<Config> {
    private static final Logger LOGGER = Logger.getLogger(PhpConfigurationProvider.class.getName());
    public static final String PROP_CONFIG = "config";
    public static final String CONFIG_PROPS_PATH = "nbproject/private/config.properties";
    private static final Config DEFAULT = new Config(null, NbBundle.getMessage(PhpConfigurationProvider.class, (String)"LBL_DefaultConfiguration"));
    private final PhpProject project;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            this.update(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.update(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.update(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.update((FileEvent)fileRenameEvent);
        }

        private void update(FileEvent fileEvent) {
            LOGGER.log(Level.FINEST, "Received {0}", fileEvent);
            Set set = PhpConfigurationProvider.this.configs != null ? PhpConfigurationProvider.this.configs.keySet() : Collections.emptySet();
            PhpConfigurationProvider.this.configDir = PhpConfigurationProvider.this.project.getProjectDirectory().getFileObject("nbproject/configs");
            if (PhpConfigurationProvider.this.configDir != null) {
                PhpConfigurationProvider.this.configDir.removeFileChangeListener(PhpConfigurationProvider.this.fclWeak);
                PhpConfigurationProvider.this.configDir.addFileChangeListener(PhpConfigurationProvider.this.fclWeak);
                LOGGER.log(Level.FINEST, "(Re-)added listener to {0}", PhpConfigurationProvider.this.configDir);
            } else {
                LOGGER.log(Level.FINEST, "No nbproject/configs exists");
            }
            PhpConfigurationProvider.this.calculateConfigs();
            Set set2 = PhpConfigurationProvider.this.configs.keySet();
            if (!((Object)set).equals(set2)) {
                LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{set, set2});
                PhpConfigurationProvider.this.pcs.firePropertyChange("configurations", null, null);
            }
        }
    };
    private final FileChangeListener fclWeak;
    private FileObject configDir;
    private Map<String, Config> configs;
    private FileObject nbp;

    public PhpConfigurationProvider(PhpProject phpProject) {
        this.project = phpProject;
        this.fclWeak = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, null);
        this.nbp = phpProject.getProjectDirectory().getFileObject("nbproject");
        if (this.nbp != null) {
            this.nbp.addFileChangeListener(this.fclWeak);
            LOGGER.log(Level.FINEST, "Added listener to {0}", this.nbp);
            this.configDir = this.nbp.getFileObject("configs");
            if (this.configDir != null) {
                this.configDir.addFileChangeListener(this.fclWeak);
                LOGGER.log(Level.FINEST, "Added listener to {0}", this.configDir);
            }
        }
        phpProject.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PhpConfigurationProvider.PROP_CONFIG.equals(propertyChangeEvent.getPropertyName())) {
                    LOGGER.log(Level.FINER, "Refiring config -> activeConfiguration");
                    PhpConfigurationProvider.this.pcs.firePropertyChange("activeConfiguration", null, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateConfigs() {
        this.configs = new HashMap<String, Config>();
        if (this.configDir != null) {
            for (FileObject fileObject : this.configDir.getChildren()) {
                if (!fileObject.hasExt("properties")) continue;
                try {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String string = fileObject.getName();
                        String string2 = properties.getProperty("$label");
                        this.configs.put(string, new Config(string, string2 != null ? string2 : string));
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
            }
        }
        LOGGER.log(Level.FINEST, "Calculated configurations: {0}", this.configs);
    }

    public Collection<Config> getConfigurations() {
        this.calculateConfigs();
        ArrayList<Config> arrayList = new ArrayList<Config>();
        arrayList.addAll(this.configs.values());
        Collections.sort(arrayList, new Comparator<Config>(){
            Collator c = Collator.getInstance();

            @Override
            public int compare(Config config, Config config2) {
                return this.c.compare(config.getDisplayName(), config2.getDisplayName());
            }
        });
        arrayList.add(0, DEFAULT);
        return arrayList;
    }

    public Config getActiveConfiguration() {
        this.calculateConfigs();
        String string = this.project.getEvaluator().getProperty(PROP_CONFIG);
        if (string != null && this.configs.containsKey(string)) {
            return this.configs.get(string);
        }
        return DEFAULT;
    }

    public void setActiveConfiguration(Config config) throws IOException {
        if (config != DEFAULT && !this.configs.values().contains(config)) {
            throw new IllegalArgumentException();
        }
        String string = config.name;
        EditableProperties editableProperties = this.project.getHelper().getProperties(CONFIG_PROPS_PATH);
        if (Utilities.compareObjects((Object)string, (Object)editableProperties.getProperty(PROP_CONFIG))) {
            return;
        }
        if (string != null) {
            editableProperties.setProperty(PROP_CONFIG, string);
        } else {
            editableProperties.remove((Object)PROP_CONFIG);
        }
        this.project.getHelper().putProperties(CONFIG_PROPS_PATH, editableProperties);
        this.pcs.firePropertyChange("activeConfiguration", null, null);
        ProjectManager.getDefault().saveProject((Project)this.project);
        assert (this.project.getProjectDirectory().getFileObject(CONFIG_PROPS_PATH) != null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
    }

    public boolean configurationsAffectAction(String string) {
        return string.equals("run") || string.equals("debug");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static final class Config
    implements ProjectConfiguration {
        public final String name;
        private final String displayName;

        public Config(String string, String string2) {
            this.name = string;
            this.displayName = string2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public boolean equals(Object object) {
            return object instanceof Config && Utilities.compareObjects((Object)this.name, (Object)((Config)object).name);
        }

        public String toString() {
            return "PhpConfigurationProvider.Config[" + this.name + "," + this.displayName + "]";
        }
    }
}

