/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.ui;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.archive.ui.RootNode;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ConfigFilesNode
extends FilterNode {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();

    public ConfigFilesNode(DataFolder dataFolder) {
        super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER));
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    private Image computeIcon(boolean bl, int n) {
        Node node = this.getOriginal();
        Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
        return image;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(FindAction.class)};
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RootNode.class, (String)"LBL_Node_DocBase");
    }

    protected static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            boolean bl = false;
            FileObject fileObject = dataObject.getPrimaryFile();
            if (!"classes".equals(fileObject.getName()) && !"lib".equals(fileObject.getName())) {
                bl = VisibilityQuery.getDefault().isVisible(fileObject);
            }
            return bl;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }
}

