/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProvidesAction
implements ActionProvider {
    private static final String COMMAND_VERIFY = "verify";
    private Project project;
    static Map commands = new HashMap();

    ProvidesAction(Project project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        return new String[]{"build", "run", COMMAND_VERIFY, "delete", "copy", "move", "rename"};
    }

    public void invokeAction(final String string, final Lookup lookup) {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                String[] stringArray = ProvidesAction.this.getTargetNames(string, lookup);
                if (stringArray == null) {
                    return;
                }
                if (stringArray.length == 0) {
                    stringArray = null;
                }
                try {
                    FileObject fileObject = ProvidesAction.this.findBuildXml();
                    if (fileObject == null || !fileObject.isValid()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProvidesAction.class, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/project/Bundle").getString("LBL_No_Build_XML_Found")), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    } else {
                        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, null);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        };
        runnable.run();
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        return this.findBuildXml() != null;
    }

    String[] getTargetNames(String string, Lookup lookup) throws IllegalArgumentException {
        String[] stringArray = (String[])commands.get(string);
        return stringArray;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    static {
        commands.put("build", new String[]{"dist"});
        commands.put("run", new String[]{"run-deploy"});
        commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
    }
}

