/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyEmbeddingProvider
extends EmbeddingProvider {
    public static final String RUBY_MIMETYPE = "text/x-ruby";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        List<Embedding> list = this.extractRuby(snapshot);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(list));
    }

    public int getPriority() {
        return 10;
    }

    public void cancel() {
    }

    private List<Embedding> extractRuby(Snapshot snapshot) {
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>(40);
        arrayList.add(snapshot.create((CharSequence)"class ActionView::Base\n", RUBY_MIMETYPE));
        arrayList.add(snapshot.create((CharSequence)"_buf='';", RUBY_MIMETYPE));
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)snapshot.getText(), RhtmlTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        boolean bl = false;
        while (tokenSequence.moveNext()) {
            int n;
            int n2;
            String string;
            int n3;
            int n4;
            Token token = tokenSequence.token();
            if (token.id() == RhtmlTokenId.HTML) {
                n4 = token.offset(tokenHierarchy);
                n3 = n4 + token.length();
                string = ((Object)token.text()).toString();
                boolean bl2 = false;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 10) {
                        ++n2;
                        bl2 = true;
                        break;
                    }
                    if (!Character.isWhitespace((char)n)) break;
                }
                if (bl2) {
                    arrayList.add(snapshot.create((CharSequence)string.substring(0, n2), RUBY_MIMETYPE));
                    string = string.substring(n2);
                } else {
                    arrayList.add(snapshot.create((CharSequence)";", RUBY_MIMETYPE));
                }
                arrayList.add(snapshot.create((CharSequence)"_buf << '", RUBY_MIMETYPE));
                if (bl && string.startsWith("\n")) {
                    string = string.substring(1);
                    --n3;
                }
                string = string.replace("'", "\\'");
                arrayList.add(snapshot.create((CharSequence)string, RUBY_MIMETYPE));
                arrayList.add(snapshot.create((CharSequence)"';\n", RUBY_MIMETYPE));
                bl = false;
                continue;
            }
            if (token.id() == RhtmlTokenId.RUBY) {
                n4 = token.offset(tokenHierarchy);
                n3 = n4 + token.length();
                string = ((Object)token.text()).toString();
                bl = false;
                if (string.endsWith("-")) {
                    bl = true;
                }
                arrayList.add(snapshot.create(n4, n3 - n4 - (bl ? 1 : 0), RUBY_MIMETYPE));
                if (tokenSequence.moveNext()) {
                    Token token2 = tokenSequence.token();
                    if (token2 != null && token2.id() == RhtmlTokenId.DELIMITER && (n2 = tokenSequence.offset() + token2.length()) <= snapshot.getText().length()) {
                        char c;
                        for (n = n2; n < snapshot.getText().length() && (c = snapshot.getText().charAt(n)) != '\n'; ++n) {
                            if (Character.isWhitespace(c)) continue;
                            arrayList.add(snapshot.create((CharSequence)";", RUBY_MIMETYPE));
                            break;
                        }
                    }
                    tokenSequence.movePrevious();
                }
                bl = false;
                continue;
            }
            if (token.id() != RhtmlTokenId.RUBY_EXPR) continue;
            arrayList.add(snapshot.create((CharSequence)"_buf << (", RUBY_MIMETYPE));
            n4 = token.offset(tokenHierarchy);
            n3 = n4 + token.length();
            string = ((Object)token.text()).toString();
            bl = false;
            if (string.endsWith("-")) {
                bl = true;
            }
            arrayList.add(snapshot.create(n4, n3 - n4 - (bl ? 1 : 0), RUBY_MIMETYPE));
            arrayList.add(snapshot.create((CharSequence)").to_s;", RUBY_MIMETYPE));
        }
        arrayList.add(snapshot.create((CharSequence)"\nend\n", RUBY_MIMETYPE));
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (snapshot.getSource().getMimeType().equals("application/x-httpd-eruby")) {
                return Collections.singleton(new RubyEmbeddingProvider());
            }
            return Collections.emptyList();
        }
    }
}

