/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ToolbarRow
extends JPanel {
    private final Map<String, ToolbarConstraints> name2constraint = new HashMap<String, ToolbarConstraints>(20);
    private final List<ToolbarConstraints> constraints = new ArrayList<ToolbarConstraints>(20);
    private static final String FAKE_NAME = "__fake_drag_container__";
    private ToolbarConstraints dragConstraints;
    private Component dragContainer;
    private Point dragOriginalLocation;
    private JLabel dropReplacement;
    private ToolbarConstraints dropConstraints;
    private ToolbarContainer dropContainter;
    private static final boolean isMetalLaF = "Metal".equals(UIManager.getLookAndFeel().getID());
    private static final boolean isNimbusLaF = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    private static final boolean isGTKLaF = "GTK".equals(UIManager.getLookAndFeel().getID());
    private static final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID());

    public ToolbarRow() {
        this.setLayout(new ToolbarLayout());
        this.setOpaque(false);
        this.addDropConstraints();
    }

    public void addConstraint(ToolbarConstraints toolbarConstraints) {
        ToolbarConstraints toolbarConstraints2 = this.name2constraint.get(toolbarConstraints.getName());
        if (null != toolbarConstraints2) {
            this.constraints.remove(toolbarConstraints2);
            Logger.getLogger(ToolbarRow.class.getName()).log(Level.FINE, "Duplicate toolbar defintion " + toolbarConstraints.getName());
        }
        List<ToolbarConstraints> list = this.getConstraints(ToolbarConstraints.Align.left);
        List<ToolbarConstraints> list2 = this.getConstraints(ToolbarConstraints.Align.right);
        this.constraints.clear();
        this.constraints.addAll(list);
        if (toolbarConstraints.getAlign() == ToolbarConstraints.Align.left) {
            this.constraints.add(toolbarConstraints);
        }
        this.constraints.addAll(list2);
        if (toolbarConstraints.getAlign() == ToolbarConstraints.Align.right) {
            this.constraints.add(toolbarConstraints);
        }
        this.name2constraint.put(toolbarConstraints.getName(), toolbarConstraints);
    }

    boolean removeConstraint(ToolbarConstraints toolbarConstraints) {
        if (null != this.name2constraint.get(toolbarConstraints.getName())) {
            this.name2constraint.remove(toolbarConstraints.getName());
            this.constraints.remove(toolbarConstraints);
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (null != this.dropReplacement) {
            this.add(this.dropReplacement);
        }
    }

    @Override
    public boolean isVisible() {
        for (ToolbarConstraints toolbarConstraints : this.constraints) {
            if (!toolbarConstraints.isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.name2constraint.isEmpty() || null != this.dragContainer && this.name2constraint.size() == 1;
    }

    private void addDropConstraints() {
        this.dropConstraints = new ToolbarConstraints(FAKE_NAME, ToolbarConstraints.Align.left, false, true);
        this.dropReplacement = new JLabel();
        this.dropReplacement.setName(this.dropConstraints.getName());
        this.add(this.dropReplacement);
        this.constraints.add(this.dropConstraints);
    }

    void dragStarted(ToolbarContainer toolbarContainer) {
        this.dragConstraints = this.findConstraints(toolbarContainer.getName());
        if (null != this.dragConstraints) {
            this.dragContainer = this.findComponent(this.dragConstraints.getName());
            this.dragConstraints.setVisible(false);
            this.dragOriginalLocation = new Point(this.dragContainer.getLocationOnScreen());
            toolbarContainer.setVisible(false);
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    void showDropFeedback(ToolbarContainer toolbarContainer, Point point, Image image) {
        int n;
        Component component = null;
        Rectangle rectangle = null;
        for (Component component2 : this.getComponents()) {
            if (!component2.isVisible()) continue;
            rectangle = component2.getBounds();
            rectangle.setLocation(component2.getLocationOnScreen());
            if (!rectangle.contains(point)) continue;
            component = component2;
            break;
        }
        this.dropReplacement.setPreferredSize(toolbarContainer.getPreferredSize());
        this.dropReplacement.setMinimumSize(toolbarContainer.getMinimumSize());
        if (this.dropContainter != toolbarContainer) {
            this.dropContainter = toolbarContainer;
            this.dropReplacement.setIcon(new ImageIcon(image));
        }
        if (null != component) {
            if (component == this.dropReplacement) {
                return;
            }
            boolean bl = rectangle.x + rectangle.width / 2 < point.x;
            ToolbarConstraints toolbarConstraints = this.findConstraints(component.getName());
            this.dropConstraints.setAlign(toolbarConstraints.getAlign());
            n = this.constraints.indexOf(toolbarConstraints);
            if (bl) {
                ++n;
            }
            if (n > this.constraints.indexOf(this.dropConstraints)) {
                --n;
            }
            if (this.isLastVisibleToolbar(toolbarConstraints) && this.isStretchLastToolbar() && rectangle.x + rectangle.width - rectangle.width / 4 < point.x) {
                this.dropConstraints.setAlign(ToolbarConstraints.Align.right);
                n = this.constraints.size() + 1;
            }
            this.constraints.remove(this.dropConstraints);
            if (n <= this.constraints.size()) {
                this.constraints.add(n, this.dropConstraints);
            } else {
                this.constraints.add(this.dropConstraints);
            }
            this.dropConstraints.setVisible(true);
            this.dropReplacement.setVisible(true);
        } else {
            Rectangle rectangle2 = this.getFreeAreaBounds();
            if (rectangle2.contains(point)) {
                int n2 = rectangle2.x + rectangle2.width / 2 >= point.x ? 1 : 0;
                this.constraints.remove(this.dropConstraints);
                n = -1;
                if (n2 != 0) {
                    this.dropConstraints.setAlign(ToolbarConstraints.Align.left);
                    for (int i = 0; i < this.constraints.size(); ++i) {
                        ToolbarConstraints toolbarConstraints = this.constraints.get(i);
                        if (!toolbarConstraints.isVisible() || toolbarConstraints.getAlign() == ToolbarConstraints.Align.left) continue;
                        n = i;
                        break;
                    }
                } else {
                    this.dropConstraints.setAlign(ToolbarConstraints.Align.right);
                    for (int i = this.constraints.size() - 1; i >= 0; --i) {
                        ToolbarConstraints toolbarConstraints = this.constraints.get(i);
                        if (!toolbarConstraints.isVisible() || toolbarConstraints.getAlign() == ToolbarConstraints.Align.right) continue;
                        n = i;
                        break;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                }
                if (n >= 0) {
                    this.constraints.add(n, this.dropConstraints);
                } else {
                    this.constraints.add(this.dropConstraints);
                }
                this.dropConstraints.setVisible(true);
                this.dropReplacement.setVisible(true);
            } else {
                this.dropConstraints.setVisible(false);
                this.dropReplacement.setVisible(false);
            }
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    void hideDropFeedback() {
        this.dropConstraints.setVisible(false);
        this.dropReplacement.setVisible(false);
        this.dropContainter = null;
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    Point drop() {
        Point point = null;
        if (null == this.dropContainter) {
            return point;
        }
        if (this.dropReplacement.isShowing()) {
            point = this.dropReplacement.getLocationOnScreen();
        }
        if (null != this.dragConstraints) {
            this.add(this.dragContainer);
            this.constraints.remove(this.dragConstraints);
            this.dragConstraints.setVisible(true);
            this.dragConstraints.setAlign(this.dropConstraints.getAlign());
            this.constraints.add(this.constraints.indexOf(this.dropConstraints), this.dragConstraints);
        } else {
            ToolbarConstraints toolbarConstraints = new ToolbarConstraints(this.dropContainter.getName(), this.dropConstraints.getAlign(), true, true);
            this.add(this.dropContainter);
            this.constraints.add(this.constraints.indexOf(this.dropConstraints), toolbarConstraints);
            this.name2constraint.put(toolbarConstraints.getName(), toolbarConstraints);
        }
        this.dropConstraints.setVisible(false);
        this.dropReplacement.setVisible(false);
        this.invalidate();
        this.revalidate();
        this.repaint();
        this.dropContainter = null;
        this.dragConstraints = null;
        this.dragContainer = null;
        return point;
    }

    void dragSuccess() {
        if (null != this.dragConstraints) {
            Component component = this.findComponent(this.dragConstraints.getName());
            if (null != component) {
                this.remove(component);
            }
            this.constraints.remove(this.dragConstraints);
            this.name2constraint.remove(this.dragConstraints.getName());
            this.dragConstraints = null;
            this.dragContainer = null;
        }
    }

    Point dragAbort() {
        Point point = null;
        if (null != this.dragConstraints) {
            this.add(this.dragContainer);
            this.dragContainer.setVisible(true);
            this.dragConstraints.setVisible(true);
            this.invalidate();
            this.revalidate();
            this.repaint();
            point = this.dragOriginalLocation;
            this.dragConstraints = null;
            this.dragContainer = null;
        }
        return point;
    }

    Iterable<? extends ToolbarConstraints> getConstraints() {
        ArrayList<ToolbarConstraints> arrayList = new ArrayList<ToolbarConstraints>(this.constraints.size());
        for (ToolbarConstraints toolbarConstraints : this.constraints) {
            if (null == this.name2constraint.get(toolbarConstraints.getName())) continue;
            arrayList.add(toolbarConstraints);
        }
        return arrayList;
    }

    int countVisibleToolbars() {
        int n = 0;
        for (ToolbarConstraints toolbarConstraints : this.name2constraint.values()) {
            if (!toolbarConstraints.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private boolean isLastVisibleToolbar(ToolbarConstraints toolbarConstraints) {
        for (int i = this.constraints.size() - 1; i >= 0; --i) {
            ToolbarConstraints toolbarConstraints2 = this.constraints.get(i);
            if (!toolbarConstraints2.isVisible() || FAKE_NAME.equals(toolbarConstraints2.getName())) continue;
            return toolbarConstraints2 == toolbarConstraints;
        }
        return false;
    }

    private List<Component> getContainers(ToolbarConstraints.Align align) {
        ArrayList<Component> arrayList = new ArrayList<Component>(this.getComponentCount());
        for (ToolbarConstraints toolbarConstraints : this.constraints) {
            Component component;
            if (!toolbarConstraints.isVisible() || toolbarConstraints.getAlign() != align || null == (component = this.findComponent(toolbarConstraints.getName()))) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    private ToolbarConstraints findConstraints(String string) {
        for (ToolbarConstraints toolbarConstraints : this.constraints) {
            if (!toolbarConstraints.getName().equals(string)) continue;
            return toolbarConstraints;
        }
        return null;
    }

    private Component findComponent(String string) {
        for (Component component : this.getComponents()) {
            if (!string.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    private List<ToolbarConstraints> getConstraints(ToolbarConstraints.Align align) {
        ArrayList<ToolbarConstraints> arrayList = new ArrayList<ToolbarConstraints>(this.constraints.size());
        for (ToolbarConstraints toolbarConstraints : this.constraints) {
            if (toolbarConstraints.getAlign() != align) continue;
            arrayList.add(toolbarConstraints);
        }
        return arrayList;
    }

    Rectangle getFreeAreaBounds() {
        Component component;
        Object object;
        int n;
        int n2 = 0;
        int n3 = this.getWidth();
        for (n = this.constraints.size() - 1; n >= 0; --n) {
            object = this.constraints.get(n);
            if (!((ToolbarConstraints)object).isVisible() || object == this.dragConstraints || ((ToolbarConstraints)object).getAlign() != ToolbarConstraints.Align.left || null == (component = this.findComponent(((ToolbarConstraints)object).getName()))) continue;
            n2 = component.getLocation().x + component.getWidth();
            break;
        }
        for (n = 0; n < this.constraints.size(); ++n) {
            object = this.constraints.get(n);
            if (!((ToolbarConstraints)object).isVisible() || object == this.dragConstraints || ((ToolbarConstraints)object).getAlign() != ToolbarConstraints.Align.right || null == (component = this.findComponent(((ToolbarConstraints)object).getName()))) continue;
            n3 = component.getLocation().x;
            break;
        }
        Rectangle rectangle = new Rectangle(n2, 0, n3 - n2, this.getHeight());
        object = rectangle.getLocation();
        if (this.isShowing()) {
            SwingUtilities.convertPointToScreen((Point)object, this);
            rectangle.setLocation((Point)object);
        }
        return rectangle;
    }

    private boolean isStretchLastToolbar() {
        return isMetalLaF || isNimbusLaF || isGTKLaF || isAquaLaF;
    }

    private class ToolbarLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            dimension.height = this.getPreferredHeight();
            for (Component component : ToolbarRow.this.getComponents()) {
                if (!component.isVisible()) continue;
                dimension.width += component.getPreferredSize().width;
            }
            Insets insets = container.getInsets();
            if (null != insets) {
                dimension.height += insets.top;
                dimension.height += insets.bottom;
            }
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            dimension.height = this.getMinimumHeight();
            for (Component component : ToolbarRow.this.getComponents()) {
                if (!component.isVisible()) continue;
                dimension.width += component.getMinimumSize().width;
            }
            Insets insets = container.getInsets();
            if (null != insets) {
                dimension.height += insets.top;
                dimension.height += insets.bottom;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3 = container.getWidth();
            int n4 = container.getHeight();
            int n5 = 0;
            Insets insets = container.getInsets();
            if (null != insets) {
                n4 -= insets.top + insets.bottom;
                n5 = insets.top;
            }
            Dimension dimension = this.preferredLayoutSize(container);
            List list = ToolbarRow.this.getContainers(ToolbarConstraints.Align.left);
            List list2 = ToolbarRow.this.getContainers(ToolbarConstraints.Align.right);
            HashMap<Serializable, Integer> hashMap = new HashMap<Serializable, Integer>(list.size() + list2.size());
            if (dimension.width > n3) {
                int n6;
                int n7;
                Component component;
                n2 = dimension.width - n3;
                Object object = new ArrayList(list2);
                Collections.reverse(object);
                Object object2 = object.iterator();
                while (object2.hasNext()) {
                    component = (Component)object2.next();
                    n = component.getPreferredSize().width;
                    n7 = component.getMinimumSize().width;
                    n6 = n - n7;
                    if (n2 <= n6) {
                        hashMap.put(component, n - n2);
                        n2 = 0;
                        continue;
                    }
                    hashMap.put(component, n7);
                    n2 -= n6;
                }
                object = new ArrayList(list);
                Collections.reverse(object);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    component = (Component)object2.next();
                    n = component.getPreferredSize().width;
                    n7 = component.getMinimumSize().width;
                    n6 = n - n7;
                    if (n2 <= n6) {
                        hashMap.put(component, n - n2);
                        n2 = 0;
                        continue;
                    }
                    hashMap.put(component, n7);
                    n2 -= n6;
                }
            } else {
                for (Object object : list) {
                    hashMap.put((Serializable)object, ((Component)object).getPreferredSize().width);
                }
                for (Object object : list2) {
                    hashMap.put((Serializable)object, ((Component)object).getPreferredSize().width);
                }
            }
            n2 = 0;
            for (Object object2 : list) {
                int n8 = (Integer)hashMap.get(object2);
                if (ToolbarRow.this.isStretchLastToolbar() && list.indexOf(object2) == list.size() - 1) {
                    n = 0;
                    for (Component component : list2) {
                        n += ((Integer)hashMap.get(component)).intValue();
                    }
                    n8 = n3 - n2 - n;
                }
                ((Component)object2).setBounds(n2, n5, n8, n4);
                n2 += n8;
            }
            n2 = n3;
            Collections.reverse(list2);
            for (Object object2 : list2) {
                int n9 = (Integer)hashMap.get(object2);
                ((Component)object2).setBounds(n2 -= n9, n5, n9, n4);
            }
        }

        private int getPreferredHeight() {
            int n = 0;
            for (Component component : ToolbarRow.this.getComponents()) {
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.height <= n) continue;
                n = dimension.height;
            }
            return n;
        }

        private int getMinimumHeight() {
            int n = 0;
            for (Component component : ToolbarRow.this.getComponents()) {
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                if (dimension.height <= n) continue;
                n = dimension.height;
            }
            return n;
        }
    }
}

