/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.examples;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.java.examples.FoldersListSettings;
import org.netbeans.modules.java.examples.PanelConfigureProject;
import org.netbeans.modules.java.examples.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    private PanelConfigureProject panel;
    private JButton Button;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.Button = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        this.projectNameLabel.setText(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        this.projectLocationLabel.setText(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        this.Button.setText(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.Button.setActionCommand("BROWSE");
        this.Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.Button, gridBagConstraints);
        this.Button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_LablelMnemonic").charAt(0));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(file.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectLocationTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File file = new File(this.createdFolderTextField.getText());
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(this.createdFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("name", (Object)string);
        File file = new File(this.projectLocationTextField.getText());
        if (file.isDirectory()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = null;
        String string2 = (String)wizardDescriptor.getProperty("name");
        string = string2 == null ? NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"LBL_NPW1_DefaultProjectName") : string2 + "{0}";
        if (string2 == null || this.validFreeProjectName(file, string2) == null) {
            int n = FoldersListSettings.getDefault().getNewProjectCount() + 1;
            while ((string2 = this.validFreeProjectName(file, string, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText(string2);
        this.projectNameTextField.selectAll();
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        return jFileChooser;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    private String validFreeProjectName(File file, String string) {
        File file2 = new File(file, string);
        return file2.exists() ? null : string;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    private void updateTexts(DocumentEvent documentEvent) {
        this.createdFolderTextField.setText(this.getCreatedFolderPath());
        this.panel.fireChangeEvent();
    }

    private String getCreatedFolderPath() {
        StringBuffer stringBuffer = new StringBuffer(this.projectLocationTextField.getText().trim());
        if (!this.projectLocationTextField.getText().endsWith(File.separator)) {
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.projectNameTextField.getText().trim());
        return stringBuffer.toString();
    }
}

