/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.SymTabCache;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileReferencesContext {
    private CsmFile csmFile;
    private int lastOffset;
    private boolean isClened = false;
    private Map<String, List<CsmUID<CsmVariable>>> fileLocalVars;
    private Map<String, Collection<CsmEnumerator>> libEnumerators;
    private List<Offsets> fileObjectOffsets;
    private List<Offsets> fileDeclarationsOffsets;
    private Map<CharSequence, CsmUID<CsmMacro>> projectMacros;
    private SymTabCache symTabCache = new SymTabCache();

    FileReferencesContext(CsmScope csmScope) {
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            this.csmFile = (CsmFile)csmScope;
        } else if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
            this.csmFile = ((CsmFunction)csmScope).getContainingFile();
        } else if (CsmKindUtilities.isOffsetable((Object)csmScope)) {
            this.csmFile = ((CsmOffsetable)csmScope).getContainingFile();
        }
        this.lastOffset = 0;
    }

    public void clean() {
        this.isClened = true;
        this._clean();
    }

    private void _clean() {
        if (this.fileLocalVars != null) {
            this.fileLocalVars = null;
            this.fileDeclarationsOffsets = null;
            this.fileObjectOffsets = null;
            this.projectMacros = null;
            this.libEnumerators = null;
        }
        this.symTabCache.clear();
    }

    public boolean isCleaned() {
        return this.isClened;
    }

    public void advance(int n) {
        if (this.csmFile == null) {
            return;
        }
        this.lastOffset = n;
    }

    public SymTabCache getSymTabCache() {
        return this.symTabCache;
    }

    public Collection<CsmEnumerator> getLibEnumerators(String string) {
        if (this.isCleaned()) {
            return null;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        return this.libEnumerators.get(string);
    }

    public void putLibEnumerators(String string, Collection<CsmEnumerator> collection) {
        if (this.isCleaned()) {
            return;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        this.libEnumerators.put(string, collection);
    }

    public List<CsmVariable> getFileLocalIncludeVariables(String string) {
        List<CsmUID<CsmVariable>> list;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileLocalVars == null) {
            this.fillFileLocalIncludeVariables();
        }
        if ((list = this.fileLocalVars.get(string)) == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CsmVariable> arrayList = new ArrayList<CsmVariable>(list.size());
        for (CsmUID<CsmVariable> csmUID : list) {
            CsmVariable csmVariable = (CsmVariable)csmUID.getObject();
            if (csmVariable == null) continue;
            arrayList.add(csmVariable);
        }
        return arrayList;
    }

    public CsmObject findInnerFileDeclaration(int n) {
        Offsets offsets;
        int n2;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileDeclarationsOffsets == null) {
            this.fileDeclarationsOffsets = new ArrayList<Offsets>();
            this.fileObjectOffsets = new ArrayList<Offsets>();
            this.fillFileOffsets();
        }
        if ((n2 = Collections.binarySearch(this.fileDeclarationsOffsets, offsets = new Offsets(n))) >= 0) {
            Offsets offsets2;
            if (n2 < this.fileDeclarationsOffsets.size() - 1 && (offsets2 = this.fileDeclarationsOffsets.get(n2 + 1)).compareTo(offsets) == 0) {
                return offsets2.object;
            }
            return this.fileDeclarationsOffsets.get(n2).object;
        }
        return null;
    }

    public CsmObject findInnerFileObject(int n) {
        Offsets offsets;
        int n2;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileDeclarationsOffsets == null) {
            this.fileDeclarationsOffsets = new ArrayList<Offsets>();
            this.fileObjectOffsets = new ArrayList<Offsets>();
            this.fillFileOffsets();
        }
        if ((n2 = Collections.binarySearch(this.fileObjectOffsets, offsets = new Offsets(n))) >= 0) {
            Offsets offsets2;
            if (n2 < this.fileObjectOffsets.size() - 1 && (offsets2 = this.fileObjectOffsets.get(n2 + 1)).compareTo(offsets) == 0) {
                return offsets2.object;
            }
            return this.fileObjectOffsets.get(n2).object;
        }
        return null;
    }

    public CsmMacro findIncludedMacro(String string) {
        CsmUID<CsmMacro> csmUID;
        if (this.isCleaned()) {
            return null;
        }
        if (this.projectMacros == null) {
            this.projectMacros = new HashMap<CharSequence, CsmUID<CsmMacro>>();
            this.fillProjectMacros();
        }
        if ((csmUID = this.projectMacros.get(CharSequenceKey.create((CharSequence)string))) != null) {
            return (CsmMacro)csmUID.getObject();
        }
        return null;
    }

    private synchronized void fillFileLocalIncludeVariables() {
        if (this.fileLocalVars != null) {
            return;
        }
        this.fileLocalVars = new HashMap<String, List<CsmUID<CsmVariable>>>();
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, null, true, true, false);
        ArrayList<CsmVariable> arrayList = new ArrayList<CsmVariable>(10);
        CsmProjectContentResolver.fillFileLocalVariablesByFilter(csmFilter, this.csmFile, arrayList);
        for (CsmVariable csmVariable : arrayList) {
            String string = ((Object)csmVariable.getName()).toString();
            List<CsmUID<CsmVariable>> list = this.fileLocalVars.get(string);
            if (list == null) {
                list = new ArrayList<CsmUID<CsmVariable>>();
                this.fileLocalVars.put(string, list);
            }
            list.add((CsmUID<CsmVariable>)UIDs.get((Object)csmVariable));
        }
    }

    private void fillFileOffsets() {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : this.csmFile.getDeclarations()) {
            this.fileDeclarationsOffsets.add(new Offsets(csmOffsetableDeclaration));
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : this.csmFile.getIncludes()) {
            this.fileObjectOffsets.add(new Offsets((CsmInclude)csmOffsetableDeclaration));
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : this.csmFile.getMacros()) {
            this.fileObjectOffsets.add(new Offsets((CsmMacro)csmOffsetableDeclaration));
        }
        Collections.sort(this.fileObjectOffsets);
    }

    private void fillProjectMacros() {
        this.gatherIncludeMacros(this.csmFile, new HashSet<CsmFile>());
    }

    private void gatherIncludeMacros(CsmFile csmFile, Set<CsmFile> set) {
        if (set.contains(csmFile)) {
            return;
        }
        set.add(csmFile);
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            this.getFileLocalMacros(csmFile2);
            this.gatherIncludeMacros(csmFile2, set);
        }
    }

    private void getFileLocalMacros(CsmFile csmFile) {
        for (CsmMacro csmMacro : csmFile.getMacros()) {
            CharSequence charSequence = csmMacro.getName();
            CsmUID<CsmMacro> csmUID = this.projectMacros.get(charSequence);
            if (csmUID != null) continue;
            this.projectMacros.put(charSequence, (CsmUID<CsmMacro>)UIDs.get((Object)csmMacro));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Offsets
    implements Comparable<Offsets> {
        private int startOffset;
        private int endOffset;
        private CsmObject object;

        Offsets(CsmOffsetableDeclaration csmOffsetableDeclaration) {
            this.startOffset = csmOffsetableDeclaration.getStartOffset();
            this.endOffset = csmOffsetableDeclaration.getEndOffset();
            this.object = csmOffsetableDeclaration;
        }

        Offsets(CsmMacro csmMacro) {
            this.startOffset = csmMacro.getStartOffset();
            this.endOffset = csmMacro.getEndOffset();
            this.object = csmMacro;
        }

        Offsets(CsmInclude csmInclude) {
            this.startOffset = csmInclude.getStartOffset();
            this.endOffset = csmInclude.getEndOffset();
            this.object = csmInclude;
        }

        Offsets(int n) {
            this.startOffset = n;
            this.endOffset = n;
        }

        @Override
        public int compareTo(Offsets offsets) {
            if (this.object != null && offsets.object == null ? this.startOffset <= offsets.startOffset && offsets.startOffset < this.endOffset : this.object == null && offsets.object != null && offsets.startOffset <= this.startOffset && this.startOffset < offsets.endOffset) {
                return 0;
            }
            return this.startOffset - offsets.startOffset;
        }
    }
}

