/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.debugger;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.AutosProvider;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmAutosProviderImpl
implements AutosProvider {
    public static final boolean AUTOS_INCLUDE_MACROS = Boolean.getBoolean("debugger.autos.macros");

    public Set<String> getAutos(StyledDocument styledDocument, int n) {
        if (n < 0 || styledDocument == null) {
            return Collections.emptySet();
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)styledDocument, (boolean)false);
        if (csmFile == null || !csmFile.isParsed()) {
            return Collections.emptySet();
        }
        Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = CsmAutosProviderImpl.addAutos(csmFile, element, n, styledDocument, hashSet);
        if (n > 0) {
            CsmAutosProviderImpl.addAutos(csmFile, element, n - 1, styledDocument, hashSet);
        }
        return hashSet;
    }

    private static int addAutos(CsmFile csmFile, Element element, int n, final StyledDocument styledDocument, final Set<String> set) {
        int n2;
        CsmOffsetable csmOffsetable;
        Element element2 = element.getElement(n);
        if (element2 == null) {
            return -1;
        }
        int n3 = element2.getStartOffset();
        CsmOffsetable csmOffsetable2 = CsmAutosProviderImpl.getStatement(csmFile, n3);
        if (csmOffsetable2 != null) {
            n3 = csmOffsetable2.getStartOffset();
        }
        if ((csmOffsetable = CsmAutosProviderImpl.getStatement(csmFile, n2 = element2.getEndOffset())) != null) {
            n2 = csmOffsetable.getEndOffset();
        }
        final int n4 = n3;
        final int n5 = n2;
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext csmReferenceContext) {
                CsmReference csmReference = csmReferenceContext.getReference();
                if (n4 <= csmReference.getStartOffset() && csmReference.getEndOffset() <= n5) {
                    CsmObject csmObject = csmReference.getReferencedObject();
                    if (CsmKindUtilities.isVariable((CsmObject)csmObject) && !CsmAutosProviderImpl.filterAuto((CsmScopeElement)((CsmVariable)csmObject))) {
                        StringBuilder stringBuilder = new StringBuilder(csmReference.getText());
                        if (csmReferenceContext.size() > 1) {
                            block5: for (int i = csmReferenceContext.size() - 1; i >= 0; --i) {
                                CppTokenId cppTokenId = csmReferenceContext.getToken(i);
                                switch (cppTokenId) {
                                    case DOT: 
                                    case ARROW: 
                                    case SCOPE: {
                                        break;
                                    }
                                    default: {
                                        break block5;
                                    }
                                }
                                if (i <= 0) continue;
                                stringBuilder.insert(0, cppTokenId.fixedText());
                                stringBuilder.insert(0, csmReferenceContext.getReference(i - 1).getText());
                            }
                        }
                        set.add(stringBuilder.toString());
                    } else if (AUTOS_INCLUDE_MACROS && CsmKindUtilities.isMacro((CsmObject)csmObject)) {
                        String string = ((Object)csmReference.getText()).toString();
                        int[] nArray = CsmMacroExpansion.getMacroExpansionSpan((Document)styledDocument, (int)csmReference.getStartOffset(), (boolean)false);
                        if (nArray != null && nArray[0] != nArray[1]) {
                            try {
                                string = styledDocument.getText(nArray[0], nArray[1] - nArray[0]);
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                        set.add(string);
                    }
                }
            }
        });
        return n3;
    }

    private static CsmOffsetable getStatement(CsmFile csmFile, int n) {
        CsmContext csmContext = CsmOffsetResolver.findContext(csmFile, n, null);
        CsmScope csmScope = csmContext.getLastScope();
        for (CsmScopeElement csmScopeElement : csmScope.getScopeElements()) {
            CsmOffsetable csmOffsetable;
            if (!CsmKindUtilities.isOffsetable((Object)csmScopeElement) || (csmOffsetable = (CsmOffsetable)csmScopeElement).getEndOffset() < n) continue;
            if (csmOffsetable.getStartOffset() > n || CsmKindUtilities.isCompoundStatement((CsmObject)csmOffsetable)) {
                return null;
            }
            return csmOffsetable;
        }
        return null;
    }

    private static boolean filterAuto(CsmScopeElement csmScopeElement) {
        CsmScope csmScope = csmScopeElement.getScope();
        return CsmKindUtilities.isNamespace((Object)csmScope) && "std".equals(((Object)((CsmNamespace)csmScope).getQualifiedName()).toString());
    }

    private static int[] getInterestedStatementOffsets(CsmOffsetable csmOffsetable) {
        if (CsmKindUtilities.isStatement((CsmObject)csmOffsetable)) {
            switch (((CsmStatement)csmOffsetable).getKind()) {
                case IF: {
                    csmOffsetable = ((CsmIfStatement)csmOffsetable).getCondition();
                    break;
                }
                case SWITCH: {
                    csmOffsetable = ((CsmSwitchStatement)csmOffsetable).getCondition();
                    break;
                }
                case WHILE: 
                case DO_WHILE: {
                    csmOffsetable = ((CsmLoopStatement)csmOffsetable).getCondition();
                    break;
                }
                case FOR: {
                    csmOffsetable = ((CsmForStatement)csmOffsetable).getCondition();
                }
            }
        }
        return new int[]{csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset()};
    }
}

