/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmDeclarationResolver {
    private static final Comparator<CsmOffsetable> OFFSETABLE_COMPARATOR = new OffsetableComparator<CsmOffsetable>();

    private CsmDeclarationResolver() {
    }

    public static CsmDeclaration findDeclaration(CsmObject csmObject) {
        if (csmObject == null) {
            return null;
        }
        CsmClass csmClass = null;
        if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            CsmVariable csmVariable = (CsmVariable)csmObject;
            csmObject = csmVariable.getType();
        }
        if (!CsmKindUtilities.isType((CsmObject)csmObject)) {
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObject)) {
                csmClass = ((CsmClassForwardDeclaration)csmObject).getCsmClass();
            } else if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                csmClass = (CsmClassifier)csmObject;
            } else if (CsmKindUtilities.isInheritance((CsmObject)csmObject)) {
                csmClass = ((CsmInheritance)csmObject).getClassifier();
            }
        }
        return csmClass;
    }

    public static CsmDeclaration findTopFileDeclaration(CsmFile csmFile, int n) {
        assert (csmFile != null) : "can't be null file in findTopFileDeclaration";
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n);
        Iterator iterator = CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
        while (iterator.hasNext()) {
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            assert (csmDeclaration != null) : "can't be null declaration";
            if (!CsmOffsetUtilities.isInObject((CsmObject)csmDeclaration, n)) continue;
            return csmDeclaration;
        }
        return null;
    }

    public static CsmObject findInnerFileObject(CsmFile csmFile, int n, CsmContext csmContext, FileReferencesContext fileReferencesContext) {
        Iterator iterator;
        CsmSelect.CsmFilter csmFilter;
        Iterator iterator2;
        assert (csmFile != null) : "can't be null file in findTopFileDeclaration";
        CsmContextUtilities.updateContext((CsmObject)csmFile, n, csmContext);
        Object object = null;
        if (fileReferencesContext != null && !fileReferencesContext.isCleaned()) {
            fileReferencesContext.advance(n);
            object = fileReferencesContext.findInnerFileDeclaration(n);
            if (object == null) {
                return fileReferencesContext.findInnerFileObject(n);
            }
            if (CsmOffsetUtilities.isInObject(object, n)) {
                return CsmDeclarationResolver.findInnerDeclaration((CsmDeclaration)object, csmContext, n);
            }
            fileReferencesContext.advance(n - 1);
        }
        if ((object = CsmDeclarationResolver.findInnerDeclaration(iterator2 = CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)(csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(n))), csmContext, n)) == null) {
            iterator = CsmSelect.getIncludes((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            object = CsmOffsetUtilities.findObject(iterator, csmContext, n);
        }
        if (object == null) {
            iterator = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
            object = CsmOffsetUtilities.findObject(iterator, csmContext, n);
        }
        return object;
    }

    private static CsmDeclaration findInnerDeclaration(Iterator<? extends CsmDeclaration> iterator, CsmContext csmContext, int n) {
        CsmDeclaration csmDeclaration = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                CsmDeclaration csmDeclaration2 = iterator.next();
                assert (csmDeclaration2 != null) : "can't be null declaration";
                if (CsmOffsetUtilities.isInObject((CsmObject)csmDeclaration2, n)) {
                    if (!CsmKindUtilities.isFunction((CsmObject)csmDeclaration2) || CsmOffsetUtilities.isInFunctionScope((CsmFunction)csmDeclaration2, n)) {
                        CsmContextUtilities.updateContext((CsmObject)csmDeclaration2, n, csmContext);
                        csmDeclaration = CsmDeclarationResolver.findInnerDeclaration(csmDeclaration2, n, csmContext);
                    } else {
                        csmContext.setLastObject((CsmObject)csmDeclaration2);
                    }
                    CsmDeclaration csmDeclaration3 = csmDeclaration = csmDeclaration != null ? csmDeclaration : csmDeclaration2;
                }
                if (!CsmOffsetUtilities.isBeforeObject((CsmObject)csmDeclaration2, n)) continue;
                break;
            }
        }
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, CsmContext csmContext, int n) {
        CsmDeclaration csmDeclaration2 = null;
        assert (csmDeclaration != null) : "can't be null declaration";
        if (!CsmKindUtilities.isFunction((CsmObject)csmDeclaration) || CsmOffsetUtilities.isInFunctionScope((CsmFunction)csmDeclaration, n)) {
            CsmContextUtilities.updateContext((CsmObject)csmDeclaration, n, csmContext);
            csmDeclaration2 = CsmDeclarationResolver.findInnerDeclaration(csmDeclaration, n, csmContext);
        } else {
            csmContext.setLastObject((CsmObject)csmDeclaration);
        }
        csmDeclaration2 = csmDeclaration2 != null ? csmDeclaration2 : csmDeclaration;
        return csmDeclaration2;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, int n, CsmContext csmContext) {
        CsmTypedef csmTypedef;
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmDeclaration, n)) : "must be in outDecl object!";
        Iterator iterator = null;
        if (CsmKindUtilities.isNamespace((Object)csmDeclaration)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmDeclaration;
            iterator = csmNamespace.getDeclarations().iterator();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
            CsmClass csmClass = (CsmClass)csmDeclaration;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(csmClass.getMembers());
            if (!csmClass.getFriends().isEmpty()) {
                arrayList.addAll(csmClass.getFriends());
                Collections.sort(arrayList, OFFSETABLE_COMPARATOR);
            }
            iterator = arrayList.iterator();
        } else if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
            CsmEnum csmEnum = (CsmEnum)csmDeclaration;
            iterator = csmEnum.getEnumerators().iterator();
        } else if (CsmKindUtilities.isTypedef((CsmObject)csmDeclaration) && ((csmTypedef = (CsmTypedef)csmDeclaration).isTypeUnnamed() || csmTypedef.getName().length() == 0) && CsmOffsetUtilities.isInObject((CsmObject)(csmDeclaration = csmTypedef.getType().getClassifier()), n)) {
            CsmContextUtilities.updateContext((CsmObject)csmDeclaration, n, csmContext);
            return CsmDeclarationResolver.findInnerDeclaration(csmDeclaration, n, csmContext);
        }
        return CsmDeclarationResolver.findInnerDeclaration(iterator, csmContext, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        private OffsetableComparator() {
        }

        @Override
        public int compare(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
            int n = csmOffsetable.getStartOffset() - csmOffsetable2.getStartOffset();
            if (n == 0) {
                return csmOffsetable.getEndOffset() - csmOffsetable2.getEndOffset();
            }
            return n;
        }
    }
}

