/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmDeclarationResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.SymTabCache;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionResolverImpl
implements CompletionResolver {
    private static final boolean DEBUG_SUMMARY = Boolean.getBoolean("csm.utilities.trace.summary");
    private static final boolean TRACE = Boolean.getBoolean("csm.utilities.trace");
    private static final boolean DEBUG = TRACE | DEBUG_SUMMARY;
    private int resolveTypes = 0;
    private int hideTypes = -1;
    private CsmFile file;
    private CsmContext context;
    CompletionResolver.Result result = EMPTY_RESULT;
    CsmProjectContentResolver contResolver = null;
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private static int NOT_INITIALIZED = -1;
    private int contextOffset = NOT_INITIALIZED;
    private CsmCompletionQuery.QueryScope queryScope = CsmCompletionQuery.QueryScope.GLOBAL_QUERY;
    private boolean inIncludeDirective = false;
    private final FileReferencesContext fileReferncesContext;
    public static final boolean STAT_COMPLETION = Boolean.getBoolean("cnd.completion.stat");
    public static final boolean TIMING_COMPLETION = Boolean.getBoolean("cnd.completion.timing") || STAT_COMPLETION;
    public static final boolean USE_CACHE = true;
    private static final CompletionResolver.Result EMPTY_RESULT = new EmptyResultImpl();

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean bl) {
        this.sort = bl;
    }

    public void setContextOffset(int n) {
        this.contextOffset = n;
    }

    @Override
    public CsmCompletionQuery.QueryScope setResolveScope(CsmCompletionQuery.QueryScope queryScope) {
        CsmCompletionQuery.QueryScope queryScope2 = this.queryScope;
        this.queryScope = queryScope;
        return queryScope2;
    }

    public void setInIncludeDirective(boolean bl) {
        this.inIncludeDirective = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public CompletionResolverImpl(CsmFile csmFile) {
        this(csmFile, false, false, false, null);
    }

    public CompletionResolverImpl(CsmFile csmFile, boolean bl, boolean bl2, boolean bl3, FileReferencesContext fileReferencesContext) {
        this(csmFile, 1, bl, bl2, bl3, fileReferencesContext);
    }

    private CompletionResolverImpl(CsmFile csmFile, int n, boolean bl, boolean bl2, boolean bl3, FileReferencesContext fileReferencesContext) {
        this.file = csmFile;
        this.resolveTypes = n;
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.sort = bl2;
        this.fileReferncesContext = fileReferencesContext;
    }

    @Override
    public void setResolveTypes(int n) {
        this.resolveTypes = n;
    }

    @Override
    public boolean refresh() {
        this.result = EMPTY_RESULT;
        if (this.file != null && this.file.getProject() != null && !this.file.getProject().isValid()) {
            this.file = CsmUtilities.getCsmFile((FileObject)CsmUtilities.getFileObject((CsmFile)this.file), (boolean)true);
        }
        this.context = null;
        this.contResolver = null;
        if (this.file == null) {
            return false;
        }
        this.contResolver = this.createContentResolver();
        return true;
    }

    public boolean update(boolean bl, boolean bl2) {
        this.caseSensitive = bl;
        this.naturalSort = bl2;
        return this.refresh();
    }

    @Override
    public boolean resolve(int n, String string, boolean bl) {
        int n2;
        int n3 = n2 = this.contextOffset == NOT_INITIALIZED ? n : this.contextOffset;
        if (this.file == null) {
            return false;
        }
        this.context = CsmOffsetResolver.findContext(this.file, n2, this.fileReferncesContext);
        if (DEBUG) {
            System.out.println("context for offset " + n2 + " :\n" + this.context);
        }
        this.initResolveMask(this.context, n2, string, bl);
        this.hideTypes = CompletionResolverImpl.initHideMask(this.context, n2, this.resolveTypes, this.queryScope, string, bl, this.inIncludeDirective);
        this.resolveContext(this.context, n2, string, bl);
        return this.file != null;
    }

    @Override
    public CompletionResolver.Result getResult() {
        return this.result;
    }

    private void resolveContext(CsmContext csmContext, int n, String string, boolean bl) {
        CsmProject csmProject;
        long l = 0L;
        if (TIMING_COMPLETION) {
            l = System.currentTimeMillis();
            System.err.println("Started resolving context");
        }
        CsmProject csmProject2 = csmProject = this.file != null ? this.file.getProject() : null;
        if (csmProject == null) {
            return;
        }
        SymTabCache.CacheEntry cacheEntry = null;
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext, true);
        ResultImpl resultImpl = new ResultImpl();
        boolean bl2 = this.resolveLocalContext(csmProject, resultImpl, csmFunction, csmContext, n, string, bl);
        if (this.isEnough(string, bl)) {
            if (bl2) {
                this.result = CompletionResolverImpl.buildResult(csmContext, resultImpl);
                return;
            }
            CsmFunction csmFunction2 = null;
            if (csmFunction != null) {
                csmFunction2 = csmFunction;
            } else if (CsmKindUtilities.isVariable((CsmObject)csmContext.getLastObject())) {
                csmFunction2 = (CsmVariable)csmContext.getLastObject();
            }
            if (CsmBaseUtilities.isValid((CsmObject)csmFunction2) && this.fileReferncesContext != null) {
                CsmUID csmUID = UIDs.get((Object)csmFunction2);
                cacheEntry = new SymTabCache.CacheEntry(this.resolveTypes, this.hideTypes, string, csmUID);
                CompletionResolver.Result result = this.fileReferncesContext.getSymTabCache().get(cacheEntry);
                if (result != null) {
                    this.result = result;
                    return;
                }
                this.fileReferncesContext.getSymTabCache().setScope(csmUID);
            }
        }
        this.resolveContext(csmProject, resultImpl, csmContext, n, string, bl);
        this.result = CompletionResolverImpl.buildResult(csmContext, resultImpl);
        if (cacheEntry != null) {
            this.fileReferncesContext.getSymTabCache().put(cacheEntry, this.result);
        }
        if (TIMING_COMPLETION) {
            l = System.currentTimeMillis() - l;
            System.err.println("Resolving context took " + l + "ms");
        }
    }

    private boolean isEnough(String string, boolean bl) {
        return bl && string != null && string.length() > 0;
    }

    private boolean isEnough(String string, boolean bl, Collection collection) {
        if (collection != null && this.isEnough(string, bl)) {
            return !collection.isEmpty();
        }
        return false;
    }

    private boolean isEnoughAfterFilterVisibileObjects(String string, boolean bl, Collection<? extends CsmObject> collection, Collection collection2) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isEnough(string, bl, collection)) {
            assert (collection != null && !collection.isEmpty());
            ArrayList<CsmObject> arrayList = new ArrayList<CsmObject>();
            CsmIncludeResolver csmIncludeResolver = CsmIncludeResolver.getDefault();
            CsmFile csmFile = this.contResolver.getStartFile();
            for (CsmObject csmObject : collection) {
                if (!csmIncludeResolver.isObjectVisible(csmFile, csmObject)) continue;
                arrayList.add(csmObject);
                bl3 = true;
                if (CsmClassifierResolver.getDefault().isForwardClass(csmObject)) continue;
                bl2 = true;
            }
            if (bl3) {
                collection2.addAll(arrayList);
            }
        }
        return bl2;
    }

    private boolean resolveLocalContext(CsmProject csmProject, ResultImpl resultImpl, CsmFunction csmFunction, CsmContext csmContext, int n, String string, boolean bl) {
        boolean bl2 = this.needLocalVars(csmContext, n);
        boolean bl3 = this.needLocalClasses(csmContext, n);
        if (bl2 || bl3) {
            List<CsmDeclaration> list = this.contResolver.findFunctionLocalDeclarations(csmContext, string, bl);
            resultImpl.localVars = new ArrayList(list.size());
            for (CsmDeclaration csmDeclaration : list) {
                if (bl2 && CsmKindUtilities.isVariable((CsmObject)csmDeclaration)) {
                    resultImpl.localVars.add((CsmVariable)csmDeclaration);
                    if (this.isEnough(string, bl)) {
                        return true;
                    }
                }
                if (bl3 && CsmKindUtilities.isClassifier((CsmObject)csmDeclaration)) {
                    if (resultImpl.classesEnumsTypedefs == null) {
                        resultImpl.classesEnumsTypedefs = new ArrayList();
                    }
                    resultImpl.classesEnumsTypedefs.add((CsmClassifier)csmDeclaration);
                    if (this.isEnough(string, bl)) {
                        return true;
                    }
                }
                if (bl2 && CsmKindUtilities.isEnumerator((Object)csmDeclaration)) {
                    if (resultImpl.fileLocalEnumerators == null) {
                        resultImpl.fileLocalEnumerators = new ArrayList();
                    }
                    resultImpl.fileLocalEnumerators.add((CsmEnumerator)csmDeclaration);
                    if (this.isEnough(string, bl)) {
                        return true;
                    }
                }
                if (!bl2 || !CsmKindUtilities.isFunction((CsmObject)csmDeclaration)) continue;
                if (resultImpl.fileLocalFunctions == null) {
                    resultImpl.fileLocalFunctions = new ArrayList();
                }
                resultImpl.fileLocalFunctions.add((CsmFunction)csmDeclaration);
                if (!this.isEnough(string, bl)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean resolveContext(CsmProject csmProject, ResultImpl resultImpl, CsmContext csmContext, int n, String string, boolean bl) {
        boolean bl2;
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext, true);
        if (this.needLocalVars(csmContext, n)) {
            boolean bl3;
            if (resultImpl.fileLocalEnumerators == null) {
                resultImpl.fileLocalEnumerators = new ArrayList();
            }
            resultImpl.fileLocalEnumerators.addAll(this.contResolver.getFileLocalEnumerators(csmContext, string, bl));
            if (this.isEnough(string, bl, resultImpl.fileLocalEnumerators)) {
                return true;
            }
            boolean bl4 = bl3 = csmFunction == null ? true : CsmBaseUtilities.isStaticContext((CsmFunction)csmFunction);
            if (this.needClassElements(csmContext, n)) {
                bl2 = true;
                CsmFunction csmFunction2 = csmFunction;
                CsmClass csmClass = csmFunction == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
                CsmClass csmClass2 = csmClass = csmClass != null ? csmClass : CsmContextUtilities.getClass(csmContext, false, true);
                if (csmClass == null && (csmClass = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)csmFunction)) != null) {
                    Iterator iterator;
                    CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(csmFunction.getName(), true, this.caseSensitive, false);
                    Iterator iterator2 = iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)csmFilter);
                    while (iterator2.hasNext()) {
                        CsmMember csmMember = (CsmMember)iterator2.next();
                        if (!CsmKindUtilities.isVariable((CsmObject)csmMember)) continue;
                        csmFunction2 = csmMember;
                        bl3 = csmMember.isStatic();
                    }
                }
                if (csmClass != null) {
                    resultImpl.classFields = this.contResolver.getFields(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl3, bl, true, bl2, false);
                    if (this.isEnough(string, bl, resultImpl.classFields)) {
                        return true;
                    }
                    resultImpl.classEnumerators = this.contResolver.getEnumerators(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl, true, bl2, false);
                    if (this.isEnough(string, bl, resultImpl.classEnumerators)) {
                        return true;
                    }
                    resultImpl.classMethods = this.contResolver.getMethods(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl3, bl, true, bl2, false);
                    if (this.isEnough(string, bl, resultImpl.classMethods)) {
                        return true;
                    }
                    if (this.needNestedClassifiers(csmContext, n)) {
                        resultImpl.classesEnumsTypedefs = this.contResolver.getNestedClassifiers(csmClass, (CsmOffsetableDeclaration)csmFunction2, string, bl, this.needClasses(csmContext, n), bl2);
                        if (this.isEnough(string, bl, resultImpl.classesEnumsTypedefs)) {
                            return true;
                        }
                    }
                }
            }
        } else if (this.needClassElements(csmContext, n)) {
            CsmClass csmClass = csmFunction == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
            CsmClass csmClass3 = csmClass = csmClass != null ? csmClass : CsmContextUtilities.getClass(csmContext, false, true);
            if (csmClass != null) {
                int n2;
                bl2 = false;
                CsmFunction csmFunction3 = csmFunction != null ? csmFunction : csmClass;
                int n3 = n2 = bl ? 0 : 1;
                while (n2 < 2) {
                    boolean bl5;
                    boolean bl6 = bl5 = n2 == 1;
                    if (this.needClassMethods(csmContext, n) && csmClass != null) {
                        resultImpl.classMethods = this.contResolver.getMethods(csmClass, (CsmOffsetableDeclaration)csmFunction3, string, bl2, bl, bl5, bl5, false);
                        if (this.isEnough(string, bl, resultImpl.classMethods)) {
                            return true;
                        }
                    }
                    if (this.needClassFields(csmContext, n)) {
                        resultImpl.classFields = this.contResolver.getFields(csmClass, (CsmOffsetableDeclaration)csmFunction3, string, bl2, bl, bl5, bl5, false);
                        if (this.isEnough(string, bl, resultImpl.classFields)) {
                            return true;
                        }
                    }
                    if (this.needClassEnumerators(csmContext, n)) {
                        resultImpl.classEnumerators = this.contResolver.getEnumerators(csmClass, (CsmOffsetableDeclaration)csmFunction3, string, bl, bl5, bl5, false);
                        if (this.isEnough(string, bl, resultImpl.classEnumerators)) {
                            return true;
                        }
                    }
                    if (this.needNestedClassifiers(csmContext, n)) {
                        resultImpl.classesEnumsTypedefs = this.contResolver.getNestedClassifiers(csmClass, (CsmOffsetableDeclaration)csmFunction3, string, bl, bl5, bl5);
                        if (this.isEnough(string, bl, resultImpl.classesEnumsTypedefs)) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        }
        if (this.needTemplateParameters(csmContext, n)) {
            resultImpl.templateParameters = this.getTemplateParameters(csmContext, string, bl);
            if (this.isEnough(string, bl, resultImpl.templateParameters)) {
                return true;
            }
        }
        if (this.needClasses(csmContext, n) || this.needContextClasses(csmContext, n)) {
            ArrayList arrayList;
            Collection<CsmClassifier> collection;
            if (resultImpl.classesEnumsTypedefs == null) {
                resultImpl.classesEnumsTypedefs = new ArrayList();
            }
            if (this.isEnoughAfterFilterVisibileObjects(string, bl, collection = this.getClassesEnums(csmContext, csmProject, string, bl, n, !this.needClasses(csmContext, n)), arrayList = new ArrayList())) {
                resultImpl.classesEnumsTypedefs.addAll(arrayList);
                return true;
            }
            resultImpl.classesEnumsTypedefs.addAll(collection);
        }
        if (this.needFileLocalMacros(csmContext, n)) {
            resultImpl.fileLocalMacros = this.contResolver.getFileLocalMacros(csmContext, string, bl);
            if (this.isEnough(string, bl, resultImpl.fileLocalMacros)) {
                return true;
            }
        }
        if (this.needFileLocalFunctions(csmContext, n)) {
            if (resultImpl.fileLocalFunctions == null) {
                resultImpl.fileLocalFunctions = new ArrayList();
            }
            resultImpl.fileLocalFunctions.addAll(this.getFileLocalFunctions(csmContext, string, bl));
            if (this.isEnough(string, bl, resultImpl.fileLocalFunctions)) {
                return true;
            }
        }
        if (this.needFileLocalVars(csmContext, n)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(n);
            }
            resultImpl.fileLocalVars = this.contResolver.getFileLocalVariables(csmContext, this.fileReferncesContext, string, bl, this.queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY || this.queryScope == CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
            if (this.isEnough(string, bl, resultImpl.fileLocalVars)) {
                return true;
            }
            if (resultImpl.fileLocalEnumerators == null) {
                resultImpl.fileLocalEnumerators = this.contResolver.getFileLocalEnumerators(csmContext, string, bl);
                if (this.isEnough(string, bl, resultImpl.fileLocalEnumerators)) {
                    return true;
                }
            }
        }
        if (this.needFileIncludedMacros(csmContext, n)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(n);
                CsmMacro csmMacro = this.fileReferncesContext.findIncludedMacro(string);
                if (csmMacro != null) {
                    resultImpl.fileProjectMacros = new ArrayList(1);
                    resultImpl.fileProjectMacros.add(csmMacro);
                }
                if (this.isEnough(string, bl, resultImpl.fileProjectMacros)) {
                    return true;
                }
            } else {
                resultImpl.fileProjectMacros = this.contResolver.getFileIncludedProjectMacros(csmContext, string, bl);
            }
        }
        if (this.needFileIncludedLibMacros(csmContext, n)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(n);
                CsmMacro csmMacro = this.fileReferncesContext.findIncludedMacro(string);
                if (csmMacro != null) {
                    resultImpl.fileLibMacros = new ArrayList(1);
                    resultImpl.fileLibMacros.add(csmMacro);
                }
            } else {
                resultImpl.fileLibMacros = this.contResolver.getFileIncludeLibMacros(csmContext, string, bl);
            }
            if (this.isEnough(string, bl, resultImpl.fileLibMacros)) {
                return true;
            }
        }
        if (this.needGlobalMacros(csmContext, n)) {
            resultImpl.globProjectMacros = this.contResolver.getProjectMacros(csmContext, string, bl);
            if (this.isEnough(string, bl, resultImpl.globProjectMacros)) {
                return true;
            }
        }
        if (this.needGlobalLibMacros(csmContext, n)) {
            resultImpl.globLibMacros = this.contResolver.getLibMacros(csmContext, string, bl);
            if (this.isEnough(string, bl, resultImpl.globLibMacros)) {
                return true;
            }
        }
        if (this.needGlobalVariables(csmContext, n)) {
            resultImpl.globVars = this.getGlobalVariables(csmContext, csmProject, string, bl, n);
            if (this.isEnough(string, bl, resultImpl.globVars)) {
                return true;
            }
        }
        if (this.needGlobalEnumerators(csmContext, n)) {
            resultImpl.globEnumerators = this.getGlobalEnumerators(csmContext, csmProject, string, bl, n);
            if (this.isEnough(string, bl, resultImpl.globEnumerators)) {
                return true;
            }
        }
        if (this.needGlobalFunctions(csmContext, n)) {
            resultImpl.globFuns = this.getGlobalFunctions(csmContext, csmProject, string, bl, n);
            if (this.isEnough(string, bl, resultImpl.globFuns)) {
                return true;
            }
        }
        if (this.needGlobalNamespaces(csmContext, n)) {
            resultImpl.globProjectNSs = this.getGlobalNamespaces(csmContext, csmProject, string, bl, n);
            if (this.isEnough(string, bl, resultImpl.globProjectNSs)) {
                return true;
            }
            resultImpl.projectNsAliases = this.getProjectNamespaceAliases(csmContext, csmProject, string, bl, n);
            if (this.isEnough(string, bl, resultImpl.projectNsAliases)) {
                return true;
            }
        }
        if (this.needLibClasses(csmContext, n)) {
            ArrayList arrayList;
            Collection<CsmClassifier> collection;
            if (resultImpl.libClasses == null) {
                resultImpl.libClasses = new ArrayList();
            }
            if (this.isEnoughAfterFilterVisibileObjects(string, bl, collection = this.getLibClassesEnums(csmProject, string, bl), arrayList = new ArrayList())) {
                resultImpl.classesEnumsTypedefs.clear();
                resultImpl.libClasses.addAll(arrayList);
                return true;
            }
            resultImpl.libClasses.addAll(collection);
        }
        if (this.needLibVariables(csmContext, n)) {
            resultImpl.libVars = this.getLibVariables(csmProject, string, bl);
            if (this.isEnough(string, bl, resultImpl.libVars)) {
                return true;
            }
        }
        if (this.needLibEnumerators(csmContext, n)) {
            resultImpl.libEnumerators = this.getLibEnumerators(csmProject, string, bl);
            if (this.isEnough(string, bl, resultImpl.libEnumerators)) {
                return true;
            }
        }
        if (this.needLibFunctions(csmContext, n)) {
            resultImpl.libFuns = this.getLibFunctions(csmProject, string, bl);
            if (this.isEnough(string, bl, resultImpl.libFuns)) {
                return true;
            }
        }
        if (this.needLibNamespaces(csmContext, n)) {
            resultImpl.libNSs = this.getLibNamespaces(csmProject, string, bl);
            if (this.isEnough(string, bl, resultImpl.libNSs)) {
                return true;
            }
        }
        return false;
    }

    private static int initHideMask(CsmContext csmContext, int n, int n2, CsmCompletionQuery.QueryScope queryScope, String string, boolean bl, boolean bl2) {
        int n3;
        int n4 = n3 = bl2 ? 507904 : -1;
        if ((n2 & 1) == 1 && string.length() == 0) {
            n3 &= 0xFFEAE1FF;
            if (!CsmKindUtilities.isFile((CsmObject)csmContext.getLastScope())) {
                n3 &= 0xFFFDFFFF;
            }
        }
        if (queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY || queryScope == CsmCompletionQuery.QueryScope.SMART_QUERY) {
            n3 &= 0xFFEAE1FF;
            n3 &= 0xFFFDFFFF;
            n3 &= 0xFFFF7FFF;
            n3 &= 0xFFF7FFFF;
            n3 &= 0xFFFFFFFD;
            n3 &= 0xFFFFFFFB;
            n3 &= 0xFFFFFFF7;
            n3 &= 0xFFFFDFFF;
        }
        if (queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY) {
            n3 &= 0xFFFFFFEF;
            n3 &= 0xFFFFFFDF;
            n3 &= 0xFFBFFFFF;
            n3 &= 0xFFDFFFFF;
        }
        if (bl) {
            n3 |= 2;
            n3 |= 0x200;
        }
        if (CsmContextUtilities.isInType(csmContext, n)) {
            n3 &= 0xFFFFFFEF;
            n3 &= 0xFFFFFFDF;
            n3 &= 0xFFDFFFFF;
        }
        return n3;
    }

    private static CompletionResolver.Result buildResult(CsmContext csmContext, ResultImpl resultImpl) {
        int n = 0;
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.localVars, "Local variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.classFields, "Class fields");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.classEnumerators, "Class enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.classMethods, "Class methods");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.classesEnumsTypedefs, "Classes/Enums/Typedefs");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileLocalVars, "File Local Variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileLocalEnumerators, "File Local Enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileLocalMacros, "File Local Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileLocalFunctions, "File Local Functions");
        }
        CompletionResolverImpl.remove(resultImpl.fileProjectMacros, resultImpl.fileLocalMacros);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileProjectMacros, "File Included Project Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globVars, "Global variables");
        }
        CompletionResolverImpl.remove(resultImpl.globEnumerators, resultImpl.fileLocalEnumerators);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globEnumerators, "Global enumerators");
        }
        CompletionResolverImpl.remove(resultImpl.globProjectMacros, resultImpl.fileProjectMacros);
        CompletionResolverImpl.remove(resultImpl.globProjectMacros, resultImpl.fileLocalMacros);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globProjectMacros, "Global Project Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globFuns, "Global Project functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globProjectNSs, "Global Project Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.projectNsAliases, "Project Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libClasses, "Library classes");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.fileLibMacros, "File Included Library Macros");
        }
        CompletionResolverImpl.remove(resultImpl.globLibMacros, resultImpl.fileLibMacros);
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.globLibMacros, "Global Library Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libVars, "Global Library variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libEnumerators, "Global Library enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libFuns, "Global Library functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libNSs, "Global Library Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            n += CompletionResolverImpl.trace(resultImpl.libNsAliases, "Global Library Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            CompletionResolverImpl.trace(null, "There are " + n + " resovled elements");
        }
        return resultImpl;
    }

    private static <T> Collection remove(Collection<T> collection, Collection<T> collection2) {
        CsmUtilities.removeAll(collection, collection2);
        return collection;
    }

    protected CsmProjectContentResolver createContentResolver() {
        CsmProject csmProject;
        CsmFile csmFile = this.file;
        CsmProject csmProject2 = csmProject = csmFile.getProject();
        CsmFile csmFile2 = this.file;
        ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>();
        boolean bl = csmProject2.isArtificial();
        for (CsmCompilationUnit csmCompilationUnit : CsmFileInfoQuery.getDefault().getCompilationUnits(this.file, this.contextOffset)) {
            CsmFile csmFile3 = csmCompilationUnit.getStartFile();
            CsmProject csmProject3 = csmFile3 == null ? null : csmFile3.getProject();
            if (csmProject3 == null) continue;
            csmProject2 = bl ? csmProject3 : csmProject2;
            csmFile2 = csmFile3;
            break;
        }
        arrayList.addAll(csmProject2.getLibraries());
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(csmFile2, csmProject, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort(), arrayList);
        return csmProjectContentResolver;
    }

    private static Collection merge(Collection collection, Collection collection2) {
        return CsmUtilities.merge((Collection)collection, (Collection)collection2);
    }

    private Collection<CsmTemplateParameter> getTemplateParameters(CsmContext csmContext, String string, boolean bl) {
        CsmObject csmObject;
        CsmObject csmObject2;
        ArrayList<CsmTemplateParameter> arrayList = null;
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext, false);
        ArrayList<CsmTemplate> arrayList2 = new ArrayList<CsmTemplate>();
        if (csmFunction == null && csmContext.getLastObject() != null) {
            csmObject2 = csmContext.getLastObject();
            if (CsmKindUtilities.isFunction((CsmObject)csmObject2)) {
                csmFunction = (CsmFunction)csmObject2;
            } else {
                int n = ((CsmOffsetable)csmContext.getLastObject()).getEndOffset();
                csmObject2 = CsmDeclarationResolver.findInnerFileObject(this.file, n, csmContext, this.fileReferncesContext);
                if (CsmKindUtilities.isFunction((CsmObject)csmObject2)) {
                    csmFunction = (CsmFunction)csmObject2;
                } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObject2) && CsmKindUtilities.isTemplate((CsmObject)csmObject2)) {
                    arrayList2.add((CsmTemplate)csmObject2);
                }
            }
            if (CsmKindUtilities.isTemplate((CsmObject)csmObject2) && csmObject2 != csmFunction) {
                arrayList2.add((CsmTemplate)csmObject2);
            }
        }
        if (CsmKindUtilities.isTemplate((CsmObject)csmFunction)) {
            arrayList2.add((CsmTemplate)csmFunction);
        }
        csmObject2 = csmFunction == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
        CsmClass csmClass = CsmContextUtilities.getClass(csmContext, false, false);
        Object object = csmObject = csmObject2 != null ? csmObject2 : csmClass;
        if (csmObject != null) {
            if (CsmKindUtilities.isTemplate((CsmObject)csmObject) && !arrayList2.contains((CsmTemplate)csmObject)) {
                arrayList2.add((CsmTemplate)csmObject);
            }
            Object object2 = csmObject.getScope();
            while (CsmKindUtilities.isClass((CsmObject)object2)) {
                if (CsmKindUtilities.isTemplate((CsmObject)object2)) {
                    arrayList2.add((CsmTemplate)object2);
                }
                object2 = ((CsmClass)object2).getScope();
            }
        }
        if (!arrayList2.isEmpty()) {
            arrayList = new ArrayList<CsmTemplateParameter>();
            for (CsmTemplate csmTemplate : arrayList2) {
                this.getTemplateParameters(csmTemplate, string, bl, arrayList);
            }
        }
        return arrayList;
    }

    private void getTemplateParameters(CsmTemplate csmTemplate, String string, boolean bl, Collection<CsmTemplateParameter> collection) {
        for (CsmTemplateParameter csmTemplateParameter : csmTemplate.getTemplateParameters()) {
            if (CsmSortUtilities.matchName((CharSequence)csmTemplateParameter.getName(), (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive)) {
                collection.add(csmTemplateParameter);
            }
            if (!CsmKindUtilities.isTemplate((CsmObject)csmTemplateParameter)) continue;
            this.getTemplateParameters((CsmTemplate)csmTemplateParameter, string, bl, collection);
        }
    }

    private Collection<CsmClassifier> getClassesEnums(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n, boolean bl2) {
        if (csmProject == null) {
            return null;
        }
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, bl2);
        LinkedHashSet<CsmClassifier> linkedHashSet = new LinkedHashSet<CsmClassifier>(1024);
        for (Object object : collection) {
            List<CsmClassifier> list = this.contResolver.getNamespaceClassesEnums((CsmNamespace)object, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        if (!bl2) {
            Object object;
            object = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
            linkedHashSet.addAll((Collection<CsmClassifier>)object);
        }
        return linkedHashSet;
    }

    private Collection<CsmVariable> getGlobalVariables(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Object object2;
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet<CsmVariable> linkedHashSet = new LinkedHashSet<CsmVariable>(1024);
        for (Object object2 : collection) {
            List<CsmVariable> list = this.contResolver.getNamespaceVariables((CsmNamespace)object2, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE};
        object2 = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
        linkedHashSet.addAll((Collection<CsmVariable>)object2);
        return linkedHashSet;
    }

    private Collection<CsmEnumerator> getGlobalEnumerators(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet<CsmEnumerator> linkedHashSet = new LinkedHashSet<CsmEnumerator>(1024);
        for (CsmNamespace csmNamespace : collection) {
            List<CsmEnumerator> list = this.contResolver.getNamespaceEnumerators(csmNamespace, string, bl, false);
            linkedHashSet.addAll(list);
        }
        return linkedHashSet;
    }

    private Collection<CsmFunction> getGlobalFunctions(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Object object2;
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet<CsmFunction> linkedHashSet = new LinkedHashSet<CsmFunction>(1024);
        for (Object object2 : collection) {
            List<CsmFunction> list = this.contResolver.getNamespaceFunctions((CsmNamespace)object2, string, bl, false);
            linkedHashSet.addAll(list);
        }
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        object2 = this.getUsedDeclarations(this.file, n, string, bl, kindArray);
        linkedHashSet.addAll((Collection<CsmFunction>)object2);
        return linkedHashSet;
    }

    private Collection<CsmFunction> getFileLocalFunctions(CsmContext csmContext, String string, boolean bl) {
        List<CsmFunction> list = this.contResolver.getFileLocalFunctions(csmContext, string, bl, this.queryScope == CsmCompletionQuery.QueryScope.LOCAL_QUERY);
        return list;
    }

    private Collection<CsmNamespace> getGlobalNamespaces(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        Collection<CsmNamespace> collection = this.getNamespacesToSearch(csmContext, this.file, n, string.length() == 0, false);
        LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>(1024);
        for (CsmNamespace csmNamespace : collection) {
            List<CsmNamespace> list = this.contResolver.getNestedNamespaces(csmNamespace, string, bl);
            linkedHashSet.addAll(list);
        }
        return linkedHashSet;
    }

    private Collection<CsmNamespaceAlias> getProjectNamespaceAliases(CsmContext csmContext, CsmProject csmProject, String string, boolean bl, int n) {
        CsmProject csmProject2 = string.length() == 0 ? csmProject : null;
        Collection<CsmDeclaration> collection = CsmUsingResolver.getDefault().findNamespaceAliases(this.file, n, csmProject2);
        Collection<CsmDeclaration> collection2 = string.length() > 0 ? this.filterDeclarations(collection, string, bl, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS}) : collection;
        return collection2;
    }

    private Collection<CsmClassifier> getLibClassesEnums(CsmProject csmProject, String string, boolean bl) {
        return this.contResolver.getLibClassesEnums(string, bl);
    }

    private Collection<CsmVariable> getLibVariables(CsmProject csmProject, String string, boolean bl) {
        return this.contResolver.getLibVariables(string, bl);
    }

    private Collection<CsmEnumerator> getLibEnumerators(CsmProject csmProject, String string, boolean bl) {
        Collection<CsmEnumerator> collection = null;
        if (this.fileReferncesContext != null && bl) {
            collection = this.fileReferncesContext.getLibEnumerators(string);
        }
        if (collection == null) {
            collection = this.contResolver.getLibEnumerators(string, bl, true);
            if (this.fileReferncesContext != null && bl) {
                this.fileReferncesContext.putLibEnumerators(string, collection);
            }
        }
        return collection;
    }

    private Collection<CsmFunction> getLibFunctions(CsmProject csmProject, String string, boolean bl) {
        return this.contResolver.getLibFunctions(string, bl);
    }

    private Collection<CsmNamespace> getLibNamespaces(CsmProject csmProject, String string, boolean bl) {
        return this.contResolver.getLibNamespaces(string, bl);
    }

    private boolean needLocalClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x80) == 128;
    }

    private boolean needClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 2) == 2;
    }

    private boolean needContextClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x1000000) == 0x1000000;
    }

    private void updateResolveTypesInFunction(int n, CsmContext csmContext, boolean bl) {
        this.resolveTypes |= 0x80;
        boolean bl2 = CsmContextUtilities.isInType(csmContext, n);
        if (!bl2) {
            this.resolveTypes |= 0x100;
            this.resolveTypes |= 0x40;
            this.resolveTypes |= 4;
            this.resolveTypes |= 0x2000;
            this.resolveTypes |= 0x10;
            this.resolveTypes |= 0x200000;
            this.resolveTypes |= 0x1000;
        }
        if (CsmContextUtilities.isInFunctionBodyOrInitializerList(csmContext, n)) {
            if (!bl2 || !bl) {
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x800000;
                this.resolveTypes |= 0x800;
                this.resolveTypes |= 0x20;
            }
            if (!bl) {
                this.resolveTypes |= 0x100;
                this.resolveTypes |= 0x40;
                this.resolveTypes |= 4;
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x200000;
            }
        }
    }

    private boolean needFileLocalVars(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x100) == 256;
    }

    private boolean needLocalVars(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x40) == 64;
    }

    private boolean needGlobalVariables(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 4) == 4;
    }

    private boolean needGlobalEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x2000) == 8192;
    }

    private boolean needGlobalFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 8) == 8;
    }

    private boolean needGlobalNamespaces(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x80000) == 524288;
    }

    private boolean needFunctionVars(CsmContext csmContext, int n) {
        return this.needLocalVars(csmContext, n);
    }

    private boolean needLibClasses(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x200) == 512;
    }

    private boolean needLibVariables(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x400) == 1024;
    }

    private boolean needLibEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x1000) == 4096;
    }

    private boolean needLibFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x800) == 2048;
    }

    private boolean needLibNamespaces(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x100000) == 0x100000;
    }

    private boolean needFileLocalMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x4000) == 16384;
    }

    private boolean needFileLocalFunctions(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x800000) == 0x800000;
    }

    private boolean needFileIncludedMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x8000) == 32768;
    }

    private boolean needFileIncludedLibMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x10000) == 65536;
    }

    private boolean needGlobalMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20000) == 131072;
    }

    private boolean needGlobalLibMacros(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x40000) == 262144;
    }

    private boolean needClassMethods(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32;
    }

    private boolean needClassFields(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x10) == 16;
    }

    private boolean needClassEnumerators(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000;
    }

    private boolean needNestedClassifiers(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x400000) == 0x400000;
    }

    private boolean needClassElements(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32 || (this.hideTypes & this.resolveTypes & 0x10) == 16 || (this.hideTypes & this.resolveTypes & 0x400000) == 0x400000 || (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000;
    }

    private boolean needTemplateParameters(CsmContext csmContext, int n) {
        return (this.hideTypes & this.resolveTypes & 0x2000000) == 0x2000000;
    }

    private static int trace(Collection<? extends CsmObject> collection, String string) {
        System.err.println("\t" + string + " [size - " + (collection == null ? "null" : Integer.valueOf(collection.size())) + "]");
        if (collection == null) {
            return 0;
        }
        if (TRACE) {
            int n = 0;
            for (CsmObject csmObject : collection) {
                System.err.println("\t\t[" + n + "]" + CsmUtilities.getCsmName((CsmObject)csmObject));
                ++n;
            }
        }
        return collection.size();
    }

    private static <T> Collection<T> maskNull(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    private static <T> Collection appendResult(Collection<T> collection, ResultImpl resultImpl) {
        assert (collection != null);
        CompletionResolverImpl.merge(collection, resultImpl.localVars);
        CompletionResolverImpl.merge(collection, resultImpl.classFields);
        CompletionResolverImpl.merge(collection, resultImpl.classEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.classMethods);
        CompletionResolverImpl.merge(collection, resultImpl.classesEnumsTypedefs);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalVars);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalMacros);
        CompletionResolverImpl.merge(collection, resultImpl.fileLocalFunctions);
        CompletionResolverImpl.merge(collection, resultImpl.fileProjectMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globVars);
        CompletionResolverImpl.merge(collection, resultImpl.globEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.globProjectMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globFuns);
        CompletionResolverImpl.merge(collection, resultImpl.globProjectNSs);
        CompletionResolverImpl.merge(collection, resultImpl.projectNsAliases);
        CompletionResolverImpl.merge(collection, resultImpl.libClasses);
        CompletionResolverImpl.merge(collection, resultImpl.fileLibMacros);
        CompletionResolverImpl.merge(collection, resultImpl.globLibMacros);
        CompletionResolverImpl.merge(collection, resultImpl.libVars);
        CompletionResolverImpl.merge(collection, resultImpl.libEnumerators);
        CompletionResolverImpl.merge(collection, resultImpl.libFuns);
        CompletionResolverImpl.merge(collection, resultImpl.libNSs);
        CompletionResolverImpl.merge(collection, resultImpl.libNsAliases);
        CompletionResolverImpl.merge(collection, resultImpl.templateParameters);
        return collection;
    }

    private void initResolveMask(CsmContext csmContext, int n, String string, boolean bl) {
        if ((this.resolveTypes & 1) == 1) {
            this.resolveTypes = string.length() == 0 ? (this.resolveTypes |= 0x8000) : (this.fileReferncesContext == null ? (this.resolveTypes |= 0x60000) : (this.resolveTypes |= 0x18000));
            this.resolveTypes |= 0x1000000;
            this.resolveTypes |= 2;
            this.resolveTypes |= 0x2000000;
            this.resolveTypes |= 0x80000;
            this.resolveTypes |= 0x200;
            this.resolveTypes |= 0x100000;
            this.resolveTypes |= 0x400000;
            this.resolveTypes |= 0x804100;
            this.resolveTypes |= 4;
            this.resolveTypes |= 0x2000;
            assert (csmContext != null);
            boolean bl2 = false;
            if (CsmContextUtilities.isInFunction(csmContext, n)) {
                this.updateResolveTypesInFunction(n, csmContext, bl);
            } else if (CsmContextUtilities.getClass(csmContext, false, true) != null) {
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x20;
                this.resolveTypes |= 0x200000;
            } else {
                bl2 = true;
            }
            if (bl2 || bl && CsmContextUtilities.isInInitializerList(csmContext, n)) {
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x80000;
                this.resolveTypes |= 0x200;
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 0x1000;
                this.resolveTypes |= 0x800;
                this.resolveTypes |= 0x100000;
            }
        }
    }

    private Collection<CsmDeclaration> getUsedDeclarations(CsmFile csmFile, int n, String string, boolean bl, CsmDeclaration.Kind[] kindArray) {
        CsmProject csmProject = csmFile.getProject();
        CsmProject csmProject2 = string.length() == 0 ? csmProject : null;
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmFile, n, csmProject2);
        Collection<CsmDeclaration> collection2 = this.filterDeclarations(collection, string, bl, kindArray);
        return collection2;
    }

    private Collection<CsmDeclaration> filterDeclarations(Collection<CsmDeclaration> collection, String string, boolean bl, CsmDeclaration.Kind[] kindArray) {
        LinkedHashSet<CsmDeclaration> linkedHashSet = new LinkedHashSet<CsmDeclaration>(collection.size());
        this.contResolver.filterDeclarations(collection.iterator(), linkedHashSet, kindArray, string, bl, false);
        return linkedHashSet;
    }

    private Collection<CsmNamespace> getNamespacesToSearch(CsmContext csmContext, CsmFile csmFile, int n, boolean bl, boolean bl2) {
        CsmProject csmProject = csmFile.getProject();
        CsmProject csmProject2 = bl || bl2 ? csmProject : null;
        Collection<CsmNamespace> collection = new ArrayList<CsmNamespace>();
        List<CsmNamespace> list = this.getContextNamespaces(csmContext);
        collection.addAll(list);
        collection = this.filterNamespaces(collection, csmProject2);
        if (!bl2) {
            collection.addAll(CsmUsingResolver.getDefault().findVisibleNamespaces(csmFile, n, csmProject2));
        }
        if (csmProject != null) {
            CsmNamespace csmNamespace = csmProject.getGlobalNamespace();
            collection.add(csmNamespace);
        }
        return collection;
    }

    private List<CsmNamespace> getContextNamespaces(CsmContext csmContext) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmNamespace csmNamespace = CsmContextUtilities.getNamespace(csmContext); csmNamespace != null && !csmNamespace.isGlobal(); csmNamespace = csmNamespace.getParent()) {
            arrayList.add(csmNamespace);
        }
        return arrayList;
    }

    private Collection<CsmNamespace> filterNamespaces(Collection<CsmNamespace> collection, CsmProject csmProject) {
        LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>(collection.size());
        for (CsmNamespace csmNamespace : collection) {
            if (csmNamespace == null || csmProject != null && csmNamespace.getProject() != csmProject) continue;
            linkedHashSet.add(csmNamespace);
        }
        return linkedHashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyResultImpl
    implements CompletionResolver.Result {
        private EmptyResultImpl() {
        }

        @Override
        public Collection<CsmVariable> getLocalVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmField> getClassFields() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getClassEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMethod> getClassMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmClassifier> getProjectClassesifiersEnums() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getFileLocalVars() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getFileLocalEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getFileLocalMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getFileLocalFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedProjectMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getGlobalVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getGlobalEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getGlobalProjectMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getGlobalProjectFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> getGlobalProjectNamespaces() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmClassifier> getLibClassifiersEnums() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedLibMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getLibMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getLibVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getLibEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getLibFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> getLibNamespaces() {
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends CsmObject> addResulItemsToCol(Collection<? extends CsmObject> collection) {
            return collection;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<CsmNamespaceAlias> getProjectNamespaceAliases() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespaceAlias> getLibNamespaceAliases() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmTemplateParameter> getTemplateparameters() {
            return Collections.emptyList();
        }

        public String toString() {
            return "<Empty Result>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResultImpl
    implements CompletionResolver.Result {
        private Collection<CsmVariable> localVars;
        private Collection<CsmField> classFields;
        private Collection<CsmEnumerator> classEnumerators;
        private Collection<CsmMethod> classMethods;
        private Collection<CsmClassifier> classesEnumsTypedefs;
        private Collection<CsmVariable> fileLocalVars;
        private Collection<CsmEnumerator> fileLocalEnumerators;
        private Collection<CsmMacro> fileLocalMacros;
        private Collection<CsmFunction> fileLocalFunctions;
        private Collection<CsmMacro> fileProjectMacros;
        private Collection<CsmVariable> globVars;
        private Collection<CsmEnumerator> globEnumerators;
        private Collection<CsmMacro> globProjectMacros;
        private Collection<CsmFunction> globFuns;
        private Collection<CsmNamespace> globProjectNSs;
        private Collection<CsmNamespaceAlias> projectNsAliases;
        private Collection<CsmClassifier> libClasses;
        private Collection<CsmMacro> fileLibMacros;
        private Collection<CsmMacro> globLibMacros;
        private Collection<CsmVariable> libVars;
        private Collection<CsmEnumerator> libEnumerators;
        private Collection<CsmFunction> libFuns;
        private Collection<CsmNamespace> libNSs;
        private Collection<CsmNamespaceAlias> libNsAliases;
        private Collection<CsmTemplateParameter> templateParameters;
        int size = -1;

        private ResultImpl() {
        }

        @Override
        public Collection<CsmVariable> getLocalVariables() {
            return CompletionResolverImpl.maskNull(this.localVars);
        }

        @Override
        public Collection<CsmField> getClassFields() {
            return CompletionResolverImpl.maskNull(this.classFields);
        }

        @Override
        public Collection<CsmEnumerator> getClassEnumerators() {
            return CompletionResolverImpl.maskNull(this.classEnumerators);
        }

        @Override
        public Collection<CsmMethod> getClassMethods() {
            return CompletionResolverImpl.maskNull(this.classMethods);
        }

        @Override
        public Collection<CsmClassifier> getProjectClassesifiersEnums() {
            return CompletionResolverImpl.maskNull(this.classesEnumsTypedefs);
        }

        @Override
        public Collection<CsmVariable> getFileLocalVars() {
            return CompletionResolverImpl.maskNull(this.fileLocalVars);
        }

        @Override
        public Collection<CsmEnumerator> getFileLocalEnumerators() {
            return CompletionResolverImpl.maskNull(this.fileLocalEnumerators);
        }

        @Override
        public Collection<CsmMacro> getFileLocalMacros() {
            return CompletionResolverImpl.maskNull(this.fileLocalMacros);
        }

        @Override
        public Collection<CsmFunction> getFileLocalFunctions() {
            return CompletionResolverImpl.maskNull(this.fileLocalFunctions);
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedProjectMacros() {
            return CompletionResolverImpl.maskNull(this.fileProjectMacros);
        }

        @Override
        public Collection<CsmVariable> getGlobalVariables() {
            return CompletionResolverImpl.maskNull(this.globVars);
        }

        @Override
        public Collection<CsmEnumerator> getGlobalEnumerators() {
            return CompletionResolverImpl.maskNull(this.globEnumerators);
        }

        @Override
        public Collection<CsmMacro> getGlobalProjectMacros() {
            return CompletionResolverImpl.maskNull(this.globProjectMacros);
        }

        @Override
        public Collection<CsmFunction> getGlobalProjectFunctions() {
            return CompletionResolverImpl.maskNull(this.globFuns);
        }

        @Override
        public Collection<CsmNamespace> getGlobalProjectNamespaces() {
            return CompletionResolverImpl.maskNull(this.globProjectNSs);
        }

        @Override
        public Collection<CsmNamespaceAlias> getProjectNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.projectNsAliases);
        }

        @Override
        public Collection<CsmClassifier> getLibClassifiersEnums() {
            return CompletionResolverImpl.maskNull(this.libClasses);
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedLibMacros() {
            return CompletionResolverImpl.maskNull(this.fileLibMacros);
        }

        @Override
        public Collection<CsmMacro> getLibMacros() {
            return CompletionResolverImpl.maskNull(this.globLibMacros);
        }

        @Override
        public Collection<CsmVariable> getLibVariables() {
            return CompletionResolverImpl.maskNull(this.libVars);
        }

        @Override
        public Collection<CsmEnumerator> getLibEnumerators() {
            return CompletionResolverImpl.maskNull(this.libEnumerators);
        }

        @Override
        public Collection<CsmFunction> getLibFunctions() {
            return CompletionResolverImpl.maskNull(this.libFuns);
        }

        @Override
        public Collection<CsmNamespace> getLibNamespaces() {
            return CompletionResolverImpl.maskNull(this.libNSs);
        }

        @Override
        public Collection<CsmNamespaceAlias> getLibNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.libNsAliases);
        }

        @Override
        public Collection<CsmTemplateParameter> getTemplateparameters() {
            return CompletionResolverImpl.maskNull(this.templateParameters);
        }

        @Override
        public Collection<? extends CsmObject> addResulItemsToCol(Collection<? extends CsmObject> collection) {
            assert (collection != null);
            return CompletionResolverImpl.appendResult(collection, this);
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                this.size += this.getLocalVariables().size();
                this.size += this.getClassFields().size();
                this.size += this.getClassEnumerators().size();
                this.size += this.getClassMethods().size();
                this.size += this.getProjectClassesifiersEnums().size();
                this.size += this.getFileLocalVars().size();
                this.size += this.getFileLocalEnumerators().size();
                this.size += this.getFileLocalMacros().size();
                this.size += this.getFileLocalFunctions().size();
                this.size += this.getInFileIncludedProjectMacros().size();
                this.size += this.getGlobalVariables().size();
                this.size += this.getGlobalEnumerators().size();
                this.size += this.getGlobalProjectMacros().size();
                this.size += this.getGlobalProjectFunctions().size();
                this.size += this.getGlobalProjectNamespaces().size();
                this.size += this.getLibClassifiersEnums().size();
                this.size += this.getInFileIncludedLibMacros().size();
                this.size += this.getLibMacros().size();
                this.size += this.getLibVariables().size();
                this.size += this.getLibEnumerators().size();
                this.size += this.getLibFunctions().size();
                this.size += this.getLibNamespaces().size();
                this.size += this.getTemplateparameters().size();
            }
            return this.size;
        }

        public String toString() {
            ArrayList arrayList = new ArrayList();
            this.addResulItemsToCol(arrayList);
            return ((Object)arrayList).toString();
        }
    }
}

