/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.AccessorImpl;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefactoringElementsBag {
    ArrayList<Transaction> commits;
    ArrayList<RefactoringElementImplementation> fileChanges;
    private final List<RefactoringElementImplementation> delegate;
    private final RefactoringSession session;
    private Collection<FileObject> readOnlyFiles = new HashSet<FileObject>();

    RefactoringElementsBag(RefactoringSession refactoringSession, List<RefactoringElementImplementation> list) {
        this.session = refactoringSession;
        this.delegate = list;
        this.commits = new ArrayList();
        this.fileChanges = new ArrayList();
    }

    public Problem add(AbstractRefactoring abstractRefactoring, RefactoringElementImplementation refactoringElementImplementation) {
        Problem problem = null;
        if (refactoringElementImplementation == null) {
            throw new NullPointerException();
        }
        if (this.isReadOnly(refactoringElementImplementation) && !(abstractRefactoring instanceof WhereUsedQuery)) {
            FileObject fileObject = refactoringElementImplementation.getParentFile();
            this.readOnlyFiles.add(fileObject);
            refactoringElementImplementation.setEnabled(false);
            refactoringElementImplementation.setStatus(3);
            this.delegate.add(refactoringElementImplementation);
        } else if (!(abstractRefactoring instanceof WhereUsedQuery) && this.isGuarded(refactoringElementImplementation)) {
            ArrayList<RefactoringElementImplementation> arrayList = new ArrayList<RefactoringElementImplementation>();
            ArrayList<Transaction> arrayList2 = new ArrayList<Transaction>();
            for (GuardedBlockHandler guardedBlockHandler : APIAccessor.DEFAULT.getGBHandlers(abstractRefactoring)) {
                refactoringElementImplementation.setEnabled(false);
                problem = APIAccessor.DEFAULT.chainProblems(guardedBlockHandler.handleChange(refactoringElementImplementation, arrayList, arrayList2), problem);
                if (problem != null && problem.isFatal()) {
                    return problem;
                }
                this.delegate.addAll(arrayList);
                for (Transaction transaction : arrayList2) {
                    this.registerTransaction(transaction);
                }
                if (arrayList.isEmpty() && arrayList2.isEmpty()) continue;
                return problem;
            }
            refactoringElementImplementation.setEnabled(false);
            refactoringElementImplementation.setStatus(2);
            this.delegate.add(refactoringElementImplementation);
        } else {
            this.delegate.add(refactoringElementImplementation);
        }
        return problem;
    }

    public Problem addAll(AbstractRefactoring abstractRefactoring, Collection<RefactoringElementImplementation> collection) {
        Problem problem = null;
        for (RefactoringElementImplementation refactoringElementImplementation : collection) {
            if ((problem = APIAccessor.DEFAULT.chainProblems(problem, this.add(abstractRefactoring, refactoringElementImplementation))) == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    public RefactoringSession getSession() {
        return this.session;
    }

    Collection<FileObject> getReadOnlyFiles() {
        return this.readOnlyFiles;
    }

    public void registerTransaction(Transaction transaction) {
        if (APIAccessor.DEFAULT.isCommit(this.session) && !this.commits.contains(transaction)) {
            this.commits.add(transaction);
        }
    }

    public Problem addFileChange(AbstractRefactoring abstractRefactoring, RefactoringElementImplementation refactoringElementImplementation) {
        if (APIAccessor.DEFAULT.isCommit(this.session)) {
            this.fileChanges.add(refactoringElementImplementation);
        }
        return null;
    }

    private boolean isReadOnly(RefactoringElementImplementation refactoringElementImplementation) {
        FileObject fileObject = refactoringElementImplementation.getParentFile();
        if (fileObject == null) {
            throw new NullPointerException("null parent file: " + refactoringElementImplementation.getClass().getName());
        }
        return !refactoringElementImplementation.getParentFile().canWrite();
    }

    private boolean isGuarded(RefactoringElementImplementation refactoringElementImplementation) {
        if (refactoringElementImplementation.getPosition() == null) {
            return false;
        }
        try {
            GuardedSectionManager guardedSectionManager;
            DataObject dataObject = DataObject.find((FileObject)refactoringElementImplementation.getParentFile());
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null && (guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)RefactoringElementsBag.openDocument(editorCookie))) != null) {
                Position position = refactoringElementImplementation.getPosition().getBegin().getPosition();
                Position position2 = refactoringElementImplementation.getPosition().getEnd().getPosition();
                for (GuardedSection guardedSection : guardedSectionManager.getGuardedSections()) {
                    if (!guardedSection.contains(position, true) && !guardedSection.contains(position2, true)) continue;
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return false;
    }

    private static StyledDocument openDocument(EditorCookie editorCookie) throws IOException {
        StyledDocument styledDocument;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (UserQuestionException userQuestionException) {
            if (userQuestionException.getMessage().startsWith("The file is too big.")) {
                userQuestionException.confirmed();
                styledDocument = editorCookie.openDocument();
            }
            throw userQuestionException;
        }
        return styledDocument;
    }

    static {
        SPIAccessor.DEFAULT = new AccessorImpl();
    }
}

