/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.awt.Shape;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.core.nativeaccess.transparency.WindowUtils;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;

public class NativeWindowSystemImpl
extends NativeWindowSystem {
    private static final Logger LOG = Logger.getLogger(NativeWindowSystemImpl.class.getName());

    public NativeWindowSystemImpl() {
        this.extractNativeLibrary();
    }

    public boolean isWindowAlphaSupported() {
        if (!NativeWindowSystemImpl.is32Bit()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = WindowUtils.isWindowAlphaSupported();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LOG.log(Level.FINE, null, unsatisfiedLinkError);
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
        return bl;
    }

    private static boolean is32Bit() {
        String string = System.getProperty("os.arch");
        for (String string2 : new String[]{"x86", "i386", "i486", "i586", "i686"}) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setWindowAlpha(Window window, float f) {
        try {
            WindowUtils.setWindowAlpha(window, f);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
    }

    public void setWindowMask(Window window, Shape shape) {
        try {
            WindowUtils.setWindowMask(window, shape);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
    }

    public void setWindowMask(Window window, Icon icon) {
        try {
            WindowUtils.setWindowMask(window, icon);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, null, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractNativeLibrary() {
        String string = System.getProperty("netbeans.user");
        if (null == string) {
            return;
        }
        File file = new File(new File(new File(string, "var"), "cache"), "jna");
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        if (!file.canWrite()) {
            return;
        }
        String string2 = System.mapLibraryName("jnidispatch");
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.name");
        File file2 = new File(file, string2);
        if (file2.exists() && file2.canRead()) {
            System.setProperty("jna.boot.library.path", file.getAbsolutePath());
            return;
        }
        String string5 = NativeWindowSystemImpl.getNativeLibraryResourcePath(string3, string4) + "/" + string2;
        URL uRL = Native.class.getResource(string5);
        if (uRL == null && Platform.isMac() && string5.endsWith(".dylib")) {
            string5 = string5.substring(0, string5.lastIndexOf(".dylib")) + ".jnilib";
            uRL = Native.class.getResource(string5);
        }
        if (uRL == null) {
            return;
        }
        if (!uRL.getProtocol().toLowerCase().equals("file")) {
            InputStream inputStream = Native.class.getResourceAsStream(string5);
            if (inputStream == null) {
                return;
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (file2.exists() && file2.canRead()) {
            System.setProperty("jna.boot.library.path", file.getAbsolutePath());
        }
    }

    static String getNativeLibraryResourcePath(String string, String string2) {
        String string3;
        string = string.toLowerCase();
        if (Platform.isWindows()) {
            if ("i386".equals(string)) {
                string = "x86";
            }
            string3 = "win32-" + string;
        } else if (Platform.isMac()) {
            string3 = "darwin";
        } else if (Platform.isLinux()) {
            if ("x86".equals(string)) {
                string = "i386";
            } else if ("x86_64".equals(string)) {
                string = "amd64";
            }
            string3 = "linux-" + string;
        } else if (Platform.isSolaris()) {
            string3 = "sunos-" + string;
        } else {
            int n;
            string3 = string2.toLowerCase();
            if ("x86".equals(string)) {
                string = "i386";
            }
            if ("x86_64".equals(string)) {
                string = "amd64";
            }
            if ("powerpc".equals(string)) {
                string = "ppc";
            }
            if ((n = string3.indexOf(" ")) != -1) {
                string3 = string3.substring(0, n);
            }
            string3 = string3 + "-" + string;
        }
        return "/com/sun/jna/" + string3;
    }
}

