/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class FindUsages {
    private static final Logger LOG = Logger.getLogger(FindUsages.class.getName());

    private FindUsages() {
    }

    public static boolean canFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return false;
        }
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        return RefactoringUtils.isRefactorable(fileObject) ? !RefactoringUtils.isOutsidePhp(lookup, fileObject) : false;
    }

    public static void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(editorCookie)) {
            FindUsagesTask.start(editorCookie);
        }
    }

    private static class FindUsagesTask
    extends UserTask {
        private JTextComponent textC;
        private int caret;
        private RefactoringUI ui;

        private FindUsagesTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            assert (this.caret != -1);
        }

        public static void start(EditorCookie editorCookie) {
            FindUsagesTask findUsagesTask = new FindUsagesTask(editorCookie);
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)editorCookie.getDocument())), (UserTask)findUsagesTask);
            }
            catch (ParseException parseException) {
                ErrorManager.getDefault().notify((Throwable)parseException);
                return;
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (findUsagesTask.ui != null) {
                UI.openRefactoringUI((RefactoringUI)findUsagesTask.ui, (TopComponent)topComponent);
            }
        }

        public void cancel() {
        }

        public void run(ResultIterator resultIterator) throws Exception {
            ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
            Program program = RefactoringUtils.getRoot(parserResult);
            if (program == null) {
                LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
                return;
            }
            WhereUsedSupport whereUsedSupport = WhereUsedSupport.getInstance(parserResult, this.caret);
            if (whereUsedSupport != null && whereUsedSupport.getName() != null) {
                this.ui = new WhereUsedQueryUI(whereUsedSupport, parserResult);
            }
        }
    }
}

