/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureNode;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewNode
extends BaseNode
implements SchemaNameProvider {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/view.gif";
    private static final String FOLDER = "View";
    private String name = "";
    private final MetadataElementHandle<View> viewHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ViewNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ViewNode viewNode = new ViewNode(nodeDataLookup, nodeProvider);
        viewNode.setup();
        return viewNode;
    }

    private ViewNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
        this.viewHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        View view = (View)ViewNode.this.viewHandle.resolve(metadata);
                        ViewNode.this.name = view.getName();
                        ViewNode.this.updateProperties(view);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        }
    }

    private void updateProperties(View view) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
    }

    @Override
    public String getCatalogName() {
        return ViewNode.getCatalogName(this.connection, this.viewHandle);
    }

    @Override
    public String getSchemaName() {
        return ViewNode.getSchemaName(this.connection, this.viewHandle);
    }

    @Override
    public void destroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        Specification specification = databaseConnector.getDatabaseSpecification();
        try {
            AbstractCommand abstractCommand = specification.createCommandDropView(this.getName());
            abstractCommand.execute();
            this.remove();
        }
        catch (DDLException dDLException) {
            Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, dDLException + " while deleting procedure " + this.getName());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        return databaseConnector.supportsCommand("DropViewCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.VIEW_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createViewData(ViewNode.this.connection.getDatabaseConnection(), ViewNode.this.connection.findJDBCDriver(), ViewNode.this.getName());
            }
        });
        return exTransferable;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ViewNode.class, (String)"ND_View");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ViewNode.class);
    }

    public static String getSchemaName(DatabaseConnection databaseConnection, final MetadataElementHandle<View> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    View view = (View)metadataElementHandle.resolve(metadata);
                    if (view != null) {
                        stringArray[0] = view.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            NodeRegistry.handleMetadataModelException(ViewNode.class, databaseConnection, metadataModelException, true);
        }
        return stringArray[0];
    }

    public static String getCatalogName(DatabaseConnection databaseConnection, final MetadataElementHandle<View> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    View view = (View)metadataElementHandle.resolve(metadata);
                    if (view != null) {
                        stringArray[0] = view.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            NodeRegistry.handleMetadataModelException(ViewNode.class, databaseConnection, metadataModelException, true);
        }
        return stringArray[0];
    }
}

