/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.CatalogNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class CatalogNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private CatalogNodeProvider(Lookup lookup) {
        super(lookup, new CatalogComparator());
    }

    protected synchronized void initialize() {
        boolean bl;
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        boolean bl2 = bl = !this.connection.getConnector().isDisconnected();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Collection collection = metadata.getCatalogs();
                        String string = metadata.getDefaultCatalog().getName();
                        for (Catalog catalog : collection) {
                            boolean bl;
                            boolean bl2;
                            boolean bl3 = bl2 = collection.size() == 1;
                            if (catalog.getName() == null && !bl2 || !(bl = true)) continue;
                            MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)catalog);
                            Collection collection2 = CatalogNodeProvider.this.getNodes(metadataElementHandle);
                            if (collection2.size() > 0) {
                                arrayList.addAll(collection2);
                                continue;
                            }
                            NodeDataLookup nodeDataLookup = new NodeDataLookup();
                            nodeDataLookup.add(CatalogNodeProvider.this.connection);
                            nodeDataLookup.add(metadataElementHandle);
                            arrayList.add(CatalogNode.create(nodeDataLookup, CatalogNodeProvider.this));
                        }
                        if (arrayList.size() == 1) {
                            CatalogNodeProvider.this.setProxyNodes(arrayList);
                        } else {
                            CatalogNodeProvider.this.setNodes(arrayList);
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        } else if (!bl) {
            this.setNodes(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatalogComparator
    implements Comparator<Node> {
        CatalogComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public CatalogNodeProvider createInstance(Lookup lookup) {
                CatalogNodeProvider catalogNodeProvider = new CatalogNodeProvider(lookup);
                return catalogNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

