/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.util.DatabaseExplorerInternalUIs;
import org.netbeans.modules.db.util.ErrorInfoPanel;
import org.netbeans.modules.db.util.JdbcUrl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends ConnectionDialog.FocusablePanel {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private Window window;
    private boolean updatingUrl = false;
    private boolean updatingFields = false;
    private boolean fieldEntryMode = true;
    private boolean userSpecifiedShowUrl = false;
    private final LinkedHashMap<String, UrlField> urlFields = new LinkedHashMap();
    private Set<String> knownConnectionNames = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(NewConnectionPanel.class.getName());
    private JTextField additionalPropsField;
    private JLabel additionalPropsLabel;
    private JTextField databaseField;
    private JLabel databaseLabel;
    private JRadioButton directInputCheckBox;
    private JTextArea directUrlField;
    private JLabel directUrlLabel;
    private JScrollPane directUrlScroll;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JTextField dsnField;
    private JLabel dsnLabel;
    private ErrorInfoPanel errorInfoPanel;
    private JRadioButton fieldInputCheckBox;
    private JTextField hostField;
    private JLabel hostLabel;
    private ButtonGroup inputModeButtonGroup;
    private JLabel inputModelLabel;
    private JTextField instanceField;
    private JLabel instanceLabel;
    private JPanel jPanel1;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField serverNameField;
    private JLabel serverNameLabel;
    private JTextField serviceField;
    private JLabel serviceLabel;
    private JCheckBox showUrlCheckBox;
    private JTextField sidField;
    private JLabel sidLabel;
    private JComboBox templateComboBox;
    private JLabel templateLabel;
    private JTextField tnsField;
    private JLabel tnsLabel;
    private JTextField urlField;
    private JTextField userField;
    private JLabel userLabel;

    private void initFieldMap() {
        this.urlFields.put("<HOST>", new UrlField(this.hostField, this.hostLabel));
        this.urlFields.put("<PORT>", new UrlField(this.portField, this.portLabel));
        this.urlFields.put("<DB>", new UrlField(this.databaseField, this.databaseLabel));
        this.urlFields.put("<SID>", new UrlField(this.sidField, this.sidLabel));
        this.urlFields.put("<SERVICE>", new UrlField(this.serviceField, this.serviceLabel));
        this.urlFields.put("<TNSNAME>", new UrlField(this.tnsField, this.tnsLabel));
        this.urlFields.put("<DSN>", new UrlField(this.dsnField, this.dsnLabel));
        this.urlFields.put("<SERVERNAME>", new UrlField(this.serverNameField, this.serverNameLabel));
        this.urlFields.put("<INSTANCE>", new UrlField(this.instanceField, this.instanceLabel));
        this.urlFields.put("<ADDITIONAL>", new UrlField(this.additionalPropsField, this.additionalPropsLabel));
    }

    public NewConnectionPanel(ConnectionDialogMediator connectionDialogMediator, String string, DatabaseConnection databaseConnection) {
        this.mediator = connectionDialogMediator;
        this.connection = databaseConnection;
        this.initComponents();
        this.initAccessibility();
        this.initFieldMap();
        this.errorInfoPanel.setup();
        DatabaseExplorerInternalUIs.connect(this.templateComboBox, JDBCDriverManager.getDefault(), string);
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                NewConnectionPanel.this.startProgress();
            }

            public void connectionStep(String string) {
                NewConnectionPanel.this.setProgressMessage(string);
            }

            public void connectionFinished() {
                NewConnectionPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                NewConnectionPanel.this.stopProgress(false);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
        this.userField.setText(databaseConnection.getUser());
        this.passwordField.setText(databaseConnection.getPassword());
        if (!databaseConnection.getDisplayName().equals(databaseConnection.getName())) {
            this.displayNameField.setText(databaseConnection.getDisplayName());
        }
        String string2 = databaseConnection.getDriver();
        String string3 = databaseConnection.getDriverName();
        if (string2 != null && string3 != null) {
            for (int i = 0; i < this.templateComboBox.getItemCount(); ++i) {
                Object entry = this.templateComboBox.getItemAt(i);
                if (!(entry instanceof JdbcUrl)) continue;
                JdbcUrl jdbcUrl = (JdbcUrl)entry;
                assert (jdbcUrl.getDriver() != null);
                if (!jdbcUrl.getClassName().equals(string2) || !jdbcUrl.getDriver().getName().equals(string3)) continue;
                this.templateComboBox.setSelectedIndex(i);
                break;
            }
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            new InputAdapter(entry.getValue().getField());
        }
        new InputAdapter(this.templateComboBox);
        new InputAdapter(this.directUrlField);
        this.urlField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                NewConnectionPanel.this.updateFieldsFromUrl();
            }
        });
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (NewConnectionPanel.this.urlField.hasFocus()) {
                    NewConnectionPanel.this.updateFieldsFromUrl();
                }
            }
        });
        this.urlField.setVisible(false);
        this.showUrlCheckBox.setSelected(false);
        this.fieldEntryMode = true;
        this.fieldInputCheckBox.setSelected(true);
        this.setUrlField();
        this.updateFieldsFromUrl();
        this.setUpFields();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewConnectionPanel.this.fireChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewConnectionPanel.this.fireChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NewConnectionPanel.this.fireChange();
            }
        };
        this.userField.getDocument().addDocumentListener(documentListener);
        this.passwordField.getDocument().addDocumentListener(documentListener);
        for (DatabaseConnection databaseConnection2 : ConnectionList.getDefault().getConnections()) {
            this.knownConnectionNames.add(databaseConnection2.getDisplayName());
        }
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    private void initAccessibility() {
        this.templateLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameA11yDesc"));
        this.templateComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverNameComboBoxA11yName"));
        this.displayNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameA11yDesc"));
        this.displayNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameTextFieldA11yName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.userField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordTextFieldA11yName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostTextFieldA11yName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortTextFieldA11yName"));
        this.serverNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameTextFieldA11yName"));
        this.serverNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.databaseField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameTextFieldA11yName"));
        this.databaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.additionalPropsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesTextFieldA11yName"));
        this.additionalPropsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.urlField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLTextFieldA11yName"));
        this.sidField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDTextFieldA11yName"));
        this.sidLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameTextFieldA11yName"));
        this.serviceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameTextFieldA11yName"));
        this.tnsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.dsnField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNTextFieldA11yName"));
        this.dsnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.instanceField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameTextFieldA11yName"));
        this.instanceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
    }

    public void initializeFocus() {
        this.setFocus();
    }

    private void initComponents() {
        this.inputModeButtonGroup = new ButtonGroup();
        this.showUrlCheckBox = new JCheckBox();
        this.templateComboBox = new JComboBox();
        this.hostField = new JTextField();
        this.templateLabel = new JLabel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.databaseLabel = new JLabel();
        this.databaseField = new JTextField();
        this.sidLabel = new JLabel();
        this.sidField = new JTextField();
        this.serviceLabel = new JLabel();
        this.serviceField = new JTextField();
        this.tnsLabel = new JLabel();
        this.tnsField = new JTextField();
        this.serverNameLabel = new JLabel();
        this.serverNameField = new JTextField();
        this.instanceLabel = new JLabel();
        this.instanceField = new JTextField();
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.dsnLabel = new JLabel();
        this.dsnField = new JTextField();
        this.additionalPropsLabel = new JLabel();
        this.additionalPropsField = new JTextField();
        this.urlField = new JTextField();
        this.passwordCheckBox = new JCheckBox();
        this.errorInfoPanel = new ErrorInfoPanel();
        this.inputModelLabel = new JLabel();
        this.fieldInputCheckBox = new JRadioButton();
        this.directInputCheckBox = new JRadioButton();
        this.directUrlLabel = new JLabel();
        this.directUrlScroll = new JScrollPane();
        this.directUrlField = new JTextArea();
        this.jPanel1 = new JPanel();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.showUrlCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionShowJDBCURL"));
        this.showUrlCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionShowJDBCURLAllyDesc"));
        this.showUrlCheckBox.setMargin(new Insets(3, 0, 1, 1));
        this.showUrlCheckBox.addActionListener(formListener);
        this.templateComboBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDriverClassComboBoxA11yDesc"));
        this.templateComboBox.addItemListener(formListener);
        this.templateComboBox.addActionListener(formListener);
        this.hostField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionHostA11yDesc"));
        this.templateLabel.setLabelFor(this.templateComboBox);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDriverName"));
        this.hostLabel.setLabelFor(this.hostField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionHost"));
        this.portLabel.setLabelFor(this.portField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPort"));
        this.portField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPortA11yDesc"));
        this.databaseLabel.setLabelFor(this.databaseField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDatabase"));
        this.databaseField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDatabaseNameA11yDesc"));
        this.sidLabel.setLabelFor(this.sidField);
        Mnemonics.setLocalizedText((JLabel)this.sidLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionSID"));
        this.sidField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionSIDA11yDesc"));
        this.serviceLabel.setLabelFor(this.serviceField);
        Mnemonics.setLocalizedText((JLabel)this.serviceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServiceName"));
        this.serviceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServiceNameA11yDesc"));
        this.tnsLabel.setLabelFor(this.tnsField);
        Mnemonics.setLocalizedText((JLabel)this.tnsLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionTNSName"));
        this.tnsField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionTNSNameA11yDesc"));
        this.serverNameLabel.setLabelFor(this.serverNameField);
        Mnemonics.setLocalizedText((JLabel)this.serverNameLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionServerName"));
        this.serverNameField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionServerNameA11yDesc"));
        this.instanceLabel.setLabelFor(this.instanceField);
        Mnemonics.setLocalizedText((JLabel)this.instanceLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionInstanceName"));
        this.instanceField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionInstanceNameA11yDesc"));
        this.displayNameLabel.setLabelFor(this.displayNameField);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDisplayName"));
        this.displayNameField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDisplayNameA11yDesc"));
        this.userLabel.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionUserName"));
        this.userField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionUserNameA11yDesc"));
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionPassword"));
        this.passwordField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionPasswordA11yDesc"));
        this.dsnLabel.setLabelFor(this.dsnField);
        Mnemonics.setLocalizedText((JLabel)this.dsnLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDSN"));
        this.dsnField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDSNA11yDesc"));
        this.additionalPropsLabel.setLabelFor(this.additionalPropsField);
        Mnemonics.setLocalizedText((JLabel)this.additionalPropsLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionAdditionalProperties"));
        this.additionalPropsField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionAdditionalPropertiesA11yDesc"));
        this.urlField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLA11yDesc"));
        this.urlField.addActionListener(formListener);
        this.urlField.addFocusListener(formListener);
        this.urlField.addKeyListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionRememberPasswordA11yDesc"));
        this.passwordCheckBox.setMargin(new Insets(3, 0, 1, 1));
        this.inputModelLabel.setLabelFor(this.fieldInputCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.inputModelLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewCOnnectionInputMode"));
        this.inputModeButtonGroup.add(this.fieldInputCheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.fieldInputCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionFieldEntryMode"));
        this.fieldInputCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionFieldEntryModeA11yDesc"));
        this.fieldInputCheckBox.addActionListener(formListener);
        this.inputModeButtonGroup.add(this.directInputCheckBox);
        Mnemonics.setLocalizedText((AbstractButton)this.directInputCheckBox, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDirectUrlEntryMode"));
        this.directInputCheckBox.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionDirectUrlEntryModeA11yDesc"));
        this.directInputCheckBox.addActionListener(formListener);
        this.directUrlLabel.setLabelFor(this.directUrlField);
        Mnemonics.setLocalizedText((JLabel)this.directUrlLabel, (String)NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDirectURL"));
        this.directUrlField.setColumns(20);
        this.directUrlField.setLineWrap(true);
        this.directUrlField.setRows(5);
        this.directUrlField.setToolTipText(NbBundle.getMessage(NewConnectionPanel.class, (String)"ACS_NewConnectionJDBCURLA11yDesc"));
        this.directUrlScroll.setViewportView(this.directUrlField);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 686, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 19, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.inputModelLabel).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.displayNameLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.showUrlCheckBox, -1, 132, Short.MAX_VALUE).add(1, (Component)this.directUrlLabel).add(1, (Component)this.templateLabel, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.passwordLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.userLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.instanceLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.serverNameLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.dsnLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.tnsLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.serviceLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.sidLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.databaseLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.portLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.hostLabel, -2, 121, -2)).add((Component)this.additionalPropsLabel, -2, 117, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.fieldInputCheckBox).add(18, 18, 18).add((Component)this.directInputCheckBox)).add((Component)this.passwordCheckBox, -2, 256, -2).add((Component)this.templateComboBox, 0, 550, Short.MAX_VALUE).add((Component)this.hostField, -1, 550, Short.MAX_VALUE).add((Component)this.portField, -1, 550, Short.MAX_VALUE).add((Component)this.databaseField, -1, 550, Short.MAX_VALUE).add((Component)this.sidField, -1, 550, Short.MAX_VALUE).add((Component)this.serviceField, -1, 550, Short.MAX_VALUE).add((Component)this.tnsField, -1, 550, Short.MAX_VALUE).add((Component)this.dsnField, -1, 550, Short.MAX_VALUE).add((Component)this.serverNameField, -1, 550, Short.MAX_VALUE).add((Component)this.instanceField, -1, 550, Short.MAX_VALUE).add((Component)this.userField, -1, 550, Short.MAX_VALUE).add((Component)this.passwordField, -1, 550, Short.MAX_VALUE).add((Component)this.displayNameField, -1, 550, Short.MAX_VALUE).add((Component)this.additionalPropsField, -1, 550, Short.MAX_VALUE).add((Component)this.urlField, -1, 550, Short.MAX_VALUE).add((Component)this.directUrlScroll, -1, 550, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.errorInfoPanel, -1, 686, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.inputModelLabel).add((Component)this.fieldInputCheckBox).add((Component)this.directInputCheckBox)).add(13, 13, 13).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.templateLabel).add((Component)this.templateComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.hostField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.databaseLabel).add((Component)this.databaseField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.sidLabel).add((Component)this.sidField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.serviceLabel).add((Component)this.serviceField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.tnsLabel).add((Component)this.tnsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.dsnLabel).add((Component)this.dsnField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.serverNameLabel).add((Component)this.serverNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.instanceLabel).add((Component)this.instanceField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.userField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.displayNameLabel).add((Component)this.displayNameField, -2, -1, -2)).addPreferredGap(0).add((Component)this.passwordCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.additionalPropsField, -2, -1, -2).add((Component)this.additionalPropsLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.showUrlCheckBox).add((Component)this.urlField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.directUrlLabel).add((Component)this.directUrlScroll, -2, 84, -2)).add(8, 8, 8).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.errorInfoPanel, -2, -1, -2).addContainerGap(138, Short.MAX_VALUE)));
    }

    private void urlFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void urlFieldFocusLost(FocusEvent focusEvent) {
    }

    private void urlFieldKeyPressed(KeyEvent keyEvent) {
    }

    private void templateComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void templateComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = this.templateComboBox.getSelectedItem();
            if (object != null && !(object instanceof JdbcUrl)) {
                return;
            }
            JdbcUrl jdbcUrl = (JdbcUrl)object;
            if (!jdbcUrl.isParseUrl()) {
                this.fieldInputCheckBox.setVisible(false);
                this.inputModelLabel.setVisible(false);
                this.directInputCheckBox.setVisible(false);
                if (this.fieldEntryMode) {
                    this.directInputCheckBox.setSelected(true);
                    this.updateInputMode(false);
                }
            } else {
                this.fieldInputCheckBox.setVisible(true);
                this.inputModelLabel.setVisible(true);
                this.directInputCheckBox.setVisible(true);
                this.directUrlField.setText("");
                this.setUpFields();
            }
            this.updateUrlFromFields();
            this.fireChange();
        }
    }

    private void fieldInputCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateInputMode(false);
    }

    private void directInputCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateInputMode(true);
    }

    private void showUrlCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.showUrl();
    }

    private void showUrl() {
        this.userSpecifiedShowUrl = this.showUrlCheckBox.isSelected();
        if (this.showUrlCheckBox.isSelected()) {
            this.updateUrlFromFields();
        }
        this.urlField.setVisible(this.showUrlCheckBox.isSelected());
        this.resize();
    }

    public void setConnectionInfo() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl != null) {
            JDBCDriver jDBCDriver = jdbcUrl.getDriver();
            assert (jDBCDriver != null);
            this.connection.setDriverName(jDBCDriver.getName());
            this.connection.setDriver(jDBCDriver.getClassName());
        }
        if (this.fieldEntryMode) {
            this.connection.setDatabase(this.urlField.getText());
        } else {
            this.connection.setDatabase(this.directUrlField.getText());
        }
        this.connection.setUser(this.userField.getText());
        this.connection.setPassword(this.getPassword());
        this.connection.setRememberPassword(this.passwordCheckBox.isSelected());
        this.connection.setDisplayName(this.displayNameField.getText());
    }

    private void resize() {
        this.revalidate();
        if (this.window != null) {
            this.window.pack();
        }
    }

    private void updateInputMode(boolean bl) {
        this.fieldEntryMode = this.fieldInputCheckBox.isSelected();
        if (bl) {
            this.directUrlField.setText(this.urlField.getText());
        }
        this.setUpFields();
    }

    private void setUpFields() {
        Object object = this.templateComboBox.getSelectedItem();
        if (object != null && !(object instanceof JdbcUrl)) {
            return;
        }
        JdbcUrl jdbcUrl = (JdbcUrl)object;
        if (jdbcUrl == null) {
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
            this.urlField.setVisible(false);
            this.checkValid();
            this.resize();
            return;
        }
        this.userField.setVisible(true);
        this.userLabel.setVisible(true);
        this.passwordField.setVisible(true);
        this.passwordLabel.setVisible(true);
        this.passwordCheckBox.setVisible(true);
        if (this.fieldEntryMode) {
            this.directUrlLabel.setVisible(false);
            this.directUrlScroll.setVisible(false);
            this.showUrlCheckBox.setVisible(true);
            this.urlField.setVisible(this.showUrlCheckBox.isSelected());
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(jdbcUrl.supportsToken(entry.getKey()));
                entry.getValue().getLabel().setVisible(jdbcUrl.supportsToken(entry.getKey()));
            }
            if (!jdbcUrl.isParseUrl()) {
                this.showUrlCheckBox.setEnabled(false);
                this.showUrlCheckBox.setSelected(true);
                this.urlField.setVisible(true);
                this.setUrlField();
            } else {
                this.showUrlCheckBox.setEnabled(true);
                this.showUrlCheckBox.setSelected(this.userSpecifiedShowUrl);
                this.showUrl();
            }
        } else {
            this.directUrlLabel.setVisible(true);
            this.directUrlScroll.setVisible(true);
            this.showUrlCheckBox.setVisible(false);
            this.urlField.setVisible(false);
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setVisible(false);
                entry.getValue().getLabel().setVisible(false);
            }
        }
        this.displayNameField.setVisible(true);
        this.displayNameLabel.setVisible(true);
        this.setFocus();
        this.checkValid();
        this.resize();
    }

    private void setFocus() {
        if (this.templateComboBox.getItemCount() <= 1) {
            this.templateComboBox.requestFocusInWindow();
            return;
        }
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            if (!entry.getValue().getField().isVisible()) continue;
            entry.getValue().getField().requestFocusInWindow();
            return;
        }
        this.userField.requestFocusInWindow();
    }

    private JdbcUrl getSelectedJdbcUrl() {
        Object object = this.templateComboBox.getSelectedItem();
        if (!(object instanceof JdbcUrl)) {
            return null;
        }
        return (JdbcUrl)object;
    }

    private void setUrlField() {
        if (!this.connection.getDatabase().equals("")) {
            this.urlField.setText(this.connection.getDatabase());
            return;
        }
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null) {
            this.urlField.setText("");
            return;
        }
        if (jdbcUrl.isParseUrl()) {
            this.updateUrlFromFields();
        } else {
            this.urlField.setText(jdbcUrl.getUrlTemplate());
        }
    }

    private String getPassword() {
        String string = new String(this.passwordField.getPassword());
        String string2 = string.length() > 0 ? string : null;
        return string2;
    }

    public String getTitle() {
        return NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnectionDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewConnectionPanel.this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NewConnectionPanel.class, (String)"ConnectionProgress_Connecting"));
                NewConnectionPanel.this.progressHandle.start();
                NewConnectionPanel.this.enableInput(false);
            }
        });
    }

    private void setProgressMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.setDisplayName(string);
                }
            }
        });
    }

    public void terminateProgress() {
        this.stopProgress(false);
    }

    private void stopProgress(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NewConnectionPanel.this.progressHandle != null) {
                    NewConnectionPanel.this.progressHandle.finish();
                    NewConnectionPanel.this.enableInput(true);
                }
            }
        });
    }

    private void enableInput(boolean bl) {
        this.displayNameField.setEnabled(bl);
        this.fieldInputCheckBox.setEnabled(bl);
        this.directInputCheckBox.setEnabled(bl);
        this.templateComboBox.setEnabled(bl);
        this.userField.setEnabled(bl);
        this.passwordField.setEnabled(bl);
        this.passwordCheckBox.setEnabled(bl);
        this.showUrlCheckBox.setEnabled(bl);
        this.urlField.setEnabled(bl);
        this.directUrlField.setEnabled(bl);
        for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
            entry.getValue().getField().setEnabled(bl);
        }
    }

    private void resetProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.setDisplayName("");
        }
    }

    private void fireChange() {
        this.mediator.closeConnection();
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }

    private void updateUrlFromFields() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null || !jdbcUrl.isParseUrl()) {
            return;
        }
        if (!this.updatingUrl) {
            this.updatingFields = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                jdbcUrl.put(entry.getKey(), entry.getValue().getField().getText());
            }
            this.urlField.setText(jdbcUrl.getUrl());
            this.updatingFields = false;
        }
        this.checkValid();
    }

    private void checkValid() {
        if (this.fieldEntryMode) {
            JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
            boolean bl = false;
            if (jdbcUrl == null) {
                this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SelectADriver"), false);
            } else if (jdbcUrl != null && jdbcUrl.isParseUrl()) {
                for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                    if (!jdbcUrl.requiresToken(entry.getKey()) || !this.isEmpty(entry.getValue().getField().getText())) continue;
                    bl = true;
                    this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.ERR_FieldRequired", (Object)entry.getValue().getLabel().getText()), false);
                }
                if (!bl) {
                    this.clearError();
                }
            } else if (this.isEmpty(this.urlField.getText())) {
                this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SpecifyURL"), false);
            } else {
                this.clearError();
            }
        } else if (this.directUrlField.getText().trim().length() > 0) {
            this.clearError();
        } else {
            this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_SpecifyURL"), false);
        }
        if (this.knownConnectionNames.contains(this.displayNameField.getText().trim())) {
            this.displayError(NbBundle.getMessage(NewConnectionPanel.class, (String)"NewConnection.MSG_DuplicateDisplayName"), false);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private void updateFieldsFromUrl() {
        JdbcUrl jdbcUrl = this.getSelectedJdbcUrl();
        if (jdbcUrl == null) {
            return;
        }
        if (this.updatingFields) {
            return;
        }
        try {
            jdbcUrl.setUrl(this.urlField.getText());
            this.clearError();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.FINE, null, malformedURLException);
        }
        if (jdbcUrl.isParseUrl()) {
            this.updatingUrl = true;
            for (Map.Entry<String, UrlField> entry : this.urlFields.entrySet()) {
                entry.getValue().getField().setText((String)jdbcUrl.get(entry.getKey()));
            }
            this.updatingUrl = false;
        }
    }

    private void clearError() {
        this.errorInfoPanel.clear();
        this.mediator.setValid(true);
    }

    private void displayError(String string, boolean bl) {
        this.errorInfoPanel.set(string, bl);
        this.mediator.setValid(false);
    }

    private class InputAdapter
    implements DocumentListener,
    ListDataListener {
        public InputAdapter(JTextField jTextField) {
            jTextField.getDocument().addDocumentListener(this);
        }

        public InputAdapter(JComboBox jComboBox) {
            jComboBox.getModel().addListDataListener(this);
        }

        public InputAdapter(JTextArea jTextArea) {
            jTextArea.getDocument().addDocumentListener(this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            NewConnectionPanel.this.fireChange();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            NewConnectionPanel.this.fireChange();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            NewConnectionPanel.this.updateUrlFromFields();
            NewConnectionPanel.this.checkValid();
            NewConnectionPanel.this.fireChange();
        }
    }

    private class UrlField {
        private final JTextField field;
        private final JLabel label;

        public UrlField(JTextField jTextField, JLabel jLabel) {
            this.field = jTextField;
            this.label = jLabel;
        }

        public JTextField getField() {
            return this.field;
        }

        public JLabel getLabel() {
            return this.label;
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ItemListener,
    KeyListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NewConnectionPanel.this.showUrlCheckBox) {
                NewConnectionPanel.this.showUrlCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.fieldInputCheckBox) {
                NewConnectionPanel.this.fieldInputCheckBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == NewConnectionPanel.this.directInputCheckBox) {
                NewConnectionPanel.this.directInputCheckBoxActionPerformed(actionEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldFocusLost(focusEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == NewConnectionPanel.this.templateComboBox) {
                NewConnectionPanel.this.templateComboBoxItemStateChanged(itemEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == NewConnectionPanel.this.urlField) {
                NewConnectionPanel.this.urlFieldKeyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

