/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddViewDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class CreateViewAction
extends BaseAction {
    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        boolean bl = false;
        DatabaseConnection databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class);
        if (databaseConnection != null) {
            bl = DatabaseConnection.isVitalConnection(databaseConnection.getConnection(), databaseConnection);
        }
        return bl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateViewAction.class);
    }

    public void performAction(Node[] nodeArray) {
        final BaseNode baseNode = (BaseNode)((Object)nodeArray[0].getLookup().lookup(BaseNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CreateViewAction.this.perform(baseNode);
            }
        });
    }

    private void perform(BaseNode baseNode) {
        DatabaseConnection databaseConnection = (DatabaseConnection)baseNode.getLookup().lookup(DatabaseConnection.class);
        String string = CreateViewAction.findSchemaWorkingName(baseNode.getLookup());
        try {
            boolean bl = databaseConnection.getConnector().getDriverSpecification(string).areViewsSupported();
            if (!bl) {
                String string2 = NbBundle.getMessage(CreateViewAction.class, (String)"MSG_ViewsAreNotSupported", (Object)databaseConnection.getConnection().getMetaData().getDatabaseProductName().trim());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 1));
                return;
            }
            Specification specification = databaseConnection.getConnector().getDatabaseSpecification();
            boolean bl2 = AddViewDialog.showDialogAndCreate(specification, string);
            if (bl2) {
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{baseNode});
            }
        }
        catch (Exception exception) {
            DbUtilities.reportError(NbBundle.getMessage(CreateViewAction.class, (String)"ERR_UnableToCreateView"), exception.getMessage());
        }
    }

    public String getName() {
        return NbBundle.getMessage(CreateViewAction.class, (String)"AddView");
    }
}

