/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseUILogger;
import org.netbeans.modules.db.explorer.DbDriverManager;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.OpenConnection;
import org.netbeans.modules.db.explorer.OpenConnectionInterface;
import org.netbeans.modules.db.explorer.action.ConnectAction;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.netbeans.modules.db.explorer.node.DDLHelper;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnection
implements DBConnection {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnection.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    static final long serialVersionUID = 4554639187416958735L;
    private final Set<ExceptionListener> exceptionListeners = Collections.synchronizedSet(new HashSet());
    private Connection con;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String defaultCatalog = null;
    private String defaultSchema = null;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private PropertyChangeSupport propertySupport;
    private String name;
    private String displayName;
    private int errorCode = -1;
    private DatabaseConnector connector = new DatabaseConnector(this);
    private MetadataModel metadataModel = null;
    private transient org.netbeans.api.db.explorer.DatabaseConnection dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_REMEMBER_PASSWORD = "rememberpwd";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DEFSCHEMA = "defaultSchema";
    public static final String PROP_DEFCATALOG = "defaultCatalog";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final int DERBY_UNICODE_ERROR_CODE = 20000;
    private OpenConnectionInterface openConnection = null;
    private volatile JDBCDriver jdbcdrv = null;
    private JDBCDriver[] drivers = null;
    private static final Lookup.Result<OpenConnectionInterface> openConnectionLookupResult;
    private static Collection<? extends OpenConnectionInterface> openConnectionServices;

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4) {
        this(string, null, string2, null, string3, string4, false);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, false);
    }

    public DatabaseConnection(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this();
        this.drv = string;
        this.drvname = string2;
        this.db = string3;
        this.usr = string5;
        this.schema = string4;
        this.pwd = string6;
        this.name = this.getName();
        this.rpwd = bl;
    }

    public JDBCDriver findJDBCDriver() {
        Object[] objectArray = JDBCDriverManager.getDefault().getDrivers(this.drv);
        if (this.drivers == null || !Arrays.equals(objectArray, this.drivers)) {
            this.drivers = objectArray;
            if (objectArray.length <= 0) {
                return null;
            }
            Object object = objectArray[0];
            for (int i = 0; i < objectArray.length; ++i) {
                if (!((JDBCDriver)objectArray[i]).getName().equals(this.getDriverName())) continue;
                object = objectArray[i];
                break;
            }
            this.jdbcdrv = object;
        }
        return this.jdbcdrv;
    }

    public Connection getJDBCConnection(boolean bl) {
        Connection connection = this.getJDBCConnection();
        if (bl && !DatabaseConnection.test(connection, this.getName())) {
            try {
                this.disconnect();
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.FINE, null, databaseException);
            }
            return null;
        }
        return connection;
    }

    public void setMetadataModel(MetadataModel metadataModel) {
        this.metadataModel = metadataModel;
    }

    public MetadataModel getMetadataModel() {
        return this.metadataModel;
    }

    public static boolean isVitalConnection(Connection connection, DatabaseConnection databaseConnection) {
        if (connection == null) {
            return false;
        }
        try {
            SQLWarning sQLWarning = connection.getWarnings();
            if (LOGGER.isLoggable(Level.FINE) && sQLWarning != null) {
                LOGGER.log(Level.FINE, "Warnings while trying vitality of connection: " + sQLWarning);
            }
            return !connection.isClosed();
        }
        catch (SQLException sQLException) {
            if (databaseConnection != null) {
                try {
                    databaseConnection.disconnect();
                }
                catch (DatabaseException databaseException) {
                    LOGGER.log(Level.FINE, "While trying vitality of connection: " + databaseException.getLocalizedMessage(), databaseException);
                }
            }
            LOGGER.log(Level.FINE, "While trying vitality of connection: " + sQLException.getLocalizedMessage(), sQLException);
            return false;
        }
    }

    public static boolean test(Connection connection, String string) {
        try {
            if (!DatabaseConnection.isVitalConnection(connection, null)) {
                return false;
            }
            connection.getMetaData().getTables(null, null, " ", new String[]{"TABLE"}).close();
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(DatabaseConnection.class, (String)"MSG_TestFailed", (Object)string, (Object)sQLException.getMessage()));
            LOGGER.log(Level.FINE, null, sQLException);
            return false;
        }
        return true;
    }

    private Collection<? extends OpenConnectionInterface> getOpenConnections() {
        if (openConnectionServices == null) {
            openConnectionServices = openConnectionLookupResult.allInstances();
        }
        return openConnectionServices;
    }

    private OpenConnectionInterface getOpenConnection() {
        if (this.openConnection != null) {
            return this.openConnection;
        }
        this.openConnection = new OpenConnection();
        String string = this.getDriver();
        if (string == null) {
            return this.openConnection;
        }
        try {
            for (OpenConnectionInterface openConnectionInterface : this.getOpenConnections()) {
                if (!openConnectionInterface.isFor(string)) continue;
                this.openConnection = openConnectionInterface;
                break;
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        return this.openConnection;
    }

    @Override
    public String getDriver() {
        return this.drv;
    }

    @Override
    public void setDriver(String string) {
        if (string == null || string.equals(this.drv)) {
            return;
        }
        String string2 = this.drv;
        this.drv = string;
        this.propertySupport.firePropertyChange(PROP_DRIVER, string2, this.drv);
        this.openConnection = null;
    }

    @Override
    public String getDriverName() {
        return this.drvname;
    }

    @Override
    public void setDriverName(String string) {
        if (string == null || string.equals(this.drvname)) {
            return;
        }
        String string2 = this.drvname;
        this.drvname = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, string2, this.drvname);
        }
    }

    @Override
    public String getDatabase() {
        if (this.db == null) {
            this.db = "";
        }
        return this.db;
    }

    @Override
    public void setDatabase(String string) {
        if (string == null || string.equals(this.db)) {
            return;
        }
        String string2 = this.db;
        this.db = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, string2, this.db);
        }
    }

    @Override
    public String getUser() {
        if (this.usr == null) {
            this.usr = "";
        }
        return this.usr;
    }

    @Override
    public void setUser(String string) {
        if (string == null || string.equals(this.usr)) {
            return;
        }
        String string2 = this.usr;
        this.usr = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, string2, this.usr);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? NbBundle.getMessage(DatabaseConnection.class, (String)"ConnectionNodeUniqueName", (Object)this.getDatabase(), (Object)this.getUser(), (Object)NbBundle.getMessage(DatabaseConnection.class, (String)"SchemaIsNotSet")) : NbBundle.getMessage(DatabaseConnection.class, (String)"ConnectionNodeUniqueName", (Object)this.getDatabase(), (Object)this.getUser(), (Object)this.getSchema());
        }
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (this.name == null || this.name.equals(string)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, string2, this.name);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null && this.displayName.length() > 0 ? this.displayName : this.getName();
    }

    @Override
    public void setDisplayName(String string) {
        if (this.displayName == null && string == null || this.displayName != null && this.displayName.equals(string)) {
            return;
        }
        String string2 = this.displayName;
        this.displayName = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DISPLAY_NAME, string2, this.displayName);
        }
    }

    @Override
    public String getSchema() {
        if (this.schema == null) {
            this.schema = "";
        }
        return this.schema;
    }

    @Override
    public void setSchema(String string) {
        if (string == null || string.equals(this.schema)) {
            return;
        }
        String string2 = this.schema;
        this.schema = string;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, string2, this.schema);
        }
    }

    public void setDefaultCatalog(String string) throws Exception {
        DDLHelper.setDefaultDatabase(this.getConnector().getDatabaseSpecification(), string);
        String string2 = this.defaultCatalog;
        this.defaultCatalog = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DEFCATALOG, string2, this.defaultCatalog);
        }
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultSchema(String string) throws Exception {
        DDLHelper.setDefaultSchema(this.getConnector().getDatabaseSpecification(), string);
        String string2 = this.defaultSchema;
        this.defaultSchema = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DEFSCHEMA, string2, this.defaultSchema);
        }
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public boolean rememberPassword() {
        return this.rpwd;
    }

    @Override
    public void setRememberPassword(boolean bl) {
        Boolean bl2 = this.rpwd;
        this.rpwd = bl;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_REMEMBER_PASSWORD, bl2, this.rpwd);
        }
    }

    @Override
    public String getPassword() {
        return this.pwd;
    }

    @Override
    public void setPassword(String string) {
        if (string == null || string.equals(this.pwd)) {
            return;
        }
        String string2 = this.pwd;
        if (string.length() == 0) {
            string = null;
        }
        this.pwd = string;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, string2, this.pwd);
        }
    }

    @Override
    public Connection createJDBCConnection() throws DDLException {
        if (LOG) {
            LOGGER.log(Level.FINE, "createJDBCConnection()");
        }
        if (this.drv == null || this.db == null || this.usr == null) {
            throw new DDLException(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_InsufficientConnInfo"));
        }
        Properties properties = new Properties();
        if (this.usr != null && this.usr.length() > 0) {
            properties.put(PROP_USER, this.usr);
            properties.put(PROP_PASSWORD, this.pwd);
        }
        try {
            this.propertySupport.firePropertyChange("connecting", null, null);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver jDBCDriver = this.findJDBCDriver();
            if (jDBCDriver == null) {
                Class.forName(this.drv);
            }
            Connection connection = DbDriverManager.getDefault().getConnection(this.db, properties, jDBCDriver);
            this.setConnection(connection);
            DatabaseUILogger.logConnection(this.drv);
            this.propertySupport.firePropertyChange("connected", null, null);
            this.getOpenConnection().disable();
            return connection;
        }
        catch (SQLException sQLException) {
            String string = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)sQLException.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            this.initSQLException(sQLException);
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(sQLException);
            throw dDLException;
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)exception.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(exception);
            throw dDLException;
        }
    }

    public void connectSync() throws DatabaseException {
        try {
            this.doConnect();
        }
        catch (Exception exception) {
            try {
                if (this.getConnection() != null) {
                    this.getConnection().close();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.FINE, null, sQLException);
            }
            throw new DatabaseException(exception);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() throws DDLException {
        if (this.drv == null || this.db == null || this.usr == null) {
            this.sendException(new DDLException(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_InsufficientConnInfo")));
        }
        Properties properties = new Properties();
        if (this.usr.length() > 0) {
            properties.put(PROP_USER, this.usr);
        }
        if (this.pwd != null && this.pwd.length() > 0) {
            properties.put(PROP_PASSWORD, this.pwd);
        }
        Connection connection = null;
        try {
            this.propertySupport.firePropertyChange("connecting", null, null);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver jDBCDriver = this.findJDBCDriver();
            if (jDBCDriver == null) {
                Class.forName(this.drv);
            }
            connection = DbDriverManager.getDefault().getConnection(this.db, properties, jDBCDriver);
            this.setConnection(connection);
            DatabaseUILogger.logConnection(this.drv);
            this.propertySupport.firePropertyChange("connected", null, null);
        }
        catch (Exception exception) {
            String string = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)exception.getMessage());
            if (this.drv.equals(DRIVER_CLASS_NET) && exception instanceof SQLException) {
                this.errorCode = ((SQLException)exception).getErrorCode();
                if (this.errorCode == 20000) {
                    string = MessageFormat.format(NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_DerbyCreateDatabaseUnicode"), string, this.db);
                }
            }
            this.propertySupport.firePropertyChange("failed", null, null);
            if (exception instanceof SQLException) {
                this.initSQLException((SQLException)exception);
            }
            DDLException dDLException = new DDLException(string);
            dDLException.initCause(exception);
            if (connection != null) {
                this.setConnection(null);
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger("global").log(Level.WARNING, null, sQLException);
                }
            }
            throw dDLException;
        }
        catch (Throwable throwable) {
            String string = NbBundle.getMessage(DatabaseConnection.class, (String)"EXC_CannotEstablishConnection", (Object)this.db, (Object)this.drv, (Object)throwable.getMessage());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception(throwable, (Object)string));
            this.propertySupport.firePropertyChange("failed", null, null);
        }
        finally {
            this.getOpenConnection().disable();
        }
    }

    public RequestProcessor.Task connectAsync() {
        if (LOG) {
            LOGGER.log(Level.FINE, "connect()");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DatabaseConnection.this.doConnect();
                }
                catch (Exception exception) {
                    DatabaseConnection.this.sendException(exception);
                }
            }
        };
        RequestProcessor.Task task = RequestProcessor.getDefault().post(runnable, 0);
        return task;
    }

    private void initSQLException(SQLException sQLException) {
        SQLException sQLException2 = sQLException.getNextException();
        while (sQLException2 != null) {
            try {
                sQLException.initCause(sQLException2);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            sQLException = sQLException2;
            sQLException2 = sQLException.getNextException();
        }
    }

    private void startRuntimes() {
        DatabaseRuntime[] databaseRuntimeArray = DatabaseRuntimeManager.getDefault().getRuntimes(this.drv);
        for (int i = 0; i < databaseRuntimeArray.length; ++i) {
            DatabaseRuntime databaseRuntime = databaseRuntimeArray[i];
            if (databaseRuntime.isRunning() || !databaseRuntime.canStart() || !databaseRuntime.acceptsDatabaseURL(this.db)) continue;
            databaseRuntime.start();
        }
    }

    public void addExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener != null) {
            this.exceptionListeners.add(exceptionListener);
        }
    }

    public void removeExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListeners.remove(exceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(Exception exception) {
        ArrayList<ExceptionListener> arrayList = new ArrayList<ExceptionListener>();
        Set<ExceptionListener> set = this.exceptionListeners;
        synchronized (set) {
            for (ExceptionListener exceptionListener : this.exceptionListeners) {
                arrayList.add(exceptionListener);
            }
        }
        for (ExceptionListener exceptionListener : arrayList) {
            exceptionListener.exceptionOccurred(exception);
        }
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public int hashCode() {
        return this.drv.hashCode() + this.db.hashCode() + this.usr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DBConnection) {
            DBConnection dBConnection = (DBConnection)object;
            return this.toString().equals(dBConnection.toString());
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.drv = (String)objectInputStream.readObject();
        this.db = (String)objectInputStream.readObject();
        this.usr = (String)objectInputStream.readObject();
        this.schema = (String)objectInputStream.readObject();
        this.rpwd = Boolean.FALSE;
        this.name = (String)objectInputStream.readObject();
        try {
            this.drvname = (String)objectInputStream.readObject();
            this.displayName = (String)objectInputStream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
        this.dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.drv);
        objectOutputStream.writeObject(this.db);
        objectOutputStream.writeObject(this.usr);
        objectOutputStream.writeObject(this.schema);
        objectOutputStream.writeObject(SUPPORT);
        objectOutputStream.writeObject(this.drvname);
        objectOutputStream.writeObject(this.displayName);
    }

    public String toString() {
        return "Driver:" + this.getDriver() + "Database:" + this.getDatabase().toLowerCase() + "User:" + this.getUser().toLowerCase() + "Schema:" + this.getSchema().toLowerCase();
    }

    public org.netbeans.api.db.explorer.DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public void selectInExplorer() {
        Node[] nodeArray;
        TopComponent topComponent3;
        TopComponent topComponent2 = null;
        ExplorerManager explorerManager = null;
        for (TopComponent topComponent3 : TopComponent.getRegistry().getOpened()) {
            if (!topComponent3.getClass().getName().equals("org.netbeans.core.ide.ServicesTab")) continue;
            topComponent2 = topComponent3;
            assert (topComponent2 instanceof ExplorerManager.Provider);
            explorerManager = ((ExplorerManager.Provider)topComponent2).getExplorerManager();
            break;
        }
        if (explorerManager == null) {
            return;
        }
        Node node = explorerManager.getRootContext();
        topComponent3 = null;
        Node node2 = null;
        for (Node node3 : nodeArray = node.getChildren().getNodes()) {
            if (!node3.getName().equals("Databases")) continue;
            topComponent3 = node3;
            break;
        }
        if (topComponent3 == null) {
            return;
        }
        for (Node node3 : nodeArray = topComponent3.getChildren().getNodes()) {
            if (!node3.getName().equals(this.getName())) continue;
            node2 = node3;
            break;
        }
        try {
            if (node2 != null) {
                explorerManager.setSelectedNodes(new Node[]{node2});
                topComponent2.requestActive();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
            return;
        }
    }

    public void showConnectionDialog() {
        try {
            ConnectionNode connectionNode = DatabaseConnection.findConnectionNode(this.getName());
            if (connectionNode != null && connectionNode.getDatabaseConnection().getConnector().isDisconnected()) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        new ConnectAction.ConnectionDialogDisplayer().showDialog(DatabaseConnection.this, false);
                    }
                });
            }
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
    }

    public Connection getJDBCConnection() {
        return this.connector.getConnection();
    }

    public DatabaseConnector getConnector() {
        return this.connector;
    }

    public void notifyChange() {
        this.propertySupport.firePropertyChange("changed", null, null);
    }

    public void fireConnectionComplete() {
        this.propertySupport.firePropertyChange("connectionComplete", null, null);
    }

    public void disconnect() throws DatabaseException {
        this.connector.performDisconnect();
        this.propertySupport.firePropertyChange("disconnected", null, null);
    }

    public static ConnectionNode findConnectionNode(String string) throws DatabaseException {
        assert (string != null);
        RootNode rootNode = RootNode.instance();
        Collection<? extends Node> collection = rootNode.getChildNodes();
        for (Node node : collection) {
            ConnectionNode connectionNode;
            if (!(node instanceof ConnectionNode) || !(connectionNode = (ConnectionNode)node).getName().equals(string)) continue;
            return connectionNode;
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        return this;
    }

    static {
        openConnectionServices = null;
        openConnectionLookupResult = Lookup.getDefault().lookup(new Lookup.Template(OpenConnectionInterface.class));
        openConnectionLookupResult.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Class<DatabaseConnection> clazz = DatabaseConnection.class;
                synchronized (DatabaseConnection.class) {
                    openConnectionServices = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

