/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.netbeans.modules.tomcat5.Base64;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.SContext;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TomcatManagerImpl
implements ProgressObject,
Runnable {
    private static RequestProcessor rp;
    private ProgressEventSupport pes;
    private String command;
    private String output;
    private CommandType cmdType;
    private InputStream istream;
    private TomcatManager tm;
    private boolean authorized;
    private TomcatModule tmId;
    private static final Logger LOGGER;

    private static synchronized RequestProcessor rp() {
        if (rp == null) {
            rp = new RequestProcessor("Tomcat management", 1);
        }
        return rp;
    }

    public TomcatManagerImpl(TomcatManager tomcatManager) {
        this.tm = tomcatManager;
        this.pes = new ProgressEventSupport(this);
    }

    public void deploy(Target target, InputStream inputStream, InputStream inputStream2) {
        Context context;
        try {
            context = Context.createGraph(inputStream2);
        }
        catch (RuntimeException runtimeException) {
            String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.FAILED));
            return;
        }
        String string = context.getAttributeValue("path");
        this.tmId = new TomcatModule(target, string);
        this.command = "deploy?path=" + TomcatManagerImpl.encodePath(this.tmId.getPath());
        this.cmdType = CommandType.DISTRIBUTE;
        String string2 = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string2, StateType.RUNNING));
        this.istream = inputStream;
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void install(Target target, File file, File file2) {
        String string = file.toURI().toASCIIString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (file.isFile()) {
            string = "jar:" + string + "!/";
        }
        String string2 = null;
        try {
            Object object;
            if (!file2.exists()) {
                string2 = file.isDirectory() ? "/" + file.getName() : "/" + file.getName().substring(0, file.getName().lastIndexOf(46));
                this.tmId = new TomcatModule(target, string2);
                this.command = "deploy?update=true&path=" + TomcatManagerImpl.encodePath(string2) + "&war=" + string;
            } else {
                Context context;
                object = new FileInputStream(file2);
                try {
                    context = Context.createGraph((InputStream)object);
                }
                catch (RuntimeException runtimeException) {
                    String string3 = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string3, StateType.FAILED));
                    return;
                }
                string2 = file.isDirectory() ? "/" + file.getName() : "/" + file.getName().substring(0, file.getName().lastIndexOf(46));
                string2 = context.getAttributeValue("path");
                this.tmId = new TomcatModule(target, string2);
                this.command = "deploy?update=true&path=" + TomcatManagerImpl.encodePath(this.tmId.getPath()) + "&war=" + string;
            }
            this.cmdType = CommandType.DISTRIBUTE;
            object = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, (String)object, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, fileNotFoundException.getLocalizedMessage(), StateType.FAILED));
        }
    }

    public void initialDeploy(Target target, File file, File file2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Context context = Context.createGraph(fileInputStream);
            String string = file2.getAbsoluteFile().toURI().toASCIIString();
            String string2 = file2.getAbsolutePath();
            String string3 = context.getAttributeValue("path");
            this.tmId = new TomcatModule(target, string3, string2);
            String string4 = this.createTempContextXml(string2, context);
            this.command = this.tm.isTomcat50() ? "deploy?config=" + string4 + "&war=" + string : "deploy?config=" + string4 + "&path=" + TomcatManagerImpl.encodePath(this.tmId.getPath());
            this.cmdType = CommandType.DISTRIBUTE;
            String string5 = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeploymentInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string5, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (IOException iOException) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, iOException.getLocalizedMessage(), StateType.FAILED));
        }
        catch (RuntimeException runtimeException) {
            String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.FAILED));
        }
    }

    public void remove(TomcatModule tomcatModule) {
        Object object;
        Server server = this.tm.getRoot();
        if (server != null && this.removeContextFromServer(server, tomcatModule.getPath())) {
            object = null;
            try {
                object = this.tm.getTomcatProperties().getServerXml();
                server.write((File)object);
            }
            catch (Exception exception) {
                this.pes.fireHandleProgressEvent(tomcatModule, new Status(ActionType.EXECUTE, CommandType.UNDEPLOY, NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ServerXml_RO", (Object)((File)object).getAbsolutePath()), StateType.FAILED));
                return;
            }
        }
        this.tmId = tomcatModule;
        this.command = "undeploy?path=" + TomcatManagerImpl.encodePath(tomcatModule.getPath());
        this.cmdType = CommandType.UNDEPLOY;
        object = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_UndeploymentInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, (String)object, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    private boolean removeContextFromServer(Server server, String string) {
        Host[] hostArray;
        Engine engine;
        Service[] serviceArray;
        if (string.equals("/")) {
            string = "";
        }
        if ((serviceArray = server.getService()).length > 0 && (engine = serviceArray[0].getEngine()) != null && (hostArray = engine.getHost()).length > 0) {
            SContext[] sContextArray = hostArray[0].getSContext();
            for (int i = 0; i < sContextArray.length; ++i) {
                if (!sContextArray[i].getAttributeValue("path").equals(string)) continue;
                hostArray[0].removeSContext(sContextArray[i]);
                return true;
            }
        }
        return false;
    }

    public void start(TomcatModule tomcatModule) {
        this.tmId = tomcatModule;
        this.command = "start?path=" + TomcatManagerImpl.encodePath(tomcatModule.getPath());
        this.cmdType = CommandType.START;
        String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_StartInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void stop(TomcatModule tomcatModule) {
        this.tmId = tomcatModule;
        this.command = "stop?path=" + TomcatManagerImpl.encodePath(tomcatModule.getPath());
        this.cmdType = CommandType.STOP;
        String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_StopInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void reload(TomcatModule tomcatModule) {
        this.tmId = tomcatModule;
        this.command = "reload?path=" + TomcatManagerImpl.encodePath(tomcatModule.getPath());
        this.cmdType = CommandType.REDEPLOY;
        String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ReloadInProgress");
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.RUNNING));
        TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
    }

    public void incrementalRedeploy(TomcatModule tomcatModule) {
        try {
            this.tmId = tomcatModule;
            String string = tomcatModule.getDocRoot();
            assert (string != null);
            String string2 = new File(string).toURI().toASCIIString();
            File file = new File(string + "/META-INF/context.xml");
            FileInputStream fileInputStream = new FileInputStream(file);
            Context context = Context.createGraph(fileInputStream);
            String string3 = this.createTempContextXml(string, context);
            this.command = this.tm.isTomcat50() ? "deploy?config=" + string3 + "&war=" + string2 : "deploy?config=" + string3 + "&path=" + TomcatManagerImpl.encodePath(tomcatModule.getPath());
            this.cmdType = CommandType.DISTRIBUTE;
            String string4 = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployInProgress");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string4, StateType.RUNNING));
            TomcatManagerImpl.rp().post((Runnable)this, 0, 5);
        }
        catch (IOException iOException) {
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, iOException.getLocalizedMessage(), StateType.FAILED));
        }
        catch (RuntimeException runtimeException) {
            String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_DeployBrokenContextXml");
            this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.FAILED));
            return;
        }
    }

    private static String encodePath(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (!stringTokenizer.hasMoreTokens()) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append("/").append(URLEncoder.encode(stringTokenizer.nextToken(), "UTF-8"));
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private String createTempContextXml(String string, Context context) throws IOException {
        Object object;
        File file = File.createTempFile("context", ".xml");
        file.deleteOnExit();
        if (!string.equals(context.getAttributeValue("docBase"))) {
            context.setAttributeValue("docBase", string);
            object = new FileOutputStream(file);
            context.write((OutputStream)object);
            ((FileOutputStream)object).close();
        }
        object = file.toURI().toURL();
        String string2 = URLEncoder.encode(((URL)object).toString(), "UTF-8");
        return string2;
    }

    TargetModuleID[] list(Target target, int n) throws IllegalStateException {
        this.command = "list";
        this.run();
        if (!this.authorized) {
            String string = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_AuthorizationFailed");
            IllegalStateException illegalStateException = new IllegalStateException(string);
            throw (IllegalStateException)illegalStateException.initCause(new AuthorizationException());
        }
        ArrayList<TomcatModule> arrayList = new ArrayList<TomcatModule>();
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(this.output, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
            try {
                String string2 = stringTokenizer2.nextToken();
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                String string5 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string5 = string.substring(string2.length() + string3.length() + string4.length() + 3);
                }
                if ("running".equals(string3) && (n == 0 || n == 1)) {
                    arrayList.add(new TomcatModule(target, string2, string5));
                }
                if (!"stopped".equals(string3) || n != 0 && n != 2) continue;
                arrayList.add(new TomcatModule(target, string2, string5));
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
        }
        return arrayList.toArray(new TargetModuleID[arrayList.size()]);
    }

    public String jmxProxy(String string) {
        this.command = "jmxproxy/" + string;
        this.run();
        return this.output;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.pes.getDeploymentStatus();
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.tmId};
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported in Tomcat deployment");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported in Tomcat deployment");
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.pes.addProgressListener(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.pes.removeProgressListener(progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        LOGGER.log(Level.FINE, this.command);
        this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, this.command, StateType.RUNNING));
        this.output = "";
        this.authorized = true;
        int n = 4;
        URLConnection uRLConnection = null;
        InputStreamReader inputStreamReader = null;
        URL uRL = null;
        boolean bl = false;
        String string = null;
        while (n >= 0) {
            --n;
            try {
                int n2;
                Object object;
                CharSequence charSequence;
                Object object2;
                String string2 = this.tm.getPlainUri();
                String string3 = (string2 + this.command).replaceAll(" ", "%20");
                uRL = new URL(string3);
                if (Boolean.getBoolean("org.netbeans.modules.tomcat5.LogManagerCommands")) {
                    object2 = "Tomcat 5 sending manager command: " + uRL;
                    Logger.getLogger(TomcatManagerImpl.class.getName()).log(Level.FINE, null, new Exception((String)object2));
                }
                uRLConnection = uRL.openConnection();
                object2 = (HttpURLConnection)uRLConnection;
                ((URLConnection)object2).setAllowUserInteraction(false);
                ((URLConnection)object2).setDoInput(true);
                ((URLConnection)object2).setUseCaches(false);
                if (this.istream != null) {
                    ((URLConnection)object2).setDoOutput(true);
                    ((HttpURLConnection)object2).setRequestMethod("PUT");
                    ((URLConnection)object2).setRequestProperty("Content-Type", "application/octet-stream");
                } else {
                    ((URLConnection)object2).setDoOutput(false);
                    ((HttpURLConnection)object2).setRequestMethod("GET");
                }
                ((URLConnection)object2).setRequestProperty("User-Agent", "NetBeansIDE-Tomcat-Manager/1.0");
                TomcatProperties tomcatProperties = this.tm.getTomcatProperties();
                String string4 = tomcatProperties.getUsername() + ":" + tomcatProperties.getPassword();
                String string5 = new String(Base64.encode(string4.getBytes()));
                ((URLConnection)object2).setRequestProperty("Authorization", "Basic " + string5);
                ((URLConnection)object2).connect();
                int n3 = ((HttpURLConnection)object2).getResponseCode();
                if (n3 == 401 || n3 == 403) {
                    this.authorized = false;
                    charSequence = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_AuthorizationFailed");
                    this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.cmdType, (String)charSequence, StateType.FAILED));
                    return;
                }
                if (Boolean.getBoolean("org.netbeans.modules.tomcat5.LogManagerCommands")) {
                    int n4 = ((HttpURLConnection)object2).getResponseCode();
                    object = "Tomcat 5 receiving response, code: " + n4;
                    System.out.println((String)object);
                    Logger.getLogger(TomcatManagerImpl.class.getName()).log(Level.INFO, null, new Exception((String)object));
                }
                if (this.istream != null) {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((URLConnection)object2).getOutputStream(), 1024);
                    object = new byte[1024];
                    while ((n2 = this.istream.read((byte[])object)) >= 0) {
                        bufferedOutputStream.write((byte[])object, 0, n2);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    this.istream.close();
                }
                inputStreamReader = new InputStreamReader(((URLConnection)object2).getInputStream(), "UTF-8");
                n = -1;
                charSequence = new StringBuffer();
                object = null;
                string = null;
                int n5 = n2 = !this.command.startsWith("jmxproxy") ? 1 : 0;
                while (true) {
                    int n6;
                    if ((n6 = inputStreamReader.read()) < 0) break;
                    if (n6 == 13 || n6 == 10) {
                        String string6 = ((StringBuffer)charSequence).toString();
                        ((StringBuffer)charSequence).setLength(0);
                        LOGGER.log(Level.FINE, string6);
                        if (n2 != 0) {
                            String string7 = "\u6210\u529f";
                            string = string6;
                            if (string6.indexOf("java.lang.ThreadDeath") != -1) {
                                String string8 = NbBundle.getMessage(TomcatManagerImpl.class, (String)"MSG_ThreadDeathWarning");
                                this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, string8, StateType.RUNNING));
                            } else if (!string6.startsWith("OK -") && !string6.startsWith(string7)) {
                                object = string6;
                            }
                            n2 = 0;
                        }
                        this.output = this.output + string6 + "\n";
                        continue;
                    }
                    ((StringBuffer)charSequence).append((char)n6);
                }
                this.output = this.output + ((StringBuffer)charSequence).toString() + "\n";
                if (((StringBuffer)charSequence).length() > 0) {
                    LOGGER.log(Level.FINE, ((StringBuffer)charSequence).toString());
                }
                if (object != null) {
                    LOGGER.log(Level.INFO, "TomcatManagerImpl connecting to: " + uRL, object);
                    this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, (String)object, StateType.FAILED));
                    bl = true;
                }
                if (string == null) {
                    string = ((StringBuffer)charSequence).toString();
                }
            }
            catch (Exception exception) {
                if (n < 0) {
                    LOGGER.log(Level.INFO, "TomcatManagerImpl connecting to: " + uRL, exception);
                    this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, exception.getLocalizedMessage(), StateType.FAILED));
                    bl = true;
                }
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                    inputStreamReader = null;
                }
                if (this.istream != null) {
                    try {
                        this.istream.close();
                    }
                    catch (IOException iOException) {}
                    this.istream = null;
                }
            }
            if (n < 0) continue;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!bl) {
            this.pes.fireHandleProgressEvent(this.tmId, new Status(ActionType.EXECUTE, this.cmdType, string, StateType.COMPLETED));
        }
    }

    static {
        LOGGER = Logger.getLogger(TomcatManagerImpl.class.getName());
    }
}

