/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.config.HgConfigFiles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgRepositoryContextCache {
    private Map<File, DefaultPaths> rootToDefaultPaths;
    private static HgRepositoryContextCache instance;

    private HgRepositoryContextCache() {
    }

    public static HgRepositoryContextCache getInstance() {
        if (instance == null) {
            instance = new HgRepositoryContextCache();
        }
        return instance;
    }

    public synchronized void reset() {
        this.getRootToDefaultPaths().clear();
    }

    public synchronized String getPullDefault(File file) {
        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
        if (file2 == null) {
            return null;
        }
        DefaultPaths defaultPaths = this.getDefaultPaths(file2);
        return defaultPaths.pull;
    }

    public synchronized String getPushDefault(File file) {
        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
        if (file2 == null) {
            return null;
        }
        DefaultPaths defaultPaths = this.getDefaultPaths(file2);
        return defaultPaths.push;
    }

    private DefaultPaths getDefaultPaths(File file) {
        Map<File, DefaultPaths> map = this.getRootToDefaultPaths();
        DefaultPaths defaultPaths = map.get(file);
        if (defaultPaths == null) {
            HgConfigFiles hgConfigFiles = new HgConfigFiles(file);
            String string = hgConfigFiles.getDefaultPull(true);
            String string2 = hgConfigFiles.getDefaultPush(true);
            defaultPaths = new DefaultPaths(string, string2);
            map.put(file, defaultPaths);
        }
        return defaultPaths;
    }

    private Map<File, DefaultPaths> getRootToDefaultPaths() {
        if (this.rootToDefaultPaths == null) {
            this.rootToDefaultPaths = new HashMap<File, DefaultPaths>();
        }
        return this.rootToDefaultPaths;
    }

    private static class DefaultPaths {
        String pull;
        String push;

        public DefaultPaths(String string, String string2) {
            this.pull = string;
            this.push = string2;
        }
    }
}

