/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.wizards.CloneDestinationDirectoryPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class CloneDestinationDirectoryWizardPanel
implements WizardDescriptor.Panel,
DocumentListener {
    private CloneDestinationDirectoryPanel component;
    private boolean valid;
    private String errorMessage;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public Component getComponent() {
        if (this.component == null) {
            this.component = new CloneDestinationDirectoryPanel();
            this.component.directoryField.getDocument().addDocumentListener(this);
            this.component.nameField.getDocument().addDocumentListener(this);
            this.valid();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(CloneDestinationDirectoryWizardPanel.class);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void textChanged(final DocumentEvent documentEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (documentEvent.getDocument() == ((CloneDestinationDirectoryWizardPanel)CloneDestinationDirectoryWizardPanel.this).component.nameField.getDocument() || documentEvent.getDocument() == ((CloneDestinationDirectoryWizardPanel)CloneDestinationDirectoryWizardPanel.this).component.directoryField.getDocument()) {
                    if (CloneDestinationDirectoryWizardPanel.this.component.isInputValid()) {
                        CloneDestinationDirectoryWizardPanel.this.valid(CloneDestinationDirectoryWizardPanel.this.component.getMessage());
                    } else {
                        CloneDestinationDirectoryWizardPanel.this.invalid(CloneDestinationDirectoryWizardPanel.this.component.getMessage());
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String string) {
        this.setValid(true, string);
    }

    protected final void invalid(String string) {
        this.setValid(false, string);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private void setValid(boolean bl, String string) {
        boolean bl2 = this.valid != bl;
        boolean bl3 = string != null && !string.equals(this.errorMessage);
        this.valid = bl;
        this.errorMessage = string;
        if (bl2 |= bl3) {
            this.fireChangeEvent();
        }
    }

    public void readSettings(Object object) {
        if (object instanceof WizardDescriptor) {
            HgURL hgURL = (HgURL)((WizardDescriptor)object).getProperty("repository");
            this.component.nameField.setText(new File(hgURL.getPath()).getName());
        }
    }

    public void storeSettings(Object object) {
        if (object instanceof WizardDescriptor) {
            String string = this.component.getDirectory();
            String string2 = this.component.getCloneName();
            ((WizardDescriptor)object).putProperty("directory", (Object)new File(string));
            ((WizardDescriptor)object).putProperty("cloneName", (Object)string2);
        }
    }
}

