/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CloneDestinationDirectoryPanel
extends JPanel
implements ActionListener {
    private String message;
    private JPanel destinationDirectoryPanel;
    private JButton directoryBrowseButton;
    final JTextField directoryField = new JTextField();
    private JLabel directoryLabel;
    private JLabel jLabel1;
    final JTextField nameField = new JTextField();
    private JLabel nameLabel;
    final JCheckBox scanForProjectsCheckBox = new JCheckBox();

    public CloneDestinationDirectoryPanel() {
        this.initComponents();
        this.directoryBrowseButton.addActionListener(this);
        this.scanForProjectsCheckBox.addActionListener(this);
        this.directoryField.setText(this.defaultWorkingDirectory().getPath());
        this.scanForProjectsCheckBox.setSelected(HgModuleConfig.getDefault().getShowCloneCompleted());
    }

    public String getName() {
        if (this.destinationDirectoryPanel == null) {
            return null;
        }
        return this.destinationDirectoryPanel.getName();
    }

    public String getDirectory() {
        return this.directoryField.getText();
    }

    public String getCloneName() {
        return this.nameField.getText();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isInputValid() {
        String string;
        String string2 = this.directoryField.getText();
        File file = new File(string2, string = this.nameField.getText());
        if (file.exists()) {
            this.message = NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"MSG_TARGET_EXISTS");
            return false;
        }
        this.message = "";
        return true;
    }

    private void initComponents() {
        this.destinationDirectoryPanel = new JPanel();
        this.directoryLabel = new JLabel();
        this.directoryBrowseButton = new JButton();
        this.nameLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.destinationDirectoryPanel.setName(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"destinationDirectoryPanel.Name"));
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryLabel.Name"));
        this.directoryField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CloneDestinationDirectoryPanel.this.directoryFieldActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.directoryBrowseButton, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryBrowseButton.Name"));
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"nameLabel.Name"));
        this.scanForProjectsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scanForProjectsCheckBox, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"CTL_Scan_After_Clone"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"directoryTitleLabel.Name"));
        GroupLayout groupLayout = new GroupLayout((Container)this.destinationDirectoryPanel);
        this.destinationDirectoryPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.nameLabel, -1, -1, Short.MAX_VALUE).add((Component)this.directoryLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.nameField, -1, 424, Short.MAX_VALUE).add((Component)this.directoryField, -1, 424, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.directoryBrowseButton)).add((Component)this.scanForProjectsCheckBox).add((Component)this.jLabel1, -2, 597, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.directoryLabel, -1, -1, Short.MAX_VALUE).add((Component)this.directoryBrowseButton).add((Component)this.directoryField, -2, -1, -2)).add(28, 28, 28).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameField, -2, -1, -2).add((Component)this.nameLabel)).add(18, 18, 18).add((Component)this.scanForProjectsCheckBox, -2, 32, -2).add(75, 75, 75)));
        this.scanForProjectsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"ACSD_Scan_After_Clone"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.destinationDirectoryPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.destinationDirectoryPanel, -2, -1, -2).addContainerGap(62, Short.MAX_VALUE)));
    }

    private void directoryFieldActionPerformed(ActionEvent actionEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.directoryBrowseButton) {
            this.onBrowseClick();
        } else if (actionEvent.getSource() == this.scanForProjectsCheckBox) {
            HgModuleConfig.getDefault().setShowCloneCompleted(this.scanForProjectsCheckBox.isSelected());
        }
    }

    private void onBrowseClick() {
        File file = this.defaultWorkingDirectory();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"Folders");
            }
        });
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this, NbBundle.getMessage(CloneDestinationDirectoryPanel.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.directoryField.setText(file2.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File file;
        File file2 = null;
        String string = this.directoryField.getText();
        if (string != null && !string.trim().equals("")) {
            for (file = new File(string); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                file2 = file.isFile() ? file.getParentFile() : file;
            }
        }
        if (file2 == null && (file = ProjectChooser.getProjectsFolder()).exists() && file.isDirectory()) {
            file2 = file;
        }
        if (file2 == null) {
            file2 = new File(System.getProperty("user.home"));
        }
        return file2;
    }
}

