/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPanel;
import org.netbeans.modules.mercurial.ui.rollback.Backout;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BackoutPanel
extends JPanel {
    private File repository;
    private RequestProcessor.Task refreshViewTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialBackout", 1);
    private Thread refreshViewThread;
    private RepositoryRevision repoRev;
    private HgLogMessage[] messages;
    private int fetchRevisionLimit = 7;
    private boolean bGettingRevisions = false;
    File[] roots;
    private ChangesetPanel changesetPanel1;
    private JLabel commitLabel;
    private JTextField commitMsgField;
    private JCheckBox doMergeChxBox;
    private JLabel infoLabel;
    private JLabel infoLabel2;
    private JPanel jPanel1;
    private JComboBox revisionsComboBox;
    private JLabel revisionsLabel;

    public BackoutPanel(File file, RepositoryRevision repositoryRevision, File[] fileArray) {
        this.repoRev = repositoryRevision;
        this.roots = fileArray;
        this.repository = file;
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.initComponents();
        this.revisionsComboBox.setMaximumRowCount(10);
        this.commitMsgField.setText(NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.commitMsgField.text") + " {revision}");
        this.refreshViewTask.schedule(0);
        if (repositoryRevision != null) {
            Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(BackoutPanel.class, (String)"CTL_ChoosenRevision"));
        }
    }

    public String getSelectedRevision() {
        String string = (String)this.revisionsComboBox.getSelectedItem();
        if (string != null) {
            string = string.equals(NbBundle.getMessage(Backout.class, (String)"MSG_Revision_Default")) || string.equals(NbBundle.getMessage(Backout.class, (String)"MSG_Fetching_Revisions")) ? null : string.substring(0, string.indexOf(" "));
        }
        return string;
    }

    public String getCommitMessage() {
        return this.commitMsgField.getText();
    }

    public boolean isMergeRequested() {
        return this.doMergeChxBox.isSelected();
    }

    private void initComponents() {
        this.doMergeChxBox = new JCheckBox();
        this.revisionsLabel = new JLabel();
        this.revisionsComboBox = new JComboBox();
        this.infoLabel = new JLabel();
        this.infoLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.commitMsgField = new JTextField();
        this.commitLabel = new JLabel();
        this.changesetPanel1 = new ChangesetPanel();
        this.doMergeChxBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.doMergeChxBox, (String)NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.doMergeChxBox.text"));
        this.doMergeChxBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackoutPanel.this.doMergeChxBoxActionPerformed(actionEvent);
            }
        });
        this.revisionsLabel.setLabelFor(this.revisionsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.revisionsLabel.text"));
        this.revisionsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackoutPanel.this.revisionsComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.infoLabel.text"));
        this.infoLabel2.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.infoLabel2, (String)NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.infoLabel2.text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BackoutPanel.class, (String)"StripPanel.jPanel1.border.title")));
        this.commitMsgField.setText(NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.commitMsgField.text"));
        this.commitLabel.setLabelFor(this.commitMsgField);
        Mnemonics.setLocalizedText((JLabel)this.commitLabel, (String)NbBundle.getMessage(BackoutPanel.class, (String)"BackoutPanel.commitLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.commitLabel).addPreferredGap(0).add((Component)this.commitMsgField, -1, 275, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.commitLabel).add((Component)this.commitMsgField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.commitMsgField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BackoutPanel.class, (String)"ACSD_commitMsgField"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.infoLabel2).add(1, (Component)this.infoLabel, -1, 421, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(40, 40, 40).add((Component)this.revisionsLabel).addPreferredGap(0).add((Component)this.revisionsComboBox, 0, 247, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.changesetPanel1, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.infoLabel, -2, 25, -2).add(4, 4, 4).add((Component)this.infoLabel2).add(18, 18, 18).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.revisionsComboBox, -2, 27, -2).add((Component)this.revisionsLabel)).addPreferredGap(0).add((Component)this.changesetPanel1, -2, 152, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 56, -2)));
        this.revisionsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BackoutPanel.class, (String)"ACSD_revisionsComboBoxBackout"));
    }

    private void doMergeChxBoxActionPerformed(ActionEvent actionEvent) {
        if (this.doMergeChxBox.isSelected()) {
            this.commitMsgField.setEnabled(true);
            this.commitMsgField.setEditable(true);
            this.commitLabel.setEnabled(true);
        } else {
            this.commitMsgField.setEnabled(false);
            this.commitMsgField.setEditable(false);
            this.commitLabel.setEnabled(false);
        }
    }

    private void revisionsComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.revisionsComboBox.getSelectedIndex();
        if (this.getMore((String)this.revisionsComboBox.getSelectedItem())) {
            return;
        }
        if (this.messages != null && n >= 0 && n < this.messages.length) {
            this.changesetPanel1.setInfo(this.messages[n]);
        }
    }

    private boolean getMore(String string) {
        if (this.bGettingRevisions) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"))) {
            bl = true;
            n = 20;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"))) {
            bl = true;
            n = 50;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"))) {
            bl = true;
            n = -1;
        }
        if (bl && !this.bGettingRevisions) {
            this.fetchRevisionLimit = n;
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.repository);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    BackoutPanel.this.changesetPanel1.clearInfo();
                    BackoutPanel.this.refreshRevisions();
                }
            };
            hgProgressSupport.start(requestProcessor, this.repository, NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetching_Revisions"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupModels() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Backout.class, (String)"MSG_Refreshing_Backout_Versions"));
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (this.repoRev != null) {
                linkedHashSet.add(this.repoRev.getLog().getRevision() + " (" + this.repoRev.getLog().getCSetShortID() + ")");
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
                this.changesetPanel1.setInfo(this.repoRev.getLog());
                this.revisionsComboBox.setModel(defaultComboBoxModel);
                this.revisionsComboBox.setEditable(false);
                this.refreshViewThread = Thread.currentThread();
                Thread.interrupted();
                progressHandle.start();
            } else {
                linkedHashSet.add(NbBundle.getMessage(Backout.class, (String)"MSG_Fetching_Revisions"));
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
                this.revisionsComboBox.setModel(defaultComboBoxModel);
                this.refreshViewThread = Thread.currentThread();
                Thread.interrupted();
                progressHandle.start();
                this.refreshRevisions();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            SwingUtilities.invokeLater(new Runnable(progressHandle){
                final /* synthetic */ ProgressHandle val$ph;
                {
                    this.val$ph = progressHandle;
                }

                public void run() {
                    this.val$ph.finish();
                    BackoutPanel.this.refreshViewThread = null;
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void refreshRevisions() {
        this.bGettingRevisions = true;
        OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(this.roots));
        this.messages = HgCommand.getLogMessagesNoFileInfo(this.repository, hashSet, this.fetchRevisionLimit, outputLogger);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.messages == null) {
            boolean bl = false;
            linkedHashSet.add(NbBundle.getMessage(Backout.class, (String)"MSG_Revision_Default"));
        } else {
            int n = this.messages.length;
            for (int i = 0; i < n; ++i) {
                linkedHashSet.add(this.messages[i].getRevision() + " (" + this.messages[i].getCSetShortID() + ")");
            }
        }
        if (linkedHashSet.size() > 0) {
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"));
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
        this.revisionsComboBox.setModel(defaultComboBoxModel);
        if (linkedHashSet.size() > 0) {
            this.revisionsComboBox.setSelectedIndex(0);
        }
        this.bGettingRevisions = false;
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            BackoutPanel.this.setupModels();
        }
    }
}

