/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.rollback.Backout;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BackoutAction
extends ContextAction {
    private final VCSContext context;
    private static final String HG_BACKOUT_REVISION_REPLACE = "\\{revision}";
    public static final String HG_BACKOUT_REVISION = " {revision}";
    private static String HG_TIP = "tip";

    public BackoutAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        BackoutAction.backout(this.context);
    }

    public static void backout(VCSContext vCSContext) {
        BackoutAction.backout(vCSContext, null);
    }

    public static void backout(RepositoryRevision repositoryRevision) {
        BackoutAction.backout(null, repositoryRevision);
    }

    public static void backout(VCSContext vCSContext, RepositoryRevision repositoryRevision) {
        Object object;
        File file;
        File[] fileArray;
        File[] fileArray2 = fileArray = vCSContext != null ? vCSContext.getFiles().toArray(new File[0]) : null;
        if (repositoryRevision != null) {
            file = repositoryRevision.getRepositoryRoot();
            if (file == null || file.getPath().equals("")) {
                return;
            }
        } else {
            object = HgUtils.getActionRoots(vCSContext);
            if (object == null || ((File[])object).length == 0) {
                return;
            }
            file = Mercurial.getInstance().getRepositoryRoot(object[0]);
        }
        if (file == null) {
            return;
        }
        object = null;
        String string = null;
        Backout backout = new Backout(file, repositoryRevision, fileArray);
        if (!backout.showDialog()) {
            return;
        }
        object = backout.getSelectionRevision();
        if (object == null) {
            object = HG_TIP;
        }
        string = backout.getCommitMessage();
        Object object2 = object;
        String string2 = string = string.replaceAll(HG_BACKOUT_REVISION_REPLACE, (String)object2);
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport((String)object2, file, string2, vCSContext, repositoryRevision){
            final /* synthetic */ String val$revStr;
            final /* synthetic */ File val$root;
            final /* synthetic */ String val$commitMsgStr;
            final /* synthetic */ VCSContext val$ctx;
            final /* synthetic */ RepositoryRevision val$repoRev;
            {
                this.val$revStr = string;
                this.val$root = file;
                this.val$commitMsgStr = string2;
                this.val$ctx = vCSContext;
                this.val$repoRev = repositoryRevision;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                OutputLogger outputLogger;
                block15: {
                    block17: {
                        block16: {
                            outputLogger = this.getLogger();
                            try {
                                try {
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE"));
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_TITLE_SEP"));
                                    outputLogger.output(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_INFO_SEP", (Object)this.val$revStr, (Object)this.val$root.getAbsolutePath()));
                                    List<String> list = HgCommand.doBackout(this.val$root, this.val$revStr, false, this.val$commitMsgStr, outputLogger);
                                    if (list == null || list.isEmpty()) break block15;
                                    boolean bl = HgCommand.isBackoutMergeNeededMsg(list.get(list.size() - 1));
                                    if (bl) {
                                        list.remove(list.size() - 1);
                                        list.remove(list.size() - 1);
                                    }
                                    outputLogger.output(list);
                                    if (HgCommand.isUncommittedChangesBackout(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_UNCOMMITTED_CHANGES_BACKOUT"));
                                        Object var7_6 = null;
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                        outputLogger.output("");
                                        Mercurial.getInstance().versionedFilesChanged();
                                        return;
                                    }
                                    if (HgCommand.isMergeChangesetBackout(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_MERGE_CSET_BACKOUT", (Object)this.val$revStr));
                                        break block16;
                                    }
                                    if (HgCommand.isNoRevStrip(list.get(0))) {
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_NO_REV_BACKOUT", (Object)this.val$revStr));
                                        break block17;
                                    }
                                    boolean bl2 = false;
                                    if (bl) {
                                        bl2 = HgUtils.confirmDialog(BackoutAction.class, "MSG_BACKOUT_MERGE_CONFIRM_TITLE", "MSG_BACKOUT_MERGE_CONFIRM_QUERY");
                                    }
                                    if (bl2) {
                                        outputLogger.output("");
                                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_MERGE_DO"));
                                        MergeAction.doMergeAction(this.val$root, null, outputLogger);
                                    } else {
                                        List<String> list2 = HgCommand.getHeadRevisions(this.val$root);
                                        if (list2 != null && list2.size() > 1) {
                                            MergeAction.printMergeWarning(list2, outputLogger);
                                        }
                                    }
                                    if (this.val$ctx != null) {
                                        HgUtils.forceStatusRefreshProject(this.val$ctx);
                                        break block15;
                                    }
                                    if (this.val$repoRev != null) {
                                        HgUtils.forceStatusRefresh(this.val$root);
                                    }
                                    break block15;
                                }
                                catch (HgException hgException) {
                                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                                    Object var7_10 = null;
                                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                    outputLogger.output("");
                                    Mercurial.getInstance().versionedFilesChanged();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_11 = null;
                                outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                                outputLogger.output("");
                                Mercurial.getInstance().versionedFilesChanged();
                                throw throwable;
                            }
                        }
                        Object var7_7 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                        outputLogger.output("");
                        Mercurial.getInstance().versionedFilesChanged();
                        return;
                    }
                    Object var7_8 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                    outputLogger.output("");
                    Mercurial.getInstance().versionedFilesChanged();
                    return;
                }
                Object var7_9 = null;
                outputLogger.outputInRed(NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_DONE"));
                outputLogger.output("");
                Mercurial.getInstance().versionedFilesChanged();
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(BackoutAction.class, (String)"MSG_BACKOUT_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.isFromHgRepository(this.context);
    }
}

