/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryRevision {
    private HgLogMessage message;
    private File repositoryRoot;
    private final List<Event> events = new ArrayList<Event>(1);

    public RepositoryRevision(HgLogMessage hgLogMessage, File file) {
        this.message = hgLogMessage;
        this.repositoryRoot = file;
        this.initEvents();
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    private void initEvents() {
        HgLogMessageChangedPath[] hgLogMessageChangedPathArray = this.message.getChangedPaths();
        if (hgLogMessageChangedPathArray == null) {
            return;
        }
        for (HgLogMessageChangedPath hgLogMessageChangedPath : hgLogMessageChangedPathArray) {
            this.events.add(new Event(hgLogMessageChangedPath));
        }
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public HgLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLog().getRevision());
        stringBuffer.append("\t");
        stringBuffer.append(this.getLog().getCSetShortID());
        stringBuffer.append("\t");
        stringBuffer.append(this.getLog().getDate());
        stringBuffer.append("\t");
        stringBuffer.append(this.getLog().getAuthor());
        stringBuffer.append("\n");
        stringBuffer.append(this.getLog().getMessage());
        return stringBuffer.toString();
    }

    public class Event {
        private File file;
        private HgLogMessageChangedPath changedPath;
        private String name;
        private String path;

        public Event(HgLogMessageChangedPath hgLogMessageChangedPath) {
            this.changedPath = hgLogMessageChangedPath;
            this.name = hgLogMessageChangedPath.getPath().substring(hgLogMessageChangedPath.getPath().lastIndexOf(47) + 1);
            int n = hgLogMessageChangedPath.getPath().lastIndexOf(47);
            this.path = n > -1 ? hgLogMessageChangedPath.getPath().substring(0, n) : "";
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public HgLogMessageChangedPath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t");
            stringBuffer.append(this.getPath());
            return stringBuffer.toString();
        }
    }
}

